/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.dataset.AverageTableRebinner;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.RebinDescriptor;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSetConsumer;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionListener;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.SymbolLineRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class VerticalSpectrogramAverager
extends DasPlot
implements DataRangeSelectionListener {
    private JDialog popupWindow;
    private Datum yValue;
    private DasPlot parentPlot;
    private SymbolLineRenderer renderer;

    private VerticalSpectrogramAverager(DasPlot plot, DasAxis xAxis, DasAxis yAxis) {
        super(xAxis, yAxis);
        this.parentPlot = plot;
        this.renderer = new SymbolLineRenderer((DataSetDescriptor)null);
        this.addRenderer(this.renderer);
    }

    public static VerticalSpectrogramAverager createAverager(DasPlot plot, TableDataSetConsumer dataSetConsumer) {
        DasAxis sourceYAxis = plot.getYAxis();
        DasAxis xAxis = sourceYAxis.createAttachedAxis(2);
        DasAxis yAxis = dataSetConsumer.getZAxis().createAttachedAxis(3);
        return new VerticalSpectrogramAverager(plot, xAxis, yAxis);
    }

    public void showPopup() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showPopupImpl();
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    VerticalSpectrogramAverager.this.showPopupImpl();
                }
            };
        }
    }

    private void showPopupImpl() {
        if (this.popupWindow == null) {
            this.createPopup();
        }
        this.popupWindow.setVisible(true);
    }

    private void createPopup() {
        int width = this.parentPlot.getCanvas().getWidth() / 2;
        int height = this.parentPlot.getCanvas().getHeight() / 2;
        DasCanvas canvas = new DasCanvas(width, height);
        DasRow row = new DasRow(canvas, 0.1, 0.9);
        DasColumn column = new DasColumn(canvas, 0.1, 0.9);
        canvas.add(this, row, column);
        JPanel content = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        BoxLayout buttonLayout = new BoxLayout(buttonPanel, 0);
        JButton close = new JButton("Hide Window");
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VerticalSpectrogramAverager.this.popupWindow.setVisible(false);
            }
        });
        buttonPanel.setLayout(buttonLayout);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(close);
        content.add((Component)canvas, "Center");
        content.add((Component)buttonPanel, "South");
        Window parentWindow = SwingUtilities.getWindowAncestor(this.parentPlot);
        this.popupWindow = parentWindow instanceof Frame ? new JDialog((Frame)parentWindow) : (parentWindow instanceof Dialog ? new JDialog((Dialog)parentWindow) : new JDialog());
        this.popupWindow.setTitle("Vertical Slicer");
        this.popupWindow.setDefaultCloseOperation(2);
        this.popupWindow.setContentPane(content);
        this.popupWindow.pack();
        Point parentLocation = new Point();
        SwingUtilities.convertPointToScreen(parentLocation, this.parentPlot.getCanvas());
        this.popupWindow.setLocation(parentLocation.x + this.parentPlot.getCanvas().getWidth(), parentLocation.y);
    }

    protected void drawContent(Graphics2D g) {
        super.drawContent(g);
    }

    public void DataRangeSelected(DataRangeSelectionEvent e) {
        DataSet ds = e.getDataSet();
        if (ds == null || !(ds instanceof TableDataSet)) {
            return;
        }
        TableDataSet xtys = (TableDataSet)ds;
        Datum xValue1 = e.getMinimum();
        Datum xValue2 = e.getMaximum();
        if (xValue2.equals(xValue1)) {
            return;
        }
        this.setTitle(new DatumRange(xValue1, xValue2).toString());
        RebinDescriptor ddX = new RebinDescriptor(xValue1, xValue2, 1, false);
        ddX.setOutOfBoundsAction(-3);
        AverageTableRebinner rebinner = new AverageTableRebinner();
        try {
            TableDataSet rebinned = (TableDataSet)rebinner.rebin(xtys, ddX, null);
            VectorDataSet ds1 = rebinned.getXSlice(0);
            this.renderer.setDataSet(ds1);
        }
        catch (DasException de) {
            // empty catch block
        }
        if (this.popupWindow != null && !this.popupWindow.isVisible() || this.getCanvas() == null) {
            this.showPopup();
        } else {
            this.repaint();
        }
    }

    protected void uninstallComponent() {
        super.uninstallComponent();
    }

    protected void installComponent() {
        super.installComponent();
        this.getCanvas().getGlassPane().setVisible(false);
    }
}

