/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.format.TimeDatumFormatter;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;

public class DatumEditor
extends JComponent {
    private JTextField editor;
    private JButton unitsButton;
    private Units units = Units.dimensionless;
    private ActionListener actionListener;

    public DatumEditor() {
        this.initComponents();
        this.installListeners();
        this.initToolTips();
        this.setFocusable(true);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.editor = new JTextField(8);
        this.editor.setFocusable(false);
        this.add((Component)this.editor, "Center");
        this.unitsButton = new JButton();
        this.unitsButton.setFocusable(false);
        this.add((Component)this.unitsButton, "East");
    }

    private void installListeners() {
        UniversalListener ul = new UniversalListener();
        this.editor.addMouseListener(ul);
        this.unitsButton.addMouseListener(ul);
        this.addKeyListener(ul);
        this.addFocusListener(ul);
    }

    private void initToolTips() {
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setColumns(int columns) {
        this.editor.setColumns(columns);
    }

    public void setValue(Datum datum) {
        if (datum.getUnits() instanceof TimeLocationUnits) {
            this.editor.setText(TimeDatumFormatter.DEFAULT.format(datum));
        } else {
            this.editor.setText(datum.getFormatter().format(datum));
        }
        this.setUnits(datum.getUnits());
    }

    public Datum getValue() throws ParseException {
        return this.units.parse(this.editor.getText());
    }

    public void setUnits(Units units) {
        if (units instanceof TimeLocationUnits) {
            this.unitsButton.setVisible(false);
        } else {
            this.unitsButton.setVisible(true);
            this.unitsButton.setText(units.toString());
            this.unitsButton.setToolTipText(units.toString());
        }
        this.units = units;
    }

    public Units getUnits() {
        return this.units;
    }

    private void fireActionPerformed() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "DatumEditor"));
        }
    }

    public void addActionListener(ActionListener al) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, al);
    }

    public void removeActionListener(ActionListener al) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, al);
    }

    public static void main(String[] args) {
        DatumEditor de1 = new DatumEditor();
        de1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("actionPerformed");
            }
        });
        de1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        de1.setValue(TimeUtil.now());
        DatumEditor de2 = new DatumEditor();
        de2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("actionPerformed");
            }
        });
        de2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        de2.setValue(Datum.create(1.0, Units.celcius));
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        content.add(de1);
        content.add(de2);
        JFrame frame = new JFrame("The Window");
        frame.setContentPane(content);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    public String getToolTipText(MouseEvent event) {
        if (this.unitsButton.getBounds().contains(event.getX(), event.getY())) {
            return this.unitsButton.getToolTipText();
        }
        return null;
    }

    private class UniversalListener
    implements MouseListener,
    KeyListener,
    FocusListener {
        private UniversalListener() {
        }

        public void focusGained(FocusEvent e) {
            DatumEditor.this.editor.getCaret().setVisible(true);
            DatumEditor.this.editor.getCaret().setSelectionVisible(true);
        }

        public void focusLost(FocusEvent e) {
            DatumEditor.this.editor.getCaret().setVisible(false);
            DatumEditor.this.editor.getCaret().setSelectionVisible(false);
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                DatumEditor.this.fireActionPerformed();
            } else {
                this.forwardKeyEvent(e);
            }
        }

        public void keyReleased(KeyEvent e) {
            this.forwardKeyEvent(e);
        }

        public void keyTyped(KeyEvent e) {
            this.forwardKeyEvent(e);
        }

        private void forwardKeyEvent(KeyEvent e) {
            e.setSource(DatumEditor.this.editor);
            DatumEditor.this.editor.dispatchEvent(e);
        }

        public void mousePressed(MouseEvent e) {
            DatumEditor.this.requestFocusInWindow();
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }
}

