/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.components.DataPointReporter;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateEvent;
import edu.uiowa.physics.pw.das.dataset.VectorDataSetBuilder;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumUtil;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.datum.format.TimeDatumFormatterFactory;
import edu.uiowa.physics.pw.das.event.CommentDataPointSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataPointSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataPointSelectionListener;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class DataPointRecorder
extends JPanel
implements DataPointSelectionListener {
    protected JTable textArea;
    protected JScrollPane scrollPane;
    protected DataPointReporter reporter;
    protected ArrayList dataPoints = new ArrayList();
    protected Units[] unitsArray;
    protected DatumFormatter[] formatterArray;
    protected AbstractTableModel myTableModel = new MyTableModel();
    private MyDataSetDescriptor dataSetDescriptor;

    public void deleteRow(int row) {
        this.dataPoints.remove(row);
        this.update();
    }

    public DataSetDescriptor getDataSetDescriptor() {
        if (this.dataSetDescriptor == null) {
            this.dataSetDescriptor = new MyDataSetDescriptor();
        }
        return this.dataSetDescriptor;
    }

    public void saveToFile(File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        BufferedWriter r = new BufferedWriter(new OutputStreamWriter(out));
        for (int i = 0; i < this.dataPoints.size(); ++i) {
            DataPoint x = (DataPoint)this.dataPoints.get(i);
            StringBuffer s = new StringBuffer();
            for (int j = 0; j < this.unitsArray.length; ++j) {
                s.append(this.formatterArray[j].format(Datum.create(x.get(j), this.unitsArray[j])) + "\t");
            }
            s.append("\"" + x.getComment() + "\"");
            r.write(s.toString());
            r.newLine();
            DasProperties.getInstance().put("components.DataPointRecorder.lastFileSave", file.toString());
        }
        r.close();
    }

    public void loadFromFile(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        this.dataPoints.clear();
        String line = r.readLine();
        while (line != null) {
            String[] s = line.split("\t");
            for (int i = 0; i < s.length - 1; ++i) {
                Datum x = TimeUtil.isValidTime(s[0]) ? TimeUtil.createValid(s[0]) : DatumUtil.createValid(s[0]);
                Datum y = TimeUtil.isValidTime(s[1]) ? TimeUtil.createValid(s[1]) : DatumUtil.createValid(s[1]);
                String comment = "";
                if (s.length > 2) {
                    comment = s[2];
                    Pattern p = Pattern.compile("\"(.*)\".*");
                    Matcher m = p.matcher(comment);
                    if (m.matches()) {
                        comment = m.group(1);
                    }
                }
                DataPointSelectionEvent e = comment.equals("") ? new DataPointSelectionEvent(this, x, y) : CommentDataPointSelectionEvent.create(new DataPointSelectionEvent(this, x, y), comment);
                this.DataPointSelected(e);
            }
            line = r.readLine();
        }
        DasProperties.getInstance().put("components.DataPointRecorder.lastFileLoad", file.toString());
    }

    public DataPointRecorder() {
        this.setLayout(new BorderLayout());
        this.textArea = new JTable(this.myTableModel);
        this.textArea.addMouseListener(new MyMouseAdapter(this.textArea));
        this.scrollPane = new JScrollPane(this.textArea);
        this.add((Component)this.scrollPane, "Center");
        final JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        JButton saveButton = new JButton("Save...");
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int status;
                JFileChooser jj = new JFileChooser();
                String lastFileString = (String)DasProperties.getInstance().get("components.DataPointRecorder.lastFileSave");
                if (lastFileString == null) {
                    lastFileString = "";
                }
                File lastFile = null;
                if (lastFileString != "") {
                    lastFile = new File(lastFileString);
                    jj.setSelectedFile(lastFile);
                }
                if ((status = jj.showSaveDialog(controlPanel)) == 0) {
                    try {
                        DataPointRecorder.this.saveToFile(jj.getSelectedFile());
                    }
                    catch (IOException e1) {
                        DasExceptionHandler.handle(e1);
                    }
                }
            }
        });
        JButton loadButton = new JButton("Load...");
        loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int status;
                JFileChooser jj = new JFileChooser();
                String lastFileString = (String)DasProperties.getInstance().get("components.DataPointRecorder.lastFileLoad");
                if (lastFileString == null) {
                    lastFileString = "";
                }
                File lastFile = null;
                if (lastFileString != "") {
                    lastFile = new File(lastFileString);
                    jj.setSelectedFile(lastFile);
                }
                if ((status = jj.showOpenDialog(controlPanel)) == 0) {
                    try {
                        DataPointRecorder.this.loadFromFile(jj.getSelectedFile());
                    }
                    catch (IOException e1) {
                        DasExceptionHandler.handle(e1);
                    }
                }
            }
        });
        controlPanel.add(saveButton);
        controlPanel.add(loadButton);
        JButton updateButton = new JButton("Update");
        updateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DataPointRecorder.this.dataSetDescriptor != null) {
                    DataPointRecorder.this.dataSetDescriptor.fireUpdate();
                }
            }
        });
        controlPanel.add(updateButton);
        this.add((Component)controlPanel, "South");
    }

    public static DataPointRecorder createFramed() {
        JFrame frame = new JFrame("Data Point Recorder");
        DataPointRecorder result = new DataPointRecorder();
        frame.getContentPane().add(result);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(2);
        return result;
    }

    public static void main(String[] args) {
        DataPointRecorder p = DataPointRecorder.createFramed();
        p.DataPointSelected(new DataPointSelectionEvent(p, Datum.create(2), Datum.create(6)));
        p.DataPointSelected(new DataPointSelectionEvent(p, Datum.create(4), Datum.create(7)));
        p.DataPointSelected(new DataPointSelectionEvent(p, Datum.create(1), Datum.create(72)));
    }

    protected void update() {
        this.myTableModel.fireTableDataChanged();
        JScrollBar scrollBar = this.scrollPane.getVerticalScrollBar();
        if (scrollBar != null) {
            scrollBar.setValue(scrollBar.getMaximum());
        }
    }

    public void DataPointSelected(DataPointSelectionEvent e) {
        if (this.dataPoints.size() == 0) {
            Datum[] datums = new Datum[]{e.getX(), e.getY()};
            this.unitsArray = new Units[]{e.getX().getUnits(), e.getY().getUnits()};
            this.formatterArray = new DatumFormatter[]{e.getX().getFormatter(), e.getY().getFormatter()};
            for (int j = 0; j < this.unitsArray.length; ++j) {
                if (!(this.unitsArray[j] instanceof TimeLocationUnits)) continue;
                this.formatterArray[j] = TimeDatumFormatterFactory.getInstance().defaultFormatter();
            }
            this.myTableModel.fireTableStructureChanged();
        }
        String comment = "";
        if (e instanceof CommentDataPointSelectionEvent) {
            comment = ((CommentDataPointSelectionEvent)e).getComment();
        }
        this.dataPoints.add(new DataPoint(e.getX().doubleValue(this.unitsArray[0]), e.getY().doubleValue(this.unitsArray[1]), comment));
        this.update();
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        JPopupMenu popup;
        final JTable parent;
        MouseAdapter mm;

        MyMouseAdapter(final JTable parent) {
            this.parent = parent;
            this.popup = new JPopupMenu("Options");
            this.popup.addSeparator();
            JMenuItem menuItem = new JMenuItem("Delete Row");
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int[] selectedRows = parent.getSelectedRows();
                    for (int i = 0; i < selectedRows.length; ++i) {
                        DataPointRecorder.this.deleteRow(selectedRows[i]);
                        int j = i + 1;
                        while (j < selectedRows.length) {
                            int n = j++;
                            selectedRows[n] = selectedRows[n] - 1;
                        }
                    }
                }
            });
            this.popup.add(menuItem);
        }

        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    class MyDataSetDescriptor
    extends DataSetDescriptor {
        MyDataSetDescriptor() {
            super(null);
        }

        public void fireUpdate() {
            this.fireDataSetUpdateEvent(new DataSetUpdateEvent(this));
        }

        protected DataSet getDataSetImpl(Datum s1, Datum s2, Datum s3, DasProgressMonitor monitor) throws DasException {
            if (DataPointRecorder.this.dataPoints.size() == 0) {
                return null;
            }
            VectorDataSetBuilder builder = new VectorDataSetBuilder(DataPointRecorder.this.unitsArray[0], DataPointRecorder.this.unitsArray[1]);
            for (int irow = 0; irow < DataPointRecorder.this.dataPoints.size(); ++irow) {
                DataPoint dp = (DataPoint)DataPointRecorder.this.dataPoints.get(irow);
                builder.insertY(dp.get(0), dp.get(1));
            }
            return builder.toVectorDataSet();
        }

        public Units getXUnits() {
            return DataPointRecorder.this.unitsArray[0];
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        public int getColumnCount() {
            if (DataPointRecorder.this.unitsArray == null) {
                return 3;
            }
            return DataPointRecorder.this.unitsArray.length + 1;
        }

        public String getColumnName(int j) {
            if (j + 1 == this.getColumnCount()) {
                return "comment";
            }
            if (DataPointRecorder.this.unitsArray != null) {
                Units unit = DataPointRecorder.this.unitsArray[j];
                if (unit instanceof TimeLocationUnits) {
                    return ((TimeLocationUnits)unit).getTimeZone();
                }
                return DataPointRecorder.this.unitsArray[j].toString();
            }
            return "" + j;
        }

        public int getRowCount() {
            int nrow = DataPointRecorder.this.dataPoints.size();
            nrow = nrow > 0 ? nrow : 1;
            return DataPointRecorder.this.dataPoints.size();
        }

        public Object getValueAt(int i, int j) {
            DataPoint x = (DataPoint)DataPointRecorder.this.dataPoints.get(i);
            if (j < x.data.length) {
                return DataPointRecorder.this.formatterArray[j].format(Datum.create(x.get(j), DataPointRecorder.this.unitsArray[j]));
            }
            return x.getComment();
        }
    }

    protected class DataPoint {
        double[] data;
        String comment;

        public DataPoint(double x1, double x2, String comment) {
            this(new double[]{x1, x2}, comment);
        }

        public DataPoint(double[] data, String comment) {
            this.data = data;
            this.comment = comment;
        }

        double get(int i) {
            return this.data[i];
        }

        String getComment() {
            return this.comment;
        }

        public String toString() {
            return "" + this.data[0] + " " + this.data[1] + (this.comment.equals("") ? "" : " # " + this.comment);
        }
    }
}

