/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class DasProgressPanel
extends JPanel
implements DasProgressMonitor {
    private long taskStartedTime;
    private long currentTaskPosition;
    private long maximumTaskPosition;
    private DecimalFormat transferRateFormat;
    private String transferRateString;
    private JLabel messageLabel;
    private JLabel kbLabel;
    private JProgressBar progressBar;
    private JFrame jframe;
    private boolean isCancelled = false;
    private String label;
    private static final int hideInitiallyMilliSeconds = 1500;
    private long lastTaskTime;
    private boolean running = false;
    private long lastRefreshTime;
    private ArrayList refreshTimeQueue;
    private boolean showProgressRate;

    public DasProgressPanel(String label) {
        this.label = label;
        this.setOpaque(false);
        this.initComponents();
        this.transferRateFormat = new DecimalFormat();
        this.transferRateFormat.setMaximumFractionDigits(2);
        this.maximumTaskPosition = -1L;
        this.lastTaskTime = Integer.MAX_VALUE;
    }

    public static DasProgressPanel createComponentPanel(DasCanvasComponent component, String initialMessage) {
        DasProgressPanel progressPanel = new DasProgressPanel(initialMessage);
        progressPanel.setSize(progressPanel.getPreferredSize());
        int x = component.getColumn().getDMiddle();
        int y = component.getRow().getDMiddle();
        progressPanel.setLocation(x - progressPanel.getWidth() / 2, y - progressPanel.getHeight() / 2);
        ((Container)component.getCanvas().getGlassPane()).add(progressPanel);
        return progressPanel;
    }

    public boolean isValidateRoot() {
        return true;
    }

    public static DasProgressPanel createFramed(String label) {
        DasProgressPanel result = new DasProgressPanel(label);
        result.jframe = new JFrame("Das Progress Monitor");
        result.jframe.getContentPane().add(result);
        result.jframe.pack();
        result.jframe.setVisible(true);
        result.jframe.setDefaultCloseOperation(2);
        return result;
    }

    public void setLabel(String label) {
        this.messageLabel.setText(label);
        this.label = label;
        this.repaint();
    }

    public String getLabel() {
        return this.label;
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        this.messageLabel.setOpaque(false);
        this.messageLabel.setFont(new Font("Dialog", 1, 18));
        this.messageLabel.setHorizontalAlignment(0);
        this.messageLabel.setText(this.label);
        this.messageLabel.setAlignmentX(0.5f);
        this.progressBar = new JProgressBar();
        this.progressBar.setOpaque(false);
        this.progressBar.setMaximumSize(this.progressBar.getPreferredSize());
        this.progressBar.setMinimumSize(this.progressBar.getPreferredSize());
        this.progressBar.setAlignmentX(0.5f);
        this.kbLabel = new JLabel();
        this.kbLabel.setOpaque(false);
        this.kbLabel.setHorizontalAlignment(0);
        this.kbLabel.setText("0 kb");
        this.kbLabel.setAlignmentX(0.5f);
        this.kbLabel.setMaximumSize(this.progressBar.getPreferredSize());
        this.kbLabel.setMinimumSize(this.progressBar.getPreferredSize());
        this.kbLabel.setPreferredSize(this.progressBar.getPreferredSize());
        this.kbLabel.setAlignmentX(0.5f);
        JPanel mainPanel = new JPanel();
        mainPanel.setOpaque(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.messageLabel);
        mainPanel.add(this.progressBar);
        mainPanel.add(this.kbLabel);
        LineBorder lineBorder = new LineBorder(Color.BLACK, 2);
        EmptyBorder emptyBorder = new EmptyBorder(2, 2, 2, 2);
        CompoundBorder border = new CompoundBorder(lineBorder, emptyBorder);
        JButton cancelButton = new JButton("cancel");
        cancelButton.setOpaque(false);
        cancelButton.setBorder(border);
        cancelButton.setFocusPainted(false);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DasProgressPanel.this.cancel();
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setOpaque(false);
        buttonPanel.add(cancelButton);
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
        this.add((Component)buttonPanel, "South");
    }

    public void finished() {
        this.running = false;
        this.lastTaskTime = System.currentTimeMillis() - this.taskStartedTime;
        if (this.jframe == null) {
            this.setVisible(false);
        } else {
            this.jframe.dispose();
        }
    }

    public void setTaskProgress(long position) throws IllegalStateException {
        if (this.isCancelled) {
            DasApplication.getDefaultApplication().getLogger().fine("setTaskProgress called when isCancelled true, check isCancelled before calling setTaskProgress?");
            throw new IllegalStateException("Operation cancelled: developers: check isCancelled before calling setTaskProgress");
        }
        long elapsedTimeMs = System.currentTimeMillis() - this.taskStartedTime;
        if (elapsedTimeMs > 1500L && !this.isVisible()) {
            this.setVisible(true);
        }
        long kb = this.currentTaskPosition = position;
        if (this.maximumTaskPosition > 0L) {
            this.progressBar.setValue((int)(kb * 100L / this.maximumTaskPosition));
        } else {
            this.progressBar.setValue((int)kb % 100);
        }
        String bytesReadLabel = this.maximumTaskPosition > 0L ? "" + kb + "/" + this.maximumTaskPosition + "" : "" + kb + "";
        if (this.showProgressRate && elapsedTimeMs > 1000L) {
            double transferRate = (double)position * 1000.0 / (double)elapsedTimeMs;
            this.kbLabel.setText(bytesReadLabel + " (" + this.transferRateFormat.format(transferRate) + "/s)");
        } else {
            this.kbLabel.setText(bytesReadLabel);
        }
        long tnow = System.currentTimeMillis();
        if (tnow - this.lastRefreshTime > 100L) {
            Toolkit.getDefaultToolkit().getSystemEventQueue();
            if (EventQueue.isDispatchThread()) {
                this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
            } else {
                this.repaint();
            }
            this.lastRefreshTime = tnow;
        }
    }

    public void setAdditionalInfo(String s) {
        this.transferRateString = s;
    }

    public long getTaskProgress() {
        return this.currentTaskPosition;
    }

    public void setTaskSize(long taskSize) {
        if (taskSize == -1L) {
            this.progressBar.setIndeterminate(true);
        } else {
            if (taskSize < 1L) {
                throw new IllegalArgumentException("taskSize must be positive, or -1");
            }
            this.progressBar.setIndeterminate(false);
        }
        this.maximumTaskPosition = taskSize;
    }

    public void started() {
        this.taskStartedTime = System.currentTimeMillis();
        this.currentTaskPosition = 0L;
        this.isCancelled = false;
        this.running = true;
        DasApplication.getDefaultApplication().getLogger().fine("lastTaskTime=" + this.lastTaskTime);
        if ((double)this.lastTaskTime > 3000.0) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (DasProgressPanel.this.running) {
                        DasApplication.getDefaultApplication().getLogger().fine("hide time=" + (System.currentTimeMillis() - DasProgressPanel.this.taskStartedTime));
                        DasProgressPanel.this.setTaskProgress(DasProgressPanel.this.getTaskProgress());
                    }
                }
            }).start();
        }
    }

    public void cancel() {
        this.isCancelled = true;
        this.finished();
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    protected void paintComponent(Graphics g1) {
        Graphics2D g2 = (Graphics2D)g1;
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        g2.setColor(new Color(-587202561, true));
        Rectangle rect = g2.getClipBounds();
        if (rect == null) {
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
        super.paintComponent(g1);
    }

    public void setShowProgressRate(boolean showProgressRate) {
        this.showProgressRate = showProgressRate;
    }
}

