/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das;

import edu.uiowa.physics.pw.das.DasIOException;
import edu.uiowa.physics.pw.das.util.Crypt;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.awt.Component;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class DasProperties
extends Properties {
    private RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private boolean antiAlias;
    private boolean visualCues;
    private Logger logger;
    private static ArrayList propertyOrder;
    private static Editor editor;
    private static JFrame jframe;
    public static final DasProperties instance;
    static /* synthetic */ Class class$java$lang$Object;

    private DasProperties() {
        this.hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.setDefaults();
        propertyOrder = new ArrayList();
        this.readPersistentProperties();
        this.logger = Logger.getLogger("das2");
        this.setPropertyOrder();
    }

    private void setPropertyOrder() {
        propertyOrder.add(0, "username");
        propertyOrder.add(1, "password");
        propertyOrder.add(2, "debugLevel");
        propertyOrder.add(3, "antiAlias");
        propertyOrder.add(4, "visualCues");
        Iterator<Object> i = this.keySet().iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            if (propertyOrder.contains(s)) continue;
            propertyOrder.add(s);
        }
    }

    private void setDefaults() {
        this.setProperty("username", "");
        this.setProperty("password", "");
        this.setProperty("debugLevel", "endUser");
        this.setProperty("antiAlias", "off");
        this.setProperty("visualCues", "off");
        this.setProperty("defaultServer", "http://www-pw.physics.uiowa.edu/das/dasServer");
    }

    public static RenderingHints getRenderingHints() {
        return DasProperties.instance.hints;
    }

    public static Logger getLogger() {
        return DasProperties.instance.logger;
    }

    public static DasProperties getInstance() {
        return instance;
    }

    private static TableModel getTableModel() {
        return new DasPropertiesTableModel();
    }

    private static JTable getJTable() {
        return new JTable(DasProperties.getTableModel()){
            {
                this.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = DasProperties.class$("java.lang.Object")) : class$java$lang$Object, new DefaultTableCellRenderer(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        String propertyName = (String)DasProperties.access$000().get(row);
                        if (propertyName.equals("password") && column == 1) {
                            return super.getTableCellRendererComponent(table, "* * * *", isSelected, hasFocus, row, column);
                        }
                        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    }
                });
            }

            public TableCellEditor getCellEditor(int row, int col) {
                String propertyName = (String)propertyOrder.get(row);
                if (propertyName.equals("password")) {
                    return new DefaultCellEditor(new JPasswordField());
                }
                if (propertyName.equals("debugLevel")) {
                    String[] data = new String[]{"endUser", "dasDeveloper"};
                    return new DefaultCellEditor(new JComboBox<String>(data));
                }
                if (propertyName.equals("antiAlias")) {
                    String[] data = new String[]{"on", "off"};
                    return new DefaultCellEditor(new JComboBox<String>(data));
                }
                if (propertyName.equals("visualCues")) {
                    String[] data = new String[]{"on", "off"};
                    return new DefaultCellEditor(new JComboBox<String>(data));
                }
                return super.getCellEditor(row, col);
            }
        };
    }

    private static TableCellEditor getTableCellEditor() {
        return new DefaultCellEditor(new JTextField()){

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                String propertyName = (String)propertyOrder.get(row);
                if (propertyName.equals("password")) {
                    return new JPasswordField();
                }
                if (propertyName.equals("debugLevel")) {
                    String[] data = new String[]{"endUser", "dasDeveloper"};
                    return new JList<String>(data);
                }
                return super.getTableCellEditorComponent(table, value, isSelected, row, column);
            }
        };
    }

    public static void showEditor() {
        jframe = new JFrame("Das Properities");
        editor = new Editor();
        jframe.setSize(400, 300);
        jframe.setContentPane(editor);
        jframe.setVisible(true);
    }

    public void readPersistentProperties() {
        try {
            String file = System.getProperty("user.home") + System.getProperty("file.separator") + ".das2rc";
            File f = new File(file);
            if (f.canRead()) {
                try {
                    FileInputStream in = new FileInputStream(f);
                    this.load(in);
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    DasExceptionHandler.handle(e);
                }
            } else {
                try {
                    FileOutputStream out = new FileOutputStream(f);
                    this.store(out, "");
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    DasExceptionHandler.handle(e);
                }
            }
        }
        catch (SecurityException ex) {
            DasDie.println(DasDie.INFORM, "Unable to read persistent properties");
        }
    }

    public void writePersistentProperties() {
        String file = System.getProperty("user.home") + System.getProperty("file.separator") + ".das2rc";
        File f = new File(file);
        if (f.canWrite()) {
            DasDie.println("Attempt to write .das2rc...");
            try {
                FileOutputStream out = new FileOutputStream(f);
                this.store(out, "");
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                DasExceptionHandler.handle(e);
            }
        } else {
            DasIOException e = new DasIOException("Can't write to file " + f);
            DasExceptionHandler.handle(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        instance = new DasProperties();
    }

    public static class Editor
    extends JPanel
    implements ActionListener {
        JButton saveButton;

        Editor() {
            this.setLayout(new BoxLayout(this, 1));
            JTable jtable = DasProperties.getJTable();
            this.add(jtable);
            JPanel controlPanel = new JPanel();
            controlPanel.setLayout(new BoxLayout(controlPanel, 0));
            controlPanel.add(Box.createHorizontalGlue());
            this.saveButton = new JButton("Save");
            this.saveButton.setActionCommand("Save");
            this.saveButton.addActionListener(this);
            this.saveButton.setToolTipText("save to $HOME/.das2rc");
            controlPanel.add(this.saveButton);
            JButton b = new JButton("Dismiss");
            b.addActionListener(this);
            controlPanel.add(b);
            this.add(Box.createVerticalGlue());
            this.add(controlPanel);
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("Save")) {
                instance.writePersistentProperties();
                this.setDirty(false);
            } else if (command.equals("Dismiss")) {
                jframe.dispose();
            }
        }

        public void setDirty(boolean dirty) {
            if (dirty) {
                this.saveButton.setText("Save*");
            } else {
                this.saveButton.setText("Save");
            }
        }
    }

    private static class DasPropertiesTableModel
    extends AbstractTableModel {
        private DasPropertiesTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return instance.size();
        }

        public Object getValueAt(int row, int col) {
            String value;
            String propertyName = (String)propertyOrder.get(row);
            if (col == 0) {
                value = propertyName;
            } else {
                value = instance.getProperty(propertyName);
                if (propertyName.equals("password")) {
                    value = "";
                }
            }
            return value;
        }

        public void setValueAt(Object value, int row, int col) {
            String propertyName = (String)propertyOrder.get(row);
            if (propertyName.equals("password")) {
                if (!value.toString().equals("")) {
                    value = Crypt.crypt(value.toString());
                }
            } else if (propertyName.equals("debugLevel")) {
                String debugLevel = value.toString();
                if (debugLevel.equals("endUser")) {
                    instance.logger.setLevel(Level.WARNING);
                } else if (debugLevel.equals("dasDeveloper")) {
                    instance.logger.setLevel(Level.ALL);
                } else {
                    instance.logger.setLevel(Level.parse(debugLevel));
                }
                DasDie.setDebugVerbosityLevel(value.toString());
            }
            instance.setProperty(propertyName, value.toString());
            editor.setDirty(true);
        }

        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }
    }
}

