/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.corpws;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasIOException;
import edu.uiowa.physics.pw.das.client.DataSetDescriptorNotAvailableException;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSetBuilder;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SummaryDataSetDescriptor
extends DataSetDescriptor {
    private static SortedMap DATE_MAP;
    public static Datum DATA_START;
    private static final Charset CHARSET;
    private static File tableFileDirectory;
    private static final double[] eFrequencies;
    private static final double[] mFrequencies;
    private static final Datum xSampleWidth;
    private char eOrB;
    private DatumVector y_coordinate;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$apps$corpws$SummaryDataSetDescriptor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseTableFile(File file) throws IOException {
        Comparator datumComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                Datum d1 = (Datum)o1;
                Datum d2 = (Datum)o2;
                if (d1 == d2 || d1.equals(d2)) {
                    return 0;
                }
                return !d1.lt(d2) ? 1 : -1;
            }
        };
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), CHARSET));
        DATE_MAP = new TreeMap(datumComparator);
        try {
            String line = reader.readLine();
            while (line != null) {
                StringTokenizer st = new StringTokenizer(line);
                String dateString = st.nextToken();
                String fileString = st.nextToken();
                Datum date = TimeUtil.createValid(dateString);
                if (DATA_START == null) {
                    DATA_START = date;
                }
                File dataFile = new File(file.getParentFile(), fileString);
                DATE_MAP.put(date, dataFile);
                line = reader.readLine();
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private SummaryDataSetDescriptor(String type) throws DataSetDescriptorNotAvailableException {
        if ("e".equals(type)) {
            this.eOrB = (char)101;
            this.y_coordinate = DatumVector.newDatumVector(eFrequencies, Units.dimensionless);
        } else if ("b".equals(type)) {
            this.eOrB = (char)98;
            this.y_coordinate = DatumVector.newDatumVector(mFrequencies, Units.dimensionless);
        } else {
            throw new DataSetDescriptorNotAvailableException("dataset must be either e or b");
        }
    }

    private TableDataSet rebin(TableDataSet in, Datum resolution) {
        return in;
    }

    private void append(TableDataSetBuilder builder, TableDataSet ds) {
    }

    public DataSet getDataSetImpl(Datum start, Datum end, Datum resolution, DasProgressMonitor monitor) throws DasException {
        boolean rebin = resolution.gt(Datum.create(60.0, Units.seconds));
        SortedMap subMap = DATE_MAP.subMap(start.subtract(Datum.create(TimeUtil.getSecondsSinceMidnight(start), Units.seconds)), end);
        if (subMap.size() == 0) {
            throw new DasIOException("No data in interval");
        }
        TableDataSetBuilder builder = new TableDataSetBuilder(Units.t2000, Units.dimensionless, Units.dimensionless);
        Iterator i = subMap.values().iterator();
        while (i.hasNext()) {
            File f = (File)i.next();
            try {
                this.getDataSetForFile(f, builder);
            }
            catch (IOException ioe) {
                DasIOException die = new DasIOException(ioe.getMessage());
                die.initCause(ioe);
                throw die;
            }
        }
        return builder.toTableDataSet();
    }

    public static DataSetDescriptor newDataSetDescriptor(Map attributes) throws DataSetDescriptorNotAvailableException {
        String dataset = (String)attributes.get("dataset");
        return new SummaryDataSetDescriptor(dataset);
    }

    private void getDataSetForFile(File f, TableDataSetBuilder builder) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
        ArrayList zList = new ArrayList();
        ArrayList dateList = new ArrayList();
        in.readLine();
        String line = in.readLine();
        while (line != null) {
            StringTokenizer tokenizer = new StringTokenizer(line, "\" ");
            Datum time = TimeUtil.createValid(tokenizer.nextToken());
            tokenizer.nextToken();
            String[] floatDataArray = new String[tokenizer.countTokens()];
            for (int i = 0; i < floatDataArray.length; ++i) {
                floatDataArray[i] = tokenizer.nextToken();
            }
            double[] z = new double[this.y_coordinate.getLength()];
            int offset = this.eOrB != 'e' ? 73 : 0;
            for (int i = 0; i < z.length; ++i) {
                z[i] = Double.parseDouble(floatDataArray[i + offset]);
            }
            builder.insertYScan(time, this.y_coordinate, DatumVector.newDatumVector(z, Units.dimensionless));
            builder.setProperty("xSampleWidth", xSampleWidth);
            line = in.readLine();
        }
    }

    public Units getXUnits() {
        return Units.t2000;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CHARSET = Charset.forName("ISO-8859-1");
        eFrequencies = new double[]{1.0, 1.259, 1.585, 1.995, 2.512, 3.162, 3.981, 5.012, 6.31, 7.943, 10.0, 12.59, 15.85, 19.95, 25.12, 31.62, 39.81, 50.12, 63.1, 79.43, 100.0, 125.9, 158.5, 199.5, 251.2, 316.2, 398.1, 501.2, 631.0, 794.3, 1000.0, 1259.0, 1585.0, 1995.0, 2512.0, 3162.0, 3981.0, 5012.0, 6310.0, 7943.0, 10000.0, 12590.0, 15850.0, 19950.0, 25120.0, 31620.0, 39810.0, 50120.0, 63100.0, 79430.0, 100000.0, 125900.0, 158500.0, 199500.0, 251200.0, 316200.0, 398100.0, 501200.0, 631000.0, 794300.0, 1000000.0, 1259000.0, 1585000.0, 1995000.0, 2512000.0, 3162000.0, 3981000.0, 5012000.0, 6310000.0, 7943000.0, 1.0E7, 1.259E7, 1.585E7};
        mFrequencies = new double[]{1.0, 1.259, 1.585, 1.995, 2.512, 3.162, 3.981, 5.012, 6.31, 7.943, 10.0, 12.59, 15.85, 19.95, 25.12, 31.62, 39.81, 50.12, 63.1, 79.43, 100.0, 125.9, 158.5, 199.5, 251.2, 316.2, 398.1, 501.2, 631.0, 794.3, 1000.0, 1259.0, 1585.0, 1995.0, 2512.0, 3162.0, 3981.0, 5012.0, 6310.0, 7943.0, 10000.0, 12590.0};
        xSampleWidth = Datum.create(120, Units.seconds);
        URL url = (class$edu$uiowa$physics$pw$apps$corpws$SummaryDataSetDescriptor == null ? (class$edu$uiowa$physics$pw$apps$corpws$SummaryDataSetDescriptor = SummaryDataSetDescriptor.class$("edu.uiowa.physics.pw.apps.corpws.SummaryDataSetDescriptor")) : class$edu$uiowa$physics$pw$apps$corpws$SummaryDataSetDescriptor).getResource("SummaryDataSetDescriptor.class");
        String urlString = url.toExternalForm();
        Pattern inJarPattern = Pattern.compile("jar:file:(.*)/.+?\\.(jar|JAR)!.*");
        Matcher inJarMatcher = inJarPattern.matcher(urlString);
        if (inJarMatcher.matches()) {
            urlString = inJarMatcher.group(1);
            try {
                tableFileDirectory = new File(URLDecoder.decode(urlString, "UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException(uee);
            }
        } else {
            throw new RuntimeException("Could not resolve jar file location from URL: " + urlString);
        }
        File tableFile = new File(tableFileDirectory, "KEY_BROWSE.TXT");
        if (!tableFile.exists()) {
            throw new RuntimeException("No such file: " + tableFile.getAbsolutePath());
        }
        try {
            SummaryDataSetDescriptor.parseTableFile(tableFile);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

