/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util.fileSystem;

import edu.uiowa.physics.pw.das.util.fileSystem.FileObject;
import edu.uiowa.physics.pw.das.util.fileSystem.FileSystem;
import edu.uiowa.physics.pw.das.util.fileSystem.LocalFileObject;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.regex.Pattern;

public class LocalFileSystem
extends FileSystem {
    File localRoot;

    protected LocalFileSystem(URL root) {
        if (!"file".equals(root.getProtocol())) {
            throw new IllegalArgumentException("protocol not file: " + root);
        }
        this.localRoot = new File(root.getFile());
        if (!this.localRoot.exists()) {
            throw new IllegalArgumentException("root does not exist: " + root);
        }
    }

    public FileObject getFile(String filename) {
        return new LocalFileObject(this, this.localRoot, filename);
    }

    public boolean isDirectory(String filename) {
        return new File(this.localRoot, filename).isDirectory();
    }

    String getLocalName(File file) {
        if (!file.toString().startsWith(this.localRoot.toString())) {
            throw new IllegalArgumentException("file \"" + file + "\"is not of this web file system");
        }
        String filename = file.toString().substring(this.localRoot.toString().length());
        filename = filename.replaceAll("\\\\", "/");
        return filename;
    }

    public String[] listDirectory(String directory) {
        File f = new File(this.localRoot, directory);
        return f.list();
    }

    public String[] listDirectory(String directory, String regex) {
        File f = new File(this.localRoot, directory);
        final Pattern pattern = Pattern.compile(regex);
        return f.list(new FilenameFilter(){

            public boolean accept(File file, String name) {
                return pattern.matcher(name).matches();
            }
        });
    }

    public String toString() {
        return "lfs " + this.localRoot;
    }
}

