/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util.fileSystem;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class HtmlUtil {
    public static boolean isDirectory(URL url) {
        String file = url.getFile();
        return file.charAt(file.length() - 1) != '/';
    }

    public static URL[] getDirectoryListing(URL url) throws IOException {
        String file = url.getFile();
        if (file.charAt(file.length() - 1) != '/') {
            url = new URL(url.toString() + '/');
        }
        ArrayList<URL> urlList = new ArrayList<URL>();
        URLConnection urlConnection = url.openConnection();
        urlConnection.setAllowUserInteraction(false);
        InputStream urlStream = url.openStream();
        byte[] b = new byte[1000];
        int numRead = urlStream.read(b);
        String content = new String(b, 0, numRead);
        while (numRead != -1) {
            numRead = urlStream.read(b);
            if (numRead == -1) continue;
            String newContent = new String(b, 0, numRead);
            content = content + newContent;
        }
        urlStream.close();
        String lowerCaseContent = content.toLowerCase();
        int index = 0;
        while ((index = lowerCaseContent.indexOf("<a", index)) != -1 && (index = lowerCaseContent.indexOf("href", index)) != -1 && (index = lowerCaseContent.indexOf("=", index)) != -1) {
            String remaining = content.substring(++index);
            StringTokenizer st = new StringTokenizer(remaining, "\t\n\r\">#");
            String strLink = st.nextToken();
            URL urlLink = null;
            try {
                urlLink = new URL(url, strLink);
                strLink = urlLink.toString();
            }
            catch (MalformedURLException e) {
                System.err.println("bad URL: " + url + " " + strLink);
                continue;
            }
            if (!urlLink.toString().startsWith(url.toString()) || null != urlLink.getQuery()) continue;
            urlList.add(urlLink);
        }
        return urlList.toArray(new URL[urlList.size()]);
    }

    public static void htmlUtilTest() throws Exception {
        URL[] urls = HtmlUtil.getDirectoryListing(new URL("http://www-pw.physics.uiowa.edu/voyager/local2/DATA/FULL/"));
        for (int i = 0; i < urls.length; ++i) {
            System.out.println("" + urls[i]);
        }
    }

    public static void main(String[] args) throws Exception {
        HtmlUtil.htmlUtilTest();
    }
}

