/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util.fileSystem;

import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.fileSystem.FileObject;
import edu.uiowa.physics.pw.das.util.fileSystem.HttpFileSystem;
import edu.uiowa.physics.pw.das.util.fileSystem.LocalFileSystem;
import java.io.IOException;
import java.net.URL;

public abstract class FileSystem {
    public static FileSystem create(URL root) throws IOException {
        if ("file".equals(root.getProtocol())) {
            return new LocalFileSystem(root);
        }
        if ("http".equals(root.getProtocol())) {
            return HttpFileSystem.createHttpFileSystem(root);
        }
        throw new IllegalArgumentException("unsupported protocol: " + root);
    }

    public static String getRegexFromGlob(String glob) {
        String regex = glob.replaceAll("\\.", "\\\\.").replaceAll("\\*", "\\.\\*").replaceAll("\\?", "\\.");
        return regex;
    }

    protected void handleException(Exception e) {
        DasExceptionHandler.handle(e);
    }

    protected static String toCanonicalFilename(String filename) {
        if ((filename = filename.replaceAll("\\\\", "/")).length() == 0 || filename.charAt(0) != '/') {
            filename = "/" + filename;
        }
        return filename;
    }

    public abstract FileObject getFile(String var1);

    public abstract boolean isDirectory(String var1);

    public abstract String[] listDirectory(String var1);

    public abstract String[] listDirectory(String var1, String var2);
}

