/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util.awt;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import edu.uiowa.physics.pw.das.util.awt.GraphicsOutput;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.OutputStream;

public class PdfGraphicsOutput
implements GraphicsOutput {
    private float width;
    private float height;
    private OutputStream out;
    private Document doc;
    private PdfWriter writer;
    private PdfContentByte cb;
    private Graphics2D graphics;

    public Graphics2D getGraphics2D() {
        if (this.graphics != null) {
            return this.graphics;
        }
        this.graphics = this.cb.createGraphics(this.width, this.height);
        return this.graphics;
    }

    public void finish() throws IOException {
        this.graphics.dispose();
        this.cb.restoreState();
        this.doc.close();
    }

    public Graphics getGraphics() {
        return this.getGraphics2D();
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void start() {
        try {
            Rectangle rect = new Rectangle(this.width, this.height);
            this.doc = new Document(rect, 0.0f, 0.0f, 0.0f, 0.0f);
            this.writer = PdfWriter.getInstance(this.doc, this.out);
            this.doc.open();
            this.cb = this.writer.getDirectContent();
            this.cb.saveState();
        }
        catch (DocumentException de) {
            throw new RuntimeException(de);
        }
    }
}

