/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSetBuilder;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.DatumRangeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.event.DumpToFileMouseModule;
import edu.uiowa.physics.pw.das.graph.DasAnnotation;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.Legend;
import edu.uiowa.physics.pw.das.graph.Leveler;
import edu.uiowa.physics.pw.das.graph.Psym;
import edu.uiowa.physics.pw.das.graph.SymColor;
import edu.uiowa.physics.pw.das.graph.SymbolLineRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Probe {
    final long refreshRateMillis = 1000L;
    HashMap histograms;
    HashMap agents;
    Legend legend;
    Leveler leveler;
    DasCanvas canvas;
    DasAnnotation titleAnnotation;
    DatumRange xrange;
    DatumRange yrange;
    DasColumn column;
    DasAxis xAxis;
    boolean isWidgetCreated;
    JFrame frame;
    String title;
    boolean isNull;
    long t0millis;
    boolean needUpdate = false;
    boolean updating = true;
    private int xsize;
    private int ysize;

    public DasCanvas getCanvas() {
        if (this.isNull) {
            throw new IllegalArgumentException("getCanvas called for null canvas");
        }
        return this.canvas;
    }

    public void reset() {
        if (this.isNull) {
            return;
        }
        if (this.agents == null) {
            this.agents = new HashMap();
        }
        Iterator i = this.agents.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Agent a = (Agent)this.agents.get(key);
            a.destroy();
        }
        this.agents = new HashMap();
        this.t0millis = System.currentTimeMillis();
        this.needUpdate = true;
    }

    private DatumRange include(DatumRange dr, Datum d) {
        if (dr.contains(d)) {
            return dr;
        }
        if (d.lt(dr.min())) {
            while (!dr.contains(d)) {
                dr = dr.rescale(-1.0, 1.0);
            }
        } else {
            while (!dr.contains(d)) {
                dr = dr.rescale(0.0, 2.0);
            }
        }
        return dr;
    }

    public synchronized void add(String name, int value) {
        Agent a;
        if (this.isNull) {
            return;
        }
        if (Double.isInfinite(value)) {
            throw new IllegalStateException("value is not finite: " + name);
        }
        if (!this.agents.containsKey(name)) {
            this.maybeCreateWidget();
            a = new Agent(name, this.agents.size(), null);
            this.agents.put(name, a);
        } else {
            a = (Agent)this.agents.get(name);
        }
        a.add(value);
    }

    public synchronized void add(String name, double value) {
        Agent a;
        if (this.isNull) {
            return;
        }
        if (Double.isInfinite(value)) {
            throw new IllegalStateException("value is not finite: " + name);
        }
        if (!this.agents.containsKey(name)) {
            this.maybeCreateWidget();
            a = new Agent(name, this.agents.size(), null);
            this.agents.put(name, a);
        } else {
            a = (Agent)this.agents.get(name);
        }
        a.add(value);
    }

    public synchronized void addOverplot(String overplotName, String underplotName, double value) {
        Agent a;
        if (this.isNull) {
            return;
        }
        if (Double.isInfinite(value)) {
            throw new IllegalStateException("value is not finite: " + overplotName);
        }
        if (!this.agents.containsKey(overplotName)) {
            this.maybeCreateWidget();
            Agent underplotAgent = (Agent)this.agents.get(underplotName);
            a = underplotAgent == null ? new Agent(overplotName, this.agents.size(), null) : new Agent(overplotName, this.agents.size(), underplotAgent);
            this.agents.put(overplotName, a);
        } else {
            a = (Agent)this.agents.get(overplotName);
        }
        a.add(value);
    }

    public synchronized void addOverplot(String overplotName, String underplotName, int value) {
        Agent a;
        if (this.isNull) {
            return;
        }
        if (!this.agents.containsKey(overplotName)) {
            this.maybeCreateWidget();
            Agent underplotAgent = (Agent)this.agents.get(underplotName);
            a = underplotAgent == null ? new Agent(overplotName, this.agents.size(), null) : new Agent(overplotName, this.agents.size(), underplotAgent);
            this.agents.put(overplotName, a);
        } else {
            a = (Agent)this.agents.get(overplotName);
        }
        a.add(value);
    }

    private void startUpdateThread() {
        if (this.updating) {
            new Thread(new Runnable(){

                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        if (!(Probe.this.updating & Probe.this.isWidgetCreated)) continue;
                        Probe.this.update();
                    }
                }
            }, "probeUpdateThread").start();
        }
    }

    public synchronized void update() {
        if (this.isNull) {
            return;
        }
        if (this.isWidgetCreated && this.needUpdate) {
            Iterator i = this.agents.keySet().iterator();
            while (i.hasNext()) {
                Object name = i.next();
                Agent a = (Agent)this.agents.get(name);
                a.update();
            }
        }
        this.needUpdate = false;
    }

    private Action getUpdateAction() {
        return new AbstractAction("Update"){

            public void actionPerformed(ActionEvent e) {
                Probe.this.update();
            }
        };
    }

    private void maybeCreateWidget() {
        if (this.isWidgetCreated) {
            return;
        }
        this.frame = DasApplication.getDefaultApplication().getMainFrame();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.canvas = new DasCanvas(this.xsize, this.ysize);
        panel.add((Component)this.canvas, "Center");
        panel.add((Component)new JButton(this.getUpdateAction()), "North");
        this.column = new DasColumn(this.canvas, 0.15, 0.9);
        this.frame.setContentPane(panel);
        this.frame.setVisible(true);
        this.frame.pack();
        this.frame.setDefaultCloseOperation(3);
        this.leveler = new Leveler(this.canvas);
        this.titleAnnotation = new DasAnnotation(this.title);
        this.canvas.add(this.titleAnnotation, new DasRow(this.canvas, 0.0, 0.05), new DasColumn(this.canvas, 0.0, 1.0));
        this.canvas.revalidate();
        this.isWidgetCreated = true;
        this.startUpdateThread();
    }

    public void setUpdating(boolean updating) {
        this.updating = updating;
    }

    private Probe(String title, boolean notNull, int xsize, int ysize) {
        this.title = title;
        this.isWidgetCreated = false;
        this.updating = notNull;
        this.isNull = !notNull;
        this.xsize = xsize;
        this.ysize = ysize;
        this.reset();
    }

    public static Probe newProbe(String title) {
        return new Probe(title, true, 400, 600);
    }

    public static Probe newProbe(int xsize, int ysize) {
        return new Probe("Probe", true, xsize, ysize);
    }

    public static Probe nullProbe() {
        return new Probe("", false, 400, 400);
    }

    public static void main(String[] args) throws Exception {
        Probe p = new Probe("Test of Probe with fake data", true, 400, 600);
        Thread.sleep(2000L);
        for (int i = 0; i < 100; ++i) {
            Thread.sleep(200L);
            p.add("i", i);
            p.add("j", i % 10);
        }
    }

    public int getXsize() {
        return this.xsize;
    }

    public void setXsize(int xsize) {
        this.xsize = xsize;
    }

    public int getYsize() {
        return this.ysize;
    }

    public void setYsize(int ysize) {
        this.ysize = ysize;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.titleAnnotation != null) {
            this.titleAnnotation.setText(title);
        }
    }

    private class Agent {
        VectorDataSetBuilder builder = new VectorDataSetBuilder(Units.dimensionless, Units.dimensionless);
        SymbolLineRenderer renderer = new SymbolLineRenderer((DataSet)null);
        DasPlot plot;
        DatumRange xrange;
        DatumRange yrange;
        boolean histogram = false;
        int hits;
        Legend legend;
        String name;

        Agent(String name, int index, Agent underplotAgent) {
            DasAxis thisXAxis;
            this.name = name;
            this.xrange = new DatumRange(Datum.create(0), Datum.create(1));
            this.yrange = DatumRangeUtil.newDimensionless(0.0, 1.0E-6);
            if (index == 0) {
                thisXAxis = Probe.this.xAxis = new DasAxis(this.xrange, 2);
            } else {
                thisXAxis = Probe.this.xAxis.createAttachedAxis();
                thisXAxis.setTickLabelsVisible(false);
            }
            if (underplotAgent == null) {
                this.plot = new DasPlot(thisXAxis, new DasAxis(this.yrange, 3));
                this.plot.addMouseModule(new DumpToFileMouseModule(this.plot, this.renderer, thisXAxis, this.plot.getYAxis()));
            } else {
                this.plot = underplotAgent.plot;
            }
            this.renderer.setPsym(Psym.NONE);
            SymColor[] symColors = new SymColor[]{SymColor.black, SymColor.blue, SymColor.lightRed, SymColor.red, SymColor.darkGreen, SymColor.gray};
            this.renderer.setColor(symColors[index % symColors.length]);
            this.plot.getXAxis().setAnimated(true);
            this.plot.getYAxis().setAnimated(true);
            this.plot.getYAxis().setLabel(name);
            this.plot.addRenderer(this.renderer);
            if (underplotAgent == null) {
                DasRow row = Probe.this.leveler.getRow(0.0);
                Probe.this.canvas.add(this.plot, row, Probe.this.column);
            } else {
                underplotAgent.addToLegend(this);
            }
            this.hits = 0;
        }

        void addToLegend(Agent overplotAgent) {
            if (this.legend == null) {
                DasCanvas c = this.plot.getCanvas();
                this.legend = new Legend();
                this.legend.add(this.renderer, this.name);
                c.add(this.legend, this.plot.getRow().createAttachedRow(0.2, 0.95), this.plot.getColumn().createAttachedColumn(0.7, 0.99));
            }
            this.legend.add(overplotAgent.renderer, overplotAgent.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(double value) {
            double xvalue = ++this.hits;
            VectorDataSetBuilder vectorDataSetBuilder = this.builder;
            synchronized (vectorDataSetBuilder) {
                this.builder.insertY(xvalue, value);
            }
            if (!this.xrange.contains(Units.dimensionless.createDatum(xvalue))) {
                this.xrange = Probe.this.include(this.xrange, Units.dimensionless.createDatum(xvalue));
                if (!this.xrange.width().isFinite()) {
                    throw new IllegalStateException();
                }
            }
            if (!this.yrange.contains(Units.dimensionless.createDatum(value))) {
                this.yrange = Probe.this.include(this.yrange, Units.dimensionless.createDatum(value));
                if (!this.yrange.width().isFinite()) {
                    throw new IllegalStateException();
                }
            }
            Probe.this.needUpdate = true;
        }

        void add(int value) {
            this.histogram = true;
            this.add((double)value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void update() {
            VectorDataSet ds;
            VectorDataSetBuilder vectorDataSetBuilder = this.builder;
            synchronized (vectorDataSetBuilder) {
                ds = this.builder.toVectorDataSet();
            }
            this.plot.getXAxis().setDatumRange(this.xrange);
            this.plot.getYAxis().setDatumRange(this.yrange);
            this.renderer.setHistogram(this.histogram);
            this.renderer.setDataSet(ds);
        }

        void destroy() {
            if (Probe.this.isWidgetCreated) {
                this.plot.removeRenderer(this.renderer);
            }
        }
    }
}

