/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;

public class Glob {
    public static String getParentDirectory(String regex) {
        String dirRegex;
        String[] s = regex.split("/");
        if (s.length > 1) {
            dirRegex = s[0];
            for (int i = 1; i < s.length - 1; ++i) {
                dirRegex = dirRegex + "/" + s[i];
            }
        } else {
            dirRegex = null;
        }
        String fileRegex = s[s.length - 1];
        return dirRegex;
    }

    public static boolean isRoot(String glob) {
        File root = new File(glob);
        return root.getParentFile() == null;
    }

    public static Pattern getPattern(String glob) {
        String regex = glob.replaceAll("\\.", "\\\\.").replaceAll("\\*", "\\.\\*").replaceAll("\\?", "\\.");
        Pattern absPattern = Pattern.compile(regex);
        return absPattern;
    }

    public static File[] unGlob(String glob) {
        return Glob.unGlob(glob, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File[] unGlob(String glob, final boolean directoriesOnly) {
        File[] files;
        String parentGlob;
        if (File.separatorChar == '\\') {
            glob = glob.replaceAll("\\\\", "/");
        }
        if ((parentGlob = Glob.getParentDirectory(glob)) != null) {
            if (Glob.isRoot(parentGlob)) {
                File rootFile = new File(parentGlob);
                if (!rootFile.exists()) throw new IllegalArgumentException("root does not exist: " + glob);
                files = new File[]{rootFile};
            } else {
                files = Glob.unGlob(parentGlob, true);
            }
        } else {
            files = new File[]{new File(".")};
        }
        String regex = glob.replaceAll("\\.", "\\\\.").replaceAll("\\*", "\\.\\*").replaceAll("\\?", "\\.");
        final Pattern absPattern = Pattern.compile(regex);
        ArrayList<File> list = new ArrayList<File>();
        for (int i = 0; i < files.length; ++i) {
            File[] files1 = files[i].listFiles(new FileFilter(){

                public boolean accept(File file) {
                    String s = file.toString();
                    if (File.separatorChar == '\\') {
                        s = s.replaceAll("\\\\", "/");
                    }
                    return absPattern.matcher(s).matches() && (!directoriesOnly || file.isDirectory());
                }
            });
            if (files1 == null) {
                throw new RuntimeException("");
            }
            list.addAll(Arrays.asList(files1));
        }
        return list.toArray(new File[list.size()]);
    }
}

