/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    public int read() {
        if (this.buffer.hasRemaining()) {
            return 0xFF & this.buffer.get();
        }
        return -1;
    }

    public void close() {
    }

    public long skip(long n) {
        if (n > (long)this.buffer.remaining()) {
            long skipped = this.buffer.remaining();
            this.buffer.position(this.buffer.limit());
            return skipped;
        }
        this.buffer.position(this.buffer.position() + (int)n);
        return n;
    }

    public void reset() throws IOException {
        try {
            this.buffer.reset();
        }
        catch (InvalidMarkException ime) {
            IOException ioe = new IOException(ime.getMessage());
            ioe.initCause(ime);
            throw ioe;
        }
    }

    public int available() {
        return this.buffer.remaining();
    }

    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readlimit) {
        this.buffer.mark();
    }

    public int read(byte[] b, int off, int len) {
        if (this.buffer.hasRemaining()) {
            int bytesRead = Math.min(len, this.buffer.remaining());
            this.buffer.get(b, off, bytesRead);
            return bytesRead;
        }
        return -1;
    }
}

