/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream.test;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.stream.DataTransferType;
import edu.uiowa.physics.pw.das.stream.PacketDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.stream.StreamMultiYDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamProducer;
import edu.uiowa.physics.pw.das.stream.StreamXDescriptor;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.List;

public class SineWaveStream {
    private double frequency = 0.1;
    private boolean compress;

    public SineWaveStream(boolean compress) {
        this.compress = compress;
    }

    public void produceSineWaveStream(WritableByteChannel out) {
        try {
            StreamProducer producer = new StreamProducer(out);
            StreamDescriptor sd = new StreamDescriptor();
            if (this.compress) {
                sd.setCompression("deflate");
            }
            producer.streamDescriptor(sd);
            int nx = 3600;
            StreamXDescriptor xDescriptor = new StreamXDescriptor();
            xDescriptor.setDataTransferType(DataTransferType.getByName("ascii24"));
            xDescriptor.setUnits(Units.seconds);
            xDescriptor.setBase(TimeUtil.createValid("2000-001"));
            StreamMultiYDescriptor y = new StreamMultiYDescriptor();
            y.setDataTransferType(DataTransferType.getByName("ascii10"));
            PacketDescriptor pd = new PacketDescriptor();
            pd.setXDescriptor(xDescriptor);
            pd.addYDescriptor(y);
            producer.packetDescriptor(pd);
            double[] z = new double[1];
            DatumVector[] yValues = new DatumVector[1];
            for (int i = 0; i < nx; ++i) {
                Datum xTag = Datum.create((double)i, Units.seconds);
                z[0] = Math.sin(Math.PI * this.frequency * (double)i);
                yValues[0] = DatumVector.newDatumVector(z, Units.dimensionless);
                producer.packet(pd, xTag, yValues);
            }
            producer.streamClosed(sd);
        }
        catch (StreamException se) {
            se.printStackTrace();
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        List<String> argList = Arrays.asList(args);
        boolean c = argList.contains("-c");
        WritableByteChannel out = Channels.newChannel(System.out);
        SineWaveStream rs = new SineWaveStream(c);
        rs.produceSineWaveStream(out);
    }
}

