/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream.test;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasIOException;
import edu.uiowa.physics.pw.das.client.DataSetDescriptorNotAvailableException;
import edu.uiowa.physics.pw.das.client.StandardDataStreamSource;
import edu.uiowa.physics.pw.das.client.StreamDataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class LocalFileStandardDataStreamSource
implements StandardDataStreamSource {
    private File file;

    public LocalFileStandardDataStreamSource(File file) {
        this.file = file;
    }

    public InputStream getInputStream(StreamDataSetDescriptor dsd, Datum start, Datum end) throws DasException {
        try {
            return new FileInputStream(this.file);
        }
        catch (IOException ioe) {
            throw new DasIOException(ioe);
        }
    }

    public InputStream getReducedInputStream(StreamDataSetDescriptor dsd, Datum start, Datum end, Datum timeResolution) throws DasException {
        return this.getInputStream(dsd, start, end);
    }

    public void reset() {
    }

    public static DataSetDescriptor newDataSetDescriptor(Map map) throws DataSetDescriptorNotAvailableException {
        String filename = (String)map.get("file");
        File file = new File(filename);
        StreamDescriptor sd = new StreamDescriptor();
        return new StreamDataSetDescriptor(sd, new LocalFileStandardDataStreamSource(file));
    }
}

