/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.stream.DataTransferType;
import edu.uiowa.physics.pw.das.stream.PacketDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamComment;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.stream.StreamHandler;
import edu.uiowa.physics.pw.das.stream.StreamMultiYDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamYScanDescriptor;
import java.util.IdentityHashMap;
import java.util.Map;

public class ToAscii
implements StreamHandler {
    private Map descriptors = new IdentityHashMap();
    private StreamHandler handler;

    public ToAscii(StreamHandler handler) {
        this.handler = handler;
    }

    public void packet(PacketDescriptor pd, Datum xTag, DatumVector[] vectors) throws StreamException {
        PacketDescriptor outpd = (PacketDescriptor)this.descriptors.get(pd);
        this.handler.packet(outpd, xTag, vectors);
    }

    public void packetDescriptor(PacketDescriptor pd) throws StreamException {
        DataTransferType ascii24 = DataTransferType.getByName("ascii24");
        DataTransferType ascii10 = DataTransferType.getByName("ascii10");
        PacketDescriptor outpd = (PacketDescriptor)pd.clone();
        outpd.getXDescriptor().setDataTransferType(ascii24);
        for (int i = 0; i < outpd.getYCount(); ++i) {
            if (outpd.getYDescriptor(i) instanceof StreamMultiYDescriptor) {
                ((StreamMultiYDescriptor)outpd.getYDescriptor(i)).setDataTransferType(ascii10);
                continue;
            }
            if (!(outpd.getYDescriptor(i) instanceof StreamYScanDescriptor)) continue;
            ((StreamYScanDescriptor)outpd.getYDescriptor(i)).setDataTransferType(ascii10);
        }
        this.handler.packetDescriptor(outpd);
        this.descriptors.put(pd, outpd);
    }

    public void streamClosed(StreamDescriptor sd) throws StreamException {
        this.handler.streamClosed(sd);
    }

    public void streamDescriptor(StreamDescriptor sd) throws StreamException {
        this.handler.streamDescriptor(sd);
    }

    public void streamException(StreamException se) throws StreamException {
        this.handler.streamException(se);
    }

    public void streamComment(StreamComment se) throws StreamException {
        this.handler.streamComment(se);
    }

    public void packet(PacketDescriptor pd, DatumVector vector) throws StreamException {
    }
}

