/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.stream.PacketDescriptor;
import edu.uiowa.physics.pw.das.stream.SkeletonDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamComment;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.stream.StreamHandler;
import edu.uiowa.physics.pw.das.stream.StreamMultiYDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamYScanDescriptor;
import edu.uiowa.physics.pw.das.util.DeflaterChannel;
import edu.uiowa.physics.pw.das.util.StreamTool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StreamProducer
implements StreamHandler {
    private Map descriptors = new IdentityHashMap();
    private Map idMap = new HashMap();
    private WritableByteChannel stream;
    private ByteBuffer bigBuffer = ByteBuffer.allocate(4096);
    private byte[] six = new byte[6];
    private int nextAvail = 1;
    private DocumentBuilder builder;

    public StreamProducer(WritableByteChannel stream) {
        this.stream = stream;
        try {
            this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
    }

    public void packet(PacketDescriptor pd, Datum xTag, DatumVector[] vectors) throws StreamException {
        try {
            if (!this.descriptors.containsKey(pd)) {
                this.packetDescriptor(pd);
            }
            String header = (String)this.descriptors.get(pd);
            if (pd.getSizeBytes() > this.bigBuffer.capacity()) {
                this.resizeBuffer(pd.getSizeBytes() + pd.getSizeBytes() >> 1);
            }
            if (pd.getSizeBytes() + 4 > this.bigBuffer.remaining()) {
                this.flush();
            }
            this.six[3] = 58;
            this.six[0] = 58;
            this.six[1] = (byte)header.charAt(0);
            this.six[2] = (byte)header.charAt(1);
            this.bigBuffer.put(this.six, 0, 4);
            pd.getXDescriptor().writeDatum(xTag, this.bigBuffer);
            for (int i = 0; i < pd.getYCount(); ++i) {
                pd.getYDescriptor(i).write(vectors[i], this.bigBuffer);
            }
            int lastChar = this.bigBuffer.position() - 1;
            SkeletonDescriptor lastY = pd.getYDescriptor(pd.getYCount() - 1);
            if ((lastY instanceof StreamYScanDescriptor && ((StreamYScanDescriptor)lastY).getDataTransferType().isAscii() || lastY instanceof StreamMultiYDescriptor && ((StreamMultiYDescriptor)lastY).getDataTransferType().isAscii()) && Character.isWhitespace((char)this.bigBuffer.get(lastChar))) {
                this.bigBuffer.put(lastChar, (byte)10);
            }
            this.bigBuffer.flip();
            this.stream.write(this.bigBuffer);
            this.bigBuffer.compact();
        }
        catch (IOException ioe) {
            throw new StreamException(ioe);
        }
    }

    private int nextAvailable() {
        int result = this.nextAvail;
        this.nextAvail = this.nextAvail == 99 ? 1 : ++this.nextAvail;
        return result;
    }

    public void packetDescriptor(PacketDescriptor pd) throws StreamException {
        try {
            String id = StreamProducer.toString2(this.nextAvailable());
            if (this.idMap.containsKey(id)) {
                Object d = this.idMap.get(id);
                this.descriptors.remove(d);
            }
            this.descriptors.put(pd, id);
            this.idMap.put(id, pd);
            Document document = this.builder.newDocument();
            Element root = pd.getDOMElement(document);
            document.appendChild(root);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "US-ASCII");
            StreamTool.formatHeader(document, writer);
            writer.flush();
            byte[] header = out.toByteArray();
            int length = header.length;
            if (this.bigBuffer.remaining() < length + 10) {
                this.flush();
            }
            if (this.bigBuffer.capacity() < length + 10) {
                this.resizeBuffer(length + length / 2 + 15);
                System.err.println("length: " + length);
            }
            this.six[0] = 91;
            this.six[1] = (byte)id.charAt(0);
            this.six[2] = (byte)id.charAt(1);
            this.six[3] = 93;
            this.bigBuffer.put(this.six, 0, 4);
            this.six[0] = (byte)Character.forDigit(length / 100000 % 10, 10);
            this.six[1] = (byte)Character.forDigit(length / 10000 % 10, 10);
            this.six[2] = (byte)Character.forDigit(length / 1000 % 10, 10);
            this.six[3] = (byte)Character.forDigit(length / 100 % 10, 10);
            this.six[4] = (byte)Character.forDigit(length / 10 % 10, 10);
            this.six[5] = (byte)Character.forDigit(length % 10, 10);
            this.bigBuffer.put(this.six);
            this.bigBuffer.put(header);
            this.bigBuffer.flip();
            this.stream.write(this.bigBuffer);
            this.bigBuffer.compact();
        }
        catch (IOException ioe) {
            throw new StreamException(ioe);
        }
    }

    public void resizeBuffer(int size) throws StreamException {
        this.flush();
        System.err.println("resizeBuffer(" + size + ")");
        this.bigBuffer = ByteBuffer.allocate(size);
    }

    public void streamClosed(StreamDescriptor sd) throws StreamException {
        this.flush();
        try {
            this.stream.close();
        }
        catch (IOException ioe) {
            throw new StreamException(ioe);
        }
    }

    public void streamDescriptor(StreamDescriptor sd) throws StreamException {
        try {
            Document document = this.builder.newDocument();
            Element root = sd.getDOMElement(document);
            document.appendChild(root);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "US-ASCII");
            StreamTool.formatHeader(document, writer);
            writer.flush();
            byte[] header = out.toByteArray();
            int length = header.length;
            this.six[0] = 91;
            this.six[2] = 48;
            this.six[1] = 48;
            this.six[3] = 93;
            this.bigBuffer.put(this.six, 0, 4);
            this.six[0] = (byte)Character.forDigit(length / 100000 % 10, 10);
            this.six[1] = (byte)Character.forDigit(length / 10000 % 10, 10);
            this.six[2] = (byte)Character.forDigit(length / 1000 % 10, 10);
            this.six[3] = (byte)Character.forDigit(length / 100 % 10, 10);
            this.six[4] = (byte)Character.forDigit(length / 10 % 10, 10);
            this.six[5] = (byte)Character.forDigit(length % 10, 10);
            this.bigBuffer.put(this.six);
            this.bigBuffer.put(header);
            this.flush();
            if ("deflate".equals(sd.getCompression())) {
                this.stream = StreamProducer.getDeflaterChannel(this.stream);
            }
        }
        catch (IOException ioe) {
            throw new StreamException(ioe);
        }
    }

    public void streamException(StreamException se) throws StreamException {
    }

    public void flush() throws StreamException {
        try {
            this.bigBuffer.flip();
            while (this.bigBuffer.hasRemaining()) {
                this.stream.write(this.bigBuffer);
            }
            this.bigBuffer.clear();
        }
        catch (IOException ioe) {
            throw new StreamException(ioe);
        }
    }

    private static String toString4(int i) {
        if (i > 9999) {
            throw new IllegalArgumentException("header is too big");
        }
        if (i < 10) {
            return "000" + i;
        }
        if (i < 100) {
            return "00" + i;
        }
        if (i < 1000) {
            return "0" + i;
        }
        return String.valueOf(i);
    }

    private static String toString2(int i) {
        if (i > 99) {
            throw new IllegalArgumentException("header number cannot be > 99");
        }
        if (i < 10) {
            return "0" + i;
        }
        return String.valueOf(i);
    }

    private static WritableByteChannel getDeflaterChannel(WritableByteChannel channel) throws IOException {
        return new DeflaterChannel(channel);
    }

    public void streamComment(StreamComment sc) throws StreamException {
    }

    private static class IdentitySet
    extends AbstractCollection
    implements Set {
        private IdentityHashMap map = new IdentityHashMap();
        private static final Object VALUE = new Object();

        private IdentitySet() {
        }

        public Iterator iterator() {
            return this.map.keySet().iterator();
        }

        public int size() {
            return this.map.size();
        }
    }
}

