/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import java.awt.geom.GeneralPath;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import javax.swing.JTabbedPane;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;

public class Util {
    public static DasPlot newDasPlot(DasCanvas canvas, DatumRange x, DatumRange y) {
        DasAxis xaxis = new DasAxis(x.min(), x.max(), 2);
        DasAxis yaxis = new DasAxis(y.min(), y.max(), 3);
        DasRow row = DasRow.create(canvas);
        DasColumn col = DasColumn.create(canvas);
        DasPlot result = new DasPlot(xaxis, yaxis);
        canvas.add(result, row, col);
        return result;
    }

    public static void serializeCanvas(DasCanvas canvas, OutputStream out) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            document.appendChild(canvas.getDOMElement(document));
            StringWriter writer = new StringWriter();
            OutputFormat format = new OutputFormat("xml", "UTF-8", true);
            XMLSerializer serializer = new XMLSerializer(new OutputStreamWriter(out), format);
            serializer.serialize(document);
            out.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JTabbedPane loadCanvas(InputStream in) throws Exception {
        FormBase form = new FormBase(in, null, true);
        return form;
    }

    public static GeneralPath getPath(DasAxis xAxis, DasAxis yAxis, VectorDataSet xds, VectorDataSet yds, boolean histogram) {
        double xSampleWidth;
        Datum xSampleWidthDatum;
        GeneralPath newPath = new GeneralPath();
        Units xUnits = xAxis.getUnits();
        Units yUnits = yAxis.getUnits();
        double xmax = xAxis.getDataMaximum().doubleValue(xUnits);
        double xmin = xAxis.getDataMinimum().doubleValue(xUnits);
        double ymax = yAxis.getDataMaximum().doubleValue(yUnits);
        double ymin = yAxis.getDataMinimum().doubleValue(yUnits);
        if (xds.getProperty("xTagWidth") != null) {
            xSampleWidthDatum = (Datum)xds.getProperty("xTagWidth");
            xSampleWidth = xSampleWidthDatum.doubleValue(xUnits.getOffsetUnits());
        } else if (xds.getProperty("xSampleWidth") != null) {
            xSampleWidthDatum = (Datum)xds.getProperty("xSampleWidth");
            xSampleWidth = xSampleWidthDatum.doubleValue(xUnits.getOffsetUnits());
        } else {
            String xSampleWidthString = (String)xds.getProperty("x_sample_width");
            if (xSampleWidthString != null) {
                double xSampleWidthSeconds = Double.parseDouble(xSampleWidthString);
                xSampleWidth = Units.seconds.convertDoubleTo(xUnits.getOffsetUnits(), xSampleWidthSeconds);
            } else {
                xSampleWidth = 1.0E31;
            }
        }
        double t0 = -1.7976931348623157E308;
        double x0 = -1.7976931348623157E308;
        double y0 = -1.7976931348623157E308;
        double i0 = -1.7976931348623157E308;
        double j0 = -1.7976931348623157E308;
        boolean skippedLast = true;
        int n = xds.getXLength();
        for (int index = 0; index < n; ++index) {
            double t = xds.getXTagDouble(index, xUnits);
            double x = xds.getDouble(index, yUnits);
            double y = yds.getDouble(index, yUnits);
            double i = xAxis.transform(x, xUnits);
            double j = yAxis.transform(y, yUnits);
            if (yUnits.isFill(y) || Double.isNaN(y)) {
                skippedLast = true;
            } else if (skippedLast || t - t0 > xSampleWidth) {
                newPath.moveTo((float)i, (float)j);
                skippedLast = false;
            } else {
                if (histogram) {
                    double i1 = (i0 + i) / 2.0;
                    newPath.lineTo((float)i1, (float)j0);
                    newPath.lineTo((float)i1, (float)j);
                    newPath.lineTo((float)i, (float)j);
                } else {
                    newPath.lineTo((float)i, (float)j);
                }
                skippedLast = false;
            }
            t0 = t;
            x0 = x;
            y0 = y;
            i0 = i;
            j0 = j;
        }
        return newPath;
    }
}

