/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.datum.format.TimeDatumFormatter;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.DataRange;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TimeRangeLabel
extends DasCanvasComponent {
    private static final DatumFormatter MINUTES;
    private static final DatumFormatter SECONDS;
    private static final DatumFormatter MILLESECONDS;
    private DataRange dataRange;
    private DatumFormatter df;

    public TimeRangeLabel(DataRange dataRange) {
        this.dataRange = dataRange;
        DataRangePropertyChangeListener listener = new DataRangePropertyChangeListener();
        dataRange.addPropertyChangeListener("minimum", listener);
        dataRange.addPropertyChangeListener("maximum", listener);
        this.updateFormatter();
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        g.setRenderingHints(DasProperties.getRenderingHints());
        Datum min = Datum.create(this.dataRange.getMinimum(), this.dataRange.getUnits());
        Datum max = Datum.create(this.dataRange.getMaximum(), this.dataRange.getUnits());
        FontMetrics fm = g.getFontMetrics();
        int y = this.getRow().getDMinimum();
        int x = this.getColumn().getDMinimum();
        g.translate(-this.getX(), -this.getY());
        g.drawString(this.df.format(min), x, y - this.getFont().getSize() * 2);
        String label = this.df.format(max);
        g.drawString(label, x + this.getColumn().getWidth() - fm.stringWidth(label), y - this.getFont().getSize() * 2);
    }

    public void resize() {
        Rectangle bounds = new Rectangle(this.getColumn().getDMinimum() - 30, this.getRow().getDMinimum() - this.getFont().getSize() * 3, this.getColumn().getWidth() + 60, this.getFont().getSize() * 3);
        this.setBounds(bounds);
    }

    private void updateFormatter() {
        UnitsConverter converter = Units.getConverter(this.dataRange.getUnits(), Units.t2000);
        double min = converter.convert(this.dataRange.getMinimum());
        double max = converter.convert(this.dataRange.getMinimum());
        min = this.secondsSinceMidnight(min);
        max = this.secondsSinceMidnight(max);
        int minMS = (int)(min * 1000.0);
        int maxMS = (int)(max * 1000.0);
        this.df = minMS % 1000 != 0 || maxMS % 1000 != 0 ? MILLESECONDS : (minMS % 60000 != 0 || maxMS % 60000 != 0 ? SECONDS : MINUTES);
    }

    private double secondsSinceMidnight(double t2000) {
        if (t2000 < 0.0) {
            if ((t2000 %= 86400.0) == 0.0) {
                return 0.0;
            }
            return 86400.0 + t2000;
        }
        return t2000 % 86400.0;
    }

    public PropertyChangeListener createDataRangePropertyListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                Object oldValue = e.getOldValue();
                Object newValue = e.getNewValue();
                if (propertyName.equals("log")) {
                    TimeRangeLabel.this.update();
                    TimeRangeLabel.this.firePropertyChange("log", oldValue, newValue);
                } else if (propertyName.equals("minimum")) {
                    TimeRangeLabel.this.update();
                    TimeRangeLabel.this.updateFormatter();
                    TimeRangeLabel.this.firePropertyChange("dataMinimum", oldValue, newValue);
                } else if (propertyName.equals("maximum")) {
                    TimeRangeLabel.this.update();
                    TimeRangeLabel.this.updateFormatter();
                    TimeRangeLabel.this.firePropertyChange("dataMaximum", oldValue, newValue);
                }
                TimeRangeLabel.this.markDirty();
            }
        };
    }

    public static void main(String[] args) {
        JFrame jframe = new JFrame();
        jframe.setDefaultCloseOperation(3);
        JPanel panel = new JPanel();
        DasCanvas canvas = new DasCanvas(300, 300);
        DasRow row1 = new DasRow(canvas, 0.1, 0.2);
        DasRow row2 = new DasRow(canvas, 0.3, 0.4);
        DasRow row3 = new DasRow(canvas, 0.5, 0.6);
        DasRow row4 = new DasRow(canvas, 0.7, 0.8);
        DasColumn column = new DasColumn(canvas, 0.1, 0.9);
        DataRange dataRange1 = new DataRange(null, TimeUtil.createValid("1998-01-01 12:20"), TimeUtil.createValid("1999-01-01"), false);
        DataRange dataRange2 = new DataRange(null, TimeUtil.createValid("1998-01-02 12:30:02"), TimeUtil.createValid("1999-01-01"), false);
        DataRange dataRange3 = new DataRange(null, TimeUtil.createValid("1998-01-03 12:40:02.244"), TimeUtil.createValid("1999-01-01"), false);
        canvas.add(new TimeRangeLabel(dataRange1), row1, column);
        canvas.add(new TimeRangeLabel(dataRange2), row2, column);
        canvas.add(new TimeRangeLabel(dataRange3), row3, column);
        panel.setLayout(new BorderLayout());
        panel.add((Component)canvas, "Center");
        jframe.setContentPane(panel);
        jframe.pack();
        jframe.setVisible(true);
        canvas.repaint();
    }

    static {
        try {
            MINUTES = new TimeDatumFormatter("yyyy-MM-dd '('DDD')' HH:mm");
            SECONDS = new TimeDatumFormatter("yyyy-MM-dd '('DDD')' HH:mm:ss");
            MILLESECONDS = new TimeDatumFormatter("yyyy-MM-dd '('DDD')' HH:mm:ss.SSS");
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
    }

    private class mouseModule
    extends MouseModule {
        private mouseModule() {
        }
    }

    private class DataRangePropertyChangeListener
    implements PropertyChangeListener {
        private DataRangePropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            TimeRangeLabel.this.repaint();
        }
    }
}

