/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorUtil;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.Psym;
import edu.uiowa.physics.pw.das.graph.PsymConnector;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.graph.SymColor;
import edu.uiowa.physics.pw.das.system.RequestProcessor;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SymbolLineRenderer
extends Renderer {
    private Psym psym = Psym.NONE;
    private double symSize = 1.0;
    private float lineWidth = 1.5f;
    private boolean histogram = false;
    private PsymConnector psymConnector = PsymConnector.SOLID;
    private SymColor color = SymColor.black;
    private long lastUpdateMillis;
    private boolean antiAliased = "on".equals(DasProperties.getInstance().get("antiAlias"));
    private GeneralPath path;

    public SymbolLineRenderer(DataSet ds) {
        super(ds);
    }

    public SymbolLineRenderer(DataSetDescriptor dsd) {
        super(dsd);
    }

    public void render(Graphics g, DasAxis xAxis, DasAxis yAxis) {
        int ixmax;
        double ymin;
        double ymax;
        double xmin;
        double xmax;
        long timer0 = System.currentTimeMillis();
        VectorDataSet dataSet = (VectorDataSet)this.getDataSet();
        if (dataSet == null || dataSet.getXLength() == 0) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g;
        RenderingHints hints0 = graphics.getRenderingHints();
        if (this.antiAliased) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        Units xUnits = xAxis.getUnits();
        Units yUnits = yAxis.getUnits();
        Rectangle r = g.getClipBounds();
        if (r == null) {
            xmax = xAxis.getDataMaximum().doubleValue(xUnits);
            xmin = xAxis.getDataMinimum().doubleValue(xUnits);
            ymax = yAxis.getDataMaximum().doubleValue(yUnits);
            ymin = yAxis.getDataMinimum().doubleValue(yUnits);
        } else {
            xmin = xAxis.invTransform((int)r.getX()).doubleValue(xUnits);
            xmax = xAxis.invTransform((int)(r.getX() + r.getWidth())).doubleValue(xUnits);
            ymin = yAxis.invTransform((int)r.getY()).doubleValue(yUnits);
            ymax = yAxis.invTransform((int)(r.getY() + r.getHeight())).doubleValue(yUnits);
        }
        int ixmin = VectorUtil.closestXTag(dataSet, xmin, xUnits);
        if (ixmin > 0) {
            --ixmin;
        }
        if ((ixmax = VectorUtil.closestXTag(dataSet, xmax, xUnits)) < dataSet.getXLength() - 1) {
            ++ixmax;
        }
        graphics.setColor(this.color.toColor());
        if (this.path != null) {
            this.psymConnector.draw(graphics, this.path, this.lineWidth);
        }
        for (int index = ixmin; index <= ixmax; ++index) {
            if (yUnits.isFill(dataSet.getDouble(index, yUnits))) continue;
            double i = xAxis.transform(dataSet.getXTagDouble(index, xUnits), xUnits);
            double j = yAxis.transform(dataSet.getDouble(index, yUnits), yUnits);
            if (Double.isNaN(j)) continue;
            this.psym.draw(graphics, i, j, (float)this.symSize);
        }
        long milli = System.currentTimeMillis();
        DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).finer("render: " + (milli - timer0) + " total:" + (milli - this.lastUpdateMillis) + " fps:" + 1000.0 / (double)(milli - this.lastUpdateMillis));
        this.lastUpdateMillis = milli;
        graphics.setRenderingHints(hints0);
    }

    public void updatePlotImage(DasAxis xAxis, DasAxis yAxis, DasProgressMonitor monitor) {
        double xSampleWidth;
        int ixmax;
        boolean histogram = this.histogram;
        GeneralPath newPath = new GeneralPath();
        VectorDataSet dataSet = (VectorDataSet)this.getDataSet();
        if (dataSet == null || dataSet.getXLength() == 0) {
            return;
        }
        Units xUnits = xAxis.getUnits();
        Units yUnits = yAxis.getUnits();
        double xmax = xAxis.getDataMaximum().doubleValue(xUnits);
        double xmin = xAxis.getDataMinimum().doubleValue(xUnits);
        double ymax = yAxis.getDataMaximum().doubleValue(yUnits);
        double ymin = yAxis.getDataMinimum().doubleValue(yUnits);
        int ixmin = VectorUtil.closestXTag(dataSet, xmin, xUnits);
        if (ixmin > 0) {
            --ixmin;
        }
        if ((ixmax = VectorUtil.closestXTag(dataSet, xmax, xUnits)) < dataSet.getXLength() - 1) {
            ++ixmax;
        }
        if (dataSet.getProperty("xTagWidth") != null) {
            Datum xSampleWidthDatum = (Datum)dataSet.getProperty("xTagWidth");
            xSampleWidth = xSampleWidthDatum.doubleValue(xUnits.getOffsetUnits());
        } else {
            String xSampleWidthString = (String)dataSet.getProperty("x_sample_width");
            if (xSampleWidthString != null) {
                double xSampleWidthSeconds = Double.parseDouble(xSampleWidthString);
                xSampleWidth = Units.seconds.convertDoubleTo(xUnits.getOffsetUnits(), xSampleWidthSeconds);
            } else {
                xSampleWidth = 1.0E31;
            }
        }
        xSampleWidth *= 1.5;
        double x0 = -1.7976931348623157E308;
        double y0 = -1.7976931348623157E308;
        double i0 = -1.7976931348623157E308;
        double j0 = -1.7976931348623157E308;
        boolean skippedLast = true;
        for (int index = ixmin; index <= ixmax; ++index) {
            double x = dataSet.getXTagDouble(index, xUnits);
            double y = dataSet.getDouble(index, yUnits);
            double i = xAxis.transform(x, xUnits);
            double j = yAxis.transform(y, yUnits);
            if (yUnits.isFill(y) || Double.isNaN(y)) {
                skippedLast = true;
            } else if (skippedLast || Math.abs(x - x0) > xSampleWidth) {
                newPath.moveTo((float)i, (float)j);
                skippedLast = false;
            } else {
                if (histogram) {
                    double i1 = (i0 + i) / 2.0;
                    newPath.lineTo((float)i1, (float)j0);
                    newPath.lineTo((float)i1, (float)j);
                    newPath.lineTo((float)i, (float)j);
                } else {
                    newPath.lineTo((float)i, (float)j);
                }
                skippedLast = false;
            }
            x0 = x;
            y0 = y;
            i0 = i;
            j0 = j;
        }
        this.path = newPath;
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
    }

    public PsymConnector getPsymConnector() {
        return this.psymConnector;
    }

    public void setPsymConnector(PsymConnector p) {
        this.psymConnector = p;
        this.refreshImage();
    }

    public Psym getPsym() {
        return this.psym;
    }

    public void setPsym(Psym psym) {
        if (psym == null) {
            throw new NullPointerException("psym cannot be null");
        }
        Psym oldValue = this.psym;
        this.psym = psym;
        this.refreshImage();
    }

    public double getSymSize() {
        return this.symSize;
    }

    public void setSymSize(double symSize) {
        this.symSize = symSize;
        this.setPsym(this.psym);
        this.refreshImage();
    }

    public SymColor getColor() {
        return this.color;
    }

    public void setColor(SymColor color) {
        this.color = color;
        this.refreshImage();
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float f) {
        this.lineWidth = f;
        this.refreshImage();
    }

    protected void installRenderer() {
    }

    protected void uninstallRenderer() {
    }

    public static SymbolLineRenderer processLinePlotElement(Element element, DasPlot parent, FormBase form) {
        String dataSetID = element.getAttribute("dataSetID");
        Psym psym = Psym.parsePsym(element.getAttribute("psym"));
        SymColor color = SymColor.parseSymColor(element.getAttribute("color"));
        SymbolLineRenderer renderer = new SymbolLineRenderer((DataSet)null);
        parent.addRenderer(renderer);
        float lineWidth = Float.parseFloat(element.getAttribute("lineWidth"));
        try {
            renderer.setDataSetID(dataSetID);
        }
        catch (DasException de) {
            DasExceptionHandler.handle(de);
        }
        renderer.setPsym(psym);
        renderer.setColor(color);
        renderer.setLineWidth(lineWidth);
        return renderer;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("lineplot");
        element.setAttribute("dataSetID", this.getDataSetID());
        element.setAttribute("psym", this.getPsym().toString());
        element.setAttribute("color", this.getColor().toString());
        return element;
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean antiAliased) {
        this.antiAliased = antiAliased;
        this.refreshImage();
    }

    public boolean isHistogram() {
        return this.histogram;
    }

    public void setHistogram(boolean b) {
        if (b != this.histogram) {
            this.histogram = b;
            if (this.getParent() != null && this.getParent().getCanvas() != null) {
                new Runnable(){
                    {
                        RequestProcessor.invokeLater(this, SymbolLineRenderer.this.getParent().getCanvas());
                    }

                    public void run() {
                        SymbolLineRenderer.this.updatePlotImage(SymbolLineRenderer.this.getParent().getXAxis(), SymbolLineRenderer.this.getParent().getYAxis(), null);
                    }
                };
            }
        }
    }
}

