/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasRow;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class RowRowConnector
extends DasCanvasComponent
implements PropertyChangeListener {
    private DasCanvas parent;
    private DasRow leftRow;
    private DasRow rightRow;
    private DasColumn leftColumn;
    private DasColumn rightColumn;

    public RowRowConnector(DasCanvas parent, DasRow leftRow, DasRow rightRow, DasColumn leftColumn, DasColumn rightColumn) {
        this.leftRow = leftRow;
        this.rightRow = rightRow;
        this.leftColumn = leftColumn;
        this.rightColumn = rightColumn;
        this.parent = parent;
        leftRow.addPropertyChangeListener(this);
        rightRow.addPropertyChangeListener(this);
        rightColumn.addPropertyChangeListener(this);
        leftColumn.addPropertyChangeListener(this);
    }

    public Rectangle getBounds() {
        int xleft = this.leftColumn.getDMaximum();
        int xright = this.rightColumn.getDMaximum();
        int ylow = Math.max(this.leftRow.getDMaximum(), this.rightRow.getDMaximum());
        int yhigh = Math.min(this.leftRow.getDMinimum(), this.rightRow.getDMinimum());
        Rectangle result = new Rectangle(xleft, yhigh, xright - xleft, ylow - yhigh + 2);
        return result;
    }

    public void setLeftRow(DasRow row) {
        this.leftRow = row;
        this.repaint();
    }

    public void resize() {
        this.setBounds(this.getBounds());
    }

    protected void paintComponent(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.translate(-this.getX(), -this.getY());
        int hlen = 3;
        int x1 = this.leftColumn.getDMaximum() + hlen;
        int x2 = this.rightColumn.getDMaximum() - hlen;
        int ylow1 = this.leftRow.getDMaximum();
        int ylow2 = this.rightRow.getDMaximum();
        int yhigh1 = this.leftRow.getDMinimum();
        int yhigh2 = this.rightRow.getDMinimum();
        g.setColor(Color.lightGray);
        g.draw(new Line2D.Double(x1 - hlen, ylow1, x1, ylow1));
        g.draw(new Line2D.Double(x2, ylow2, x2 + hlen, ylow2));
        g.draw(new Line2D.Double(x1, ylow1, x2, ylow2));
        g.draw(new Line2D.Double(x1 - hlen, yhigh1, x1, yhigh1));
        g.draw(new Line2D.Double(x2, yhigh2, x2 + hlen, yhigh2));
        g.draw(new Line2D.Double(x1, yhigh1, x2, yhigh2));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.update();
    }
}

