/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasDevicePosition;
import edu.uiowa.physics.pw.das.graph.DasRow;
import java.util.ArrayList;

public class Leveler {
    ArrayList rows;
    ArrayList weights;
    double topMargin;
    double bottomMargin;
    double interMargin;
    DasCanvas parent;

    public Leveler(DasCanvas parent) {
        this.parent = parent;
        this.rows = new ArrayList();
        this.weights = new ArrayList();
        this.topMargin = 0.05;
        this.bottomMargin = 0.1;
        this.interMargin = 0.03;
    }

    public DasRow getRow(double nposition, double weight) {
        LevelRow r = new LevelRow(this.parent, this, nposition, weight);
        return r;
    }

    public DasRow getRow(double nposition) {
        LevelRow r = new LevelRow(this.parent, this, nposition);
        return r;
    }

    public DasRow getRow() {
        LevelRow r = new LevelRow(this.parent, this, 1.0);
        return r;
    }

    void insertAt(double nposition, DasDevicePosition row) {
        this.insertAt(nposition, row, 1.0);
    }

    /*
     * WARNING - void declaration
     */
    void insertAt(double nposition, DasDevicePosition row, double weight) {
        void var6_4;
        int i;
        if (nposition == 0.0) {
            i = 0;
        } else if (nposition == 1.0) {
            i = this.rows.size();
        } else {
            throw new IllegalArgumentException("nposition must be 0.0 or 1.0");
        }
        this.rows.add((int)var6_4, row);
        this.weights.add((int)var6_4, new Double(weight));
    }

    void remove(DasDevicePosition row) {
        int i = this.rows.indexOf(row);
        this.rows.remove(i);
        this.weights.remove(i);
    }

    private int objectIndexAt(double nposition) {
        int i = 0;
        for (i = 0; !(i >= this.rows.size() || this.getMinimum(i) <= nposition && nposition < this.getMaximum(i)); ++i) {
        }
        return i;
    }

    private double integrateWeight(int nRows) {
        if (nRows == 0) {
            return 0.0;
        }
        double totalWeight = (Double)this.weights.get(0);
        for (int i = 1; i < nRows; ++i) {
            totalWeight += ((Double)this.weights.get(i)).doubleValue();
        }
        return totalWeight;
    }

    public void setInsideMargin(double n) {
        this.interMargin = n;
    }

    private double getMinimum(int i) {
        double totalWeight = this.integrateWeight(this.rows.size());
        double partialWeight = this.integrateWeight(i);
        double alphaFt = 1.0 - this.bottomMargin - this.topMargin - (double)(this.rows.size() - 1) * this.interMargin;
        double nWeight = partialWeight / totalWeight;
        double plotsFt = alphaFt * nWeight;
        return this.topMargin + plotsFt + (double)i * this.interMargin;
    }

    double getMinimum(DasDevicePosition row) {
        int i = this.rows.indexOf(row);
        return this.getMinimum(i);
    }

    double getMaximum(int i) {
        return this.getMinimum(i + 1) - this.interMargin;
    }

    double getMaximum(DasDevicePosition row) {
        int i = this.rows.indexOf(row);
        return this.getMaximum(i);
    }

    private void printWeights() {
        for (int i = 0; i < this.weights.size(); ++i) {
            System.out.println("  " + i + ": " + this.weights.get(i));
        }
        System.out.println("total: " + this.integrateWeight(this.rows.size()));
    }

    double[] getMinima() {
        double[] result = new double[this.weights.size()];
        for (int i = 0; i < this.weights.size(); ++i) {
            result[i] = this.getMinimum(i);
        }
        return result;
    }

    double[] getMaxima() {
        double[] result = new double[this.weights.size()];
        for (int i = 0; i < this.weights.size(); ++i) {
            result[i] = this.getMaximum(i);
        }
        return result;
    }

    void setWeights(double[] minima, double[] maxima) {
        int j;
        double totalWeight = this.integrateWeight(this.rows.size());
        double[] ftWeight = new double[this.rows.size()];
        double ftTotalWeight = 0.0;
        for (j = 0; j < this.rows.size(); ++j) {
            ftWeight[j] = maxima[j] - minima[j];
            ftTotalWeight += ftWeight[j];
        }
        for (j = 0; j < this.rows.size(); ++j) {
            this.weights.set(j, new Double(totalWeight * ftWeight[j] / ftTotalWeight));
        }
    }

    public void setTopMargin(double nmargin) {
        this.topMargin = nmargin;
    }

    public void setBottomMargin(double nmargin) {
        this.bottomMargin = nmargin;
    }

    void setMaximum(DasDevicePosition row, double nposition) {
        double[] minima = this.getMinima();
        double[] maxima = this.getMaxima();
        int i = this.rows.indexOf(row);
        maxima[i] = nposition;
        double alpha1 = nposition;
        double alpha2 = 1.0 - this.bottomMargin;
        if (i == this.rows.size() - 1) {
            this.bottomMargin = 1.0 - nposition;
        } else {
            int nBelow = this.rows.size() - 1 - i;
            double weight3 = this.integrateWeight(this.rows.size()) - this.integrateWeight(i + 1);
            double fractionalIntegratedWeight = 0.0;
            for (int j = 1; j < nBelow; ++j) {
                maxima[j + i] = alpha2 * (fractionalIntegratedWeight += (Double)this.weights.get(j + i) / weight3) + alpha1 * (1.0 - fractionalIntegratedWeight);
            }
        }
        for (int j = 1; j < this.rows.size(); ++j) {
            minima[j] = maxima[j - 1] + this.interMargin;
        }
        this.printArray("setMax: minima = ", minima);
        this.printArray("setMax: maxima = ", maxima);
        this.setWeights(minima, maxima);
    }

    void setMinimum(DasDevicePosition row, double nposition) {
        double[] minima = this.getMinima();
        double[] maxima = this.getMaxima();
        int i = this.rows.indexOf(row);
        minima[i] = nposition;
        double alpha1 = this.topMargin;
        double alpha2 = nposition;
        if (i == 0) {
            this.topMargin = nposition;
        } else {
            int nAbove = i;
            double weight3 = this.integrateWeight(i);
            double fractionalIntegratedWeight = 0.0;
            for (int j = 0; j < i; ++j) {
                minima[j] = alpha2 * fractionalIntegratedWeight + alpha1 * (1.0 - fractionalIntegratedWeight);
                fractionalIntegratedWeight += (Double)this.weights.get(j) / weight3;
            }
        }
        for (int j = 0; j < this.rows.size() - 1; ++j) {
            maxima[j] = minima[j + 1] - this.interMargin;
        }
        this.setWeights(minima, maxima);
    }

    private void printArray(String label, double[] values) {
        System.out.print(label);
        for (int i = 0; i < values.length - 1; ++i) {
            System.out.print((int)(values[i] * 100.0) + ",");
        }
        System.out.println((int)(values[values.length - 1] * 100.0));
    }

    public String toString() {
        String result = "--- leveler ---";
        for (int i = 0; i < this.rows.size(); ++i) {
            result = result + "\n" + this.rows.get(i).toString();
        }
        result = result + "-------------\n";
        return result;
    }

    private static class LevelRow
    extends DasRow {
        Leveler lev;

        public LevelRow(DasCanvas parent, Leveler lev, double nposition, double weight) {
            super(parent, 0.0, 0.0);
            this.lev = lev;
            lev.insertAt(nposition, this, weight);
        }

        public LevelRow(DasCanvas parent, Leveler lev, double nposition) {
            this(parent, lev, nposition, 1.0);
        }

        public double getMaximum() {
            if (this.lev == null) {
                return 0.0;
            }
            return this.lev.getMaximum(this);
        }

        public double getMinimum() {
            if (this.lev == null) {
                return 0.0;
            }
            return this.lev.getMinimum(this);
        }

        public int getDMinimum() {
            return (int)(this.getMinimum() * (double)this.getDeviceSize());
        }

        public int getDMaximum() {
            return (int)(this.getMaximum() * (double)this.getDeviceSize());
        }

        public void setDPosition(double minimum, double maximum) {
            this.lev.setMaximum(this, maximum / (double)this.getDeviceSize());
            this.lev.setMinimum(this, minimum / (double)this.getDeviceSize());
        }
    }
}

