/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumUtil;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.graph.TickLabeller;
import edu.uiowa.physics.pw.das.graph.TickVDescriptor;
import edu.uiowa.physics.pw.das.util.GrannyTextRenderer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class GrannyTickLabeller
implements TickLabeller {
    private TickVDescriptor ticks;
    private Component parent;
    private DatumFormatter df;

    public GrannyTickLabeller(Component parent) {
        this.parent = parent;
    }

    public void init(TickVDescriptor ticks) {
        this.ticks = ticks;
        this.df = DatumUtil.bestFormatter(ticks.getMajorTicks());
    }

    private double length(Line2D line) {
        double dx = line.getX2() - line.getX1();
        double dy = line.getY2() - line.getY1();
        double dist = Math.sqrt(dx * dx + dy * dy);
        return dist;
    }

    private Line2D normalize(Line2D line, double len) {
        Point2D p1 = line.getP1();
        double dx = line.getX2() - line.getX1();
        double dy = line.getY2() - line.getY1();
        double dist = Math.sqrt(dx * dx + dy * dy);
        Line2D result = (Line2D)line.clone();
        result.setLine(p1.getX(), p1.getY(), p1.getX() + dx / dist * len, p1.getY() + dy / dist * len);
        return result;
    }

    public Rectangle labelMajorTick(Graphics g, int tickNumber, Line2D tickLine) {
        double labelY;
        double labelX;
        GrannyTextRenderer gtr = new GrannyTextRenderer();
        String grannyString = this.getLabel(tickNumber, Datum.create(this.ticks.tickV[tickNumber], this.ticks.units));
        gtr.setString(this.parent, grannyString);
        Rectangle bounds = gtr.getBounds();
        double tickSlope = (tickLine.getY2() - tickLine.getY1()) / (tickLine.getX2() - tickLine.getX1());
        double labelWidth = bounds.getWidth();
        double labelHeight = bounds.getHeight();
        double labelSlope = labelHeight / labelWidth;
        int FONT_ASCENT_FUDGE = 3;
        int FONT_DESCENT_FUDGE = 3;
        int TICK_PAD = 2;
        tickLine = this.normalize(tickLine, this.length(tickLine) + (double)TICK_PAD);
        if (labelSlope > Math.abs(tickSlope)) {
            if (tickLine.getX2() > tickLine.getX1()) {
                double rise = tickSlope * labelWidth / 2.0;
                labelX = tickLine.getX2();
                labelY = tickLine.getY2() - labelHeight / 2.0 + gtr.getAscent() + rise;
            } else {
                double rise = -tickSlope * labelWidth / 2.0;
                labelX = tickLine.getX2() - labelWidth;
                labelY = tickLine.getY2() - labelHeight / 2.0 + gtr.getAscent() + rise;
            }
        } else if (tickLine.getY2() < tickLine.getY1()) {
            double run = -labelHeight / tickSlope / 2.0;
            labelX = tickLine.getX2() + run - labelWidth / 2.0;
            labelY = tickLine.getY2() - gtr.getDescent() + (double)FONT_DESCENT_FUDGE;
        } else {
            double run = labelHeight / tickSlope / 2.0;
            labelX = tickLine.getX2() + run - labelWidth / 2.0;
            labelY = tickLine.getY2() + gtr.getAscent() - (double)FONT_ASCENT_FUDGE;
        }
        gtr.draw(g, (float)labelX, (float)labelY);
        bounds.translate((int)labelX, (int)labelY);
        return bounds;
    }

    protected String getLabel(int tickNumber, Datum value) {
        return this.df.grannyFormat(value);
    }

    public void finished() {
    }
}

