/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateEvent;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateListener;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.swing.event.EventListenerList;

public abstract class DasDevicePosition
implements Editable,
Serializable {
    protected transient DasCanvas parent;
    private double minimum;
    private double maximum;
    private String dasName;
    private transient PropertyChangeSupport propertyChangeDelegate;
    protected EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener;

    public DasDevicePosition(DasCanvas parent, double minimum, double maximum) {
        boolean isNull;
        if (minimum > maximum) {
            throw new IllegalArgumentException("minimum>maximum");
        }
        if (parent == null & !(isNull = this instanceof DasColumn.NullDasColumn || this instanceof DasRow.NullDasRow)) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        this.parent = parent;
        this.minimum = minimum;
        this.maximum = maximum;
        this.dasName = "dp_" + Integer.toString(this.hashCode());
        this.propertyChangeDelegate = new PropertyChangeSupport(this);
        if (parent != null) {
            parent.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    DasDevicePosition.this.firePropertyChange("dMinimum", 0.0, (double)DasDevicePosition.this.getDMinimum());
                    DasDevicePosition.this.firePropertyChange("dMaximum", 0.0, (double)DasDevicePosition.this.getDMaximum());
                    DasDevicePosition.this.fireUpdate();
                }
            });
            parent.addDevicePosition(this);
        }
    }

    public void setDasName(String name) throws DasNameException {
        if (name.equals(this.dasName)) {
            return;
        }
        String oldName = this.dasName;
        this.dasName = name;
        DasApplication app = this.parent.getDasApplication();
        if (app != null) {
            app.getNameContext().put(name, this);
            if (oldName != null) {
                app.getNameContext().remove(oldName);
            }
        }
        this.firePropertyChange("name", oldName, name);
    }

    public String getDasName() {
        return this.dasName;
    }

    public int getDMinimum() {
        return (int)(this.minimum * (double)this.getDeviceSize());
    }

    public int getDMaximum() {
        return (int)(this.maximum * (double)this.getDeviceSize());
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setPosition(double minimum, double maximum) {
        double oldMin = this.minimum;
        double oldMax = this.maximum;
        this.minimum = Math.min(minimum, maximum);
        this.maximum = Math.max(maximum, maximum);
        if (oldMin != this.minimum) {
            this.firePropertyChange("minimum", oldMin, this.minimum);
            this.firePropertyChange("dMinimum", oldMin * (double)this.getDeviceSize(), (double)this.getDMinimum());
        }
        if (oldMax != this.maximum) {
            this.firePropertyChange("maximum", oldMax, this.maximum);
            this.firePropertyChange("dMaximum", oldMax * (double)this.getDeviceSize(), (double)this.getDMaximum());
        }
        this.fireUpdate();
    }

    public void setDPosition(int minimum, int maximum) {
        this.setPosition((double)minimum / (double)this.getDeviceSize(), (double)maximum / (double)this.getDeviceSize());
    }

    public void setMaximum(double maximum) {
        if (maximum == this.maximum) {
            return;
        }
        if (maximum < this.minimum) {
            this.setPosition(maximum, this.minimum);
        } else {
            double oldValue = this.maximum;
            this.maximum = maximum;
            this.firePropertyChange("maximum", oldValue, maximum);
            this.firePropertyChange("dMaximum", oldValue * (double)this.getDeviceSize(), (double)this.getDMaximum());
            this.fireUpdate();
        }
    }

    public void setDMaximum(int maximum) {
        this.setMaximum((double)maximum / (double)this.getDeviceSize());
    }

    public void setMinimum(double minimum) {
        if (minimum == this.minimum) {
            return;
        }
        if (minimum > this.maximum) {
            this.setPosition(this.maximum, minimum);
        } else {
            double oldValue = this.minimum;
            this.minimum = minimum;
            this.firePropertyChange("minimum", oldValue, minimum);
            this.firePropertyChange("dMinimum", oldValue * (double)this.getDeviceSize(), (double)this.getDMinimum());
            this.fireUpdate();
        }
    }

    public void setDMinimum(int minimum) {
        this.setMinimum((double)minimum / (double)this.getDeviceSize());
    }

    public void translate(double nDelta) {
        this.setPosition(this.minimum + nDelta, this.maximum + nDelta);
    }

    public void dTranslate(int delta) {
        this.setDPosition(this.getDMinimum() + delta, this.getDMaximum() + delta);
    }

    public DasCanvas getParent() {
        return this.parent;
    }

    public void setParent(DasCanvas parent) {
        this.parent = parent;
        this.fireUpdate();
    }

    public void addpwUpdateListener(DasUpdateListener l) {
        this.listenerList.add(class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener == null ? (class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener = DasDevicePosition.class$("edu.uiowa.physics.pw.das.graph.event.DasUpdateListener")) : class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener, l);
    }

    public void removepwUpdateListener(DasUpdateListener l) {
        this.listenerList.remove(class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener == null ? (class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener = DasDevicePosition.class$("edu.uiowa.physics.pw.das.graph.event.DasUpdateListener")) : class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener, l);
    }

    protected void fireUpdate() {
        DasUpdateEvent e = new DasUpdateEvent(this);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener == null ? DasDevicePosition.class$("edu.uiowa.physics.pw.das.graph.event.DasUpdateListener") : class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener)) continue;
            ((DasUpdateListener)listeners[i + 1]).update(e);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeDelegate.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeDelegate.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeDelegate.addPropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.firePropertyChange(propertyName, oldValue ? Boolean.TRUE : Boolean.FALSE, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.firePropertyChange(propertyName, new Integer(oldValue), new Integer(newValue));
    }

    protected void firePropertyChange(String propertyName, long oldValue, long newValue) {
        this.firePropertyChange(propertyName, new Long(oldValue), new Long(newValue));
    }

    protected void firePropertyChange(String propertyName, float oldValue, float newValue) {
        this.firePropertyChange(propertyName, new Float(oldValue), new Float(newValue));
    }

    protected void firePropertyChange(String propertyName, double oldValue, double newValue) {
        this.firePropertyChange(propertyName, new Double(oldValue), new Double(newValue));
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeDelegate.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected abstract int getDeviceSize();

    public static Rectangle toRectangle(DasRow row, DasColumn column) {
        int xmin = column.getDMinimum();
        int ymin = row.getDMinimum();
        return new Rectangle(xmin, ymin, column.getDMaximum() - xmin, row.getDMaximum() - ymin);
    }

    public String toString() {
        return this.getClass().getName() + "[minimum=" + this.getDMinimum() + " maximum=" + this.getDMaximum() + "]";
    }

    public boolean contains(int x) {
        return this.getDMinimum() <= x && x <= this.getDMaximum();
    }

    public int getDMiddle() {
        return (this.getDMinimum() + this.getDMaximum()) / 2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

