/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.graph.AttachedColumn;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasDevicePosition;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateListener;
import java.beans.PropertyChangeListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DasColumn
extends DasDevicePosition {
    public static final DasColumn NULL = new NullDasColumn();

    public DasColumn(DasCanvas parent, double left, double right) {
        super(parent, left, right);
    }

    public DasColumn createSubColumn(double pleft, double pright) {
        double left = this.getMinimum();
        double right = this.getMaximum();
        double delta = right - left;
        return new DasColumn(this.parent, left + pleft * delta, left + pright * delta);
    }

    protected int getDeviceSize() {
        return this.parent.getWidth();
    }

    public int getWidth() {
        return this.getDMaximum() - this.getDMinimum();
    }

    public static DasColumn create(DasCanvas parent) {
        return new DasColumn(parent, 0.1, 0.8);
    }

    public DasColumn createAttachedColumn(double pleft, double pright) {
        return new AttachedColumn(this, pleft, pright);
    }

    static DasColumn processColumnElement(Element element, DasCanvas canvas, FormBase form) throws DasException {
        String name = element.getAttribute("name");
        double minimum = Double.parseDouble(element.getAttribute("minimum"));
        double maximum = Double.parseDouble(element.getAttribute("maximum"));
        DasColumn column = new DasColumn(canvas, minimum, maximum);
        column.setDasName(name);
        DasApplication app = form.getDasApplication();
        NameContext nc = app.getNameContext();
        nc.put(name, column);
        return column;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("column");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("minimum", Double.toString(this.getMinimum()));
        element.setAttribute("maximum", Double.toString(this.getMaximum()));
        return element;
    }

    static final class NullDasColumn
    extends DasColumn {
        private NullDasColumn() {
            super(null, 0.0, 0.0);
        }

        public int getDMinimum() {
            throw new RuntimeException("null column, column was not set before layout");
        }

        public int getDMaximum() {
            throw new RuntimeException("null column, column was not set before layout");
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            throw new RuntimeException("NULL.addPropertyChangeListener");
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            throw new RuntimeException("NULL.removePropertyChangeListener");
        }

        public void addpwUpdateListener(DasUpdateListener l) {
            throw new RuntimeException("NULL.addpwUpdateListener");
        }

        public void removepwUpdateListener(DasUpdateListener l) {
            throw new RuntimeException("NULL.removepwUpdateListener");
        }

        protected void fireUpdate() {
            throw new RuntimeException("NULL.fireUpdate");
        }
    }
}

