/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dasml.FormComponent;
import edu.uiowa.physics.pw.das.dasml.ParsedExpressionException;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColorBar;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasDevicePosition;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.DasSpectrogramPlot;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.graph.SpectrogramRenderer;
import edu.uiowa.physics.pw.das.graph.dnd.TransferableCanvasComponent;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateListener;
import edu.uiowa.physics.pw.das.system.RequestProcessor;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasPNGEncoder;
import edu.uiowa.physics.pw.das.util.DnDSupport;
import edu.uiowa.physics.pw.das.util.Splash;
import edu.uiowa.physics.pw.das.util.awt.GraphicsOutput;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DasCanvas
extends JLayeredPane
implements Printable,
Editable,
FormComponent {
    public static final Integer DEFAULT_LAYER = JLayeredPane.DEFAULT_LAYER;
    public static final Integer PLOT_LAYER = new Integer(300);
    public static final Integer VERTICAL_AXIS_LAYER = new Integer(400);
    public static final Integer HORIZONTAL_AXIS_LAYER = new Integer(500);
    public static final Integer AXIS_LAYER = VERTICAL_AXIS_LAYER;
    public static final Integer ANNOTATION_LAYER = new Integer(1000);
    public static final Integer GLASS_PANE_LAYER = new Integer(30000);
    private static final Paint PAINT_ROW = new Color(255, 178, 178, 146);
    private static final Paint PAINT_COLUMN = new Color(178, 178, 255, 146);
    private static final Paint PAINT_SELECTION = Color.GRAY;
    private static final Stroke STROKE_DASHED;
    public static final Action SAVE_AS_PNG_ACTION;
    public static final Action SAVE_AS_SVG_ACTION;
    public static final Action SAVE_AS_PDF_ACTION;
    public static final Action EDIT_DAS_PROPERTIES_ACTION;
    public static final Action PRINT_ACTION;
    public static final Action REFRESH_ACTION;
    public static final Action ABOUT_ACTION;
    private final GlassPane glassPane;
    private String dasName;
    private JPopupMenu popup;
    private boolean editable;
    private int printing = 0;
    List devicePositionList = new ArrayList();
    DnDSupport dndSupport;
    private Set printingThreads;
    private int displayLockCount = 0;
    private Object displayLockObject = new String("DISPLAY_LOCK_OBJECT");
    private static final int R_1024_X_768 = 786432;
    private static final int R_800_X_600 = 480000;
    private static final int R_640_X_480 = 307200;
    private static final int R_320_X_240 = 76800;
    private HashSet horizontalLineSet = new HashSet();
    private HashSet verticalLineSet = new HashSet();
    private HashSet cellSet = new HashSet();

    public static Action[] getActions() {
        return new Action[]{ABOUT_ACTION, REFRESH_ACTION, EDIT_DAS_PROPERTIES_ACTION, PRINT_ACTION, SAVE_AS_PNG_ACTION, SAVE_AS_SVG_ACTION, SAVE_AS_PDF_ACTION};
    }

    public DasCanvas() {
        LookAndFeel.installColorsAndFont(this, "Panel.background", "Panel.foreground", "Panel.font");
        this.setOpaque(true);
        this.setLayout(new RowColumnLayout());
        this.addComponentListener(this.createResizeListener());
        this.setBackground(Color.white);
        this.setDoubleBuffered(true);
        this.glassPane = new GlassPane();
        this.add((Component)this.glassPane, GLASS_PANE_LAYER);
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            this.popup = this.createPopupMenu();
            this.addMouseListener(this.createMouseInputAdapter());
            try {
                this.dndSupport = new CanvasDnDSupport();
            }
            catch (SecurityException ex) {
                this.dndSupport = new CanvasDnDSupport();
            }
        }
    }

    private MouseInputAdapter createMouseInputAdapter() {
        return new MouseInputAdapter(){

            public void mousePressed(MouseEvent e) {
                Point primaryPopupLocation = e.getPoint();
                CanvasAction.currentCanvas = DasCanvas.this;
                DasCanvas.this.popup.show(DasCanvas.this, e.getX(), e.getY());
            }
        };
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        Action[] actions = DasCanvas.getActions();
        for (int iaction = 0; iaction < actions.length; ++iaction) {
            JMenuItem item = new JMenuItem();
            item.setAction(actions[iaction]);
            popup.add(item);
        }
        popup.addSeparator();
        JMenuItem close = new JMenuItem("close");
        close.setToolTipText("close this popup");
        popup.add(close);
        return popup;
    }

    public Component getGlassPane() {
        return this.glassPane;
    }

    public List getDevicePositionList() {
        return Collections.unmodifiableList(this.devicePositionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void lockDisplay(Object o) {
        Object object = this.displayLockObject;
        synchronized (object) {
            ++this.displayLockCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void freeDisplay(Object o) {
        Object object = this.displayLockObject;
        synchronized (object) {
            --this.displayLockCount;
            if (this.displayLockCount == 0) {
                this.displayLockObject.notifyAll();
            }
        }
    }

    public DasCanvas(int width, int height) {
        this();
        this.setPreferredSize(new Dimension(width, height));
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    protected void paintComponent(Graphics g) {
        if (!this.isPrintingThread() || !this.getBackground().equals(Color.WHITE)) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g.setColor(this.getForeground());
        if (this.isPrintingThread()) {
            Date now = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("'UIOWA 'yyyyMMdd");
            String s = dateFormat.format(now);
            Font oldFont = g.getFont();
            Font font = oldFont.deriveFont((float)oldFont.getSize() / 2.0f);
            FontMetrics metrics = g.getFontMetrics(font);
            int width = metrics.stringWidth(s);
            int height = metrics.getHeight();
            g.setFont(font);
            g.drawString(s, this.getWidth() - width - 2 * height, this.getHeight() - 2 * height);
            g.setFont(oldFont);
        }
    }

    public int print(Graphics printGraphics, PageFormat format, int pageIndex) {
        if (pageIndex != 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)printGraphics;
        double canvasWidth = this.getWidth();
        double canvasHeight = this.getHeight();
        double printableWidth = format.getImageableWidth();
        double printableHeight = format.getImageableHeight();
        g2.translate(format.getImageableX(), format.getImageableY());
        double canvasMax = Math.max(canvasWidth, canvasHeight);
        double canvasMin = Math.min(canvasWidth, canvasHeight);
        double printableMax = Math.max(printableWidth, printableHeight);
        double printableMin = Math.min(printableWidth, printableHeight);
        double maxScaleFactor = printableMax / canvasMax;
        double minScaleFactor = printableMin / canvasMin;
        double scaleFactor = Math.min(maxScaleFactor, minScaleFactor);
        g2.scale(scaleFactor, scaleFactor);
        if (canvasWidth == canvasMax ^ printableWidth == printableMax) {
            g2.rotate(1.5707963267948966);
            g2.translate(0.0, -canvasHeight);
        }
        this.print(g2);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isPrintingThread() {
        DasCanvas dasCanvas = this;
        synchronized (dasCanvas) {
            return this.printingThreads == null ? false : this.printingThreads.contains(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics g) {
        DasCanvas dasCanvas = this;
        synchronized (dasCanvas) {
            if (this.printingThreads == null) {
                this.printingThreads = new HashSet();
            }
            this.printingThreads.add(Thread.currentThread());
        }
        try {
            this.setOpaque(false);
            super.print(g);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.setOpaque(true);
            DasCanvas dasCanvas2 = this;
            synchronized (dasCanvas2) {
                this.printingThreads.remove(Thread.currentThread());
            }
            throw throwable;
        }
        this.setOpaque(true);
        DasCanvas dasCanvas3 = this;
        synchronized (dasCanvas3) {
            this.printingThreads.remove(Thread.currentThread());
        }
    }

    public Printable getPrintable() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToPng(String filename) throws IOException {
        FileOutputStream out = new FileOutputStream(filename);
        Image image = this.getImage(this.getWidth(), this.getHeight());
        DasPNGEncoder encoder = new DasPNGEncoder();
        encoder.addText("Creation Time", new Date().toString());
        try {
            encoder.write((BufferedImage)image, out);
        }
        catch (IOException ioe) {
            try {
                out.close();
            }
            catch (IOException ioe2) {
                throw new RuntimeException(ioe2);
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public void writeToPDF(String filename) throws IOException {
        try {
            this.writeToGraphicsOutput(filename, "edu.uiowa.physics.pw.das.util.awt.PdfGraphicsOutput");
        }
        catch (ClassNotFoundException cnfe) {
            DasExceptionHandler.handle(new RuntimeException("PDF output is not available", cnfe));
        }
        catch (InstantiationException ie) {
            DasExceptionHandler.handleUncaught(ie);
        }
        catch (IllegalAccessException iae) {
            DasExceptionHandler.handleUncaught(iae);
        }
    }

    public void writeToGraphicsOutput(String filename, String graphicsOutput) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        FileOutputStream out = new FileOutputStream(filename);
        Class<?> goClass = Class.forName(graphicsOutput);
        GraphicsOutput go = (GraphicsOutput)goClass.newInstance();
        go.setOutputStream(out);
        go.setSize(this.getWidth(), this.getHeight());
        go.start();
        this.print(go.getGraphics());
        go.finish();
    }

    public void writeToSVG(String filename) throws IOException {
        try {
            this.writeToGraphicsOutput(filename, "edu.uiowa.physics.pw.das.util.awt.SvgGraphicsOutput");
        }
        catch (ClassNotFoundException cnfe) {
            DasExceptionHandler.handle(new RuntimeException("SVG output is not available", cnfe));
        }
        catch (InstantiationException ie) {
            DasExceptionHandler.handleUncaught(ie);
        }
        catch (IllegalAccessException iae) {
            DasExceptionHandler.handleUncaught(iae);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilIdle() {
        String msg = "dasCanvas.waitUntilIdle";
        Logger logger = DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG);
        logger.fine(msg);
        final Object lockObject = new Object();
        if (!EventQueue.isDispatchThread()) {
            try {
                Object object = lockObject;
                synchronized (object) {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            Object object = lockObject;
                            synchronized (object) {
                                lockObject.notifyAll();
                            }
                        }
                    });
                    lockObject.wait();
                }
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
        Runnable request = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = lockObject;
                synchronized (object) {
                    lockObject.notifyAll();
                }
            }
        };
        try {
            Object object = lockObject;
            synchronized (object) {
                RequestProcessor.invokeAfter(request, this);
                lockObject.wait();
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        logger.fine("canvas is idle");
    }

    public Image getImage(int width, int height) {
        String msg = "dasCanvas.getImage(" + width + "," + height + ")";
        Logger logger = DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG);
        logger.fine(msg);
        this.setPreferredWidth(width);
        this.setPreferredHeight(height);
        if ("true".equals(System.getProperty("java.awt.headless"))) {
            this.addNotify();
            this.setSize(this.getPreferredSize());
            this.validate();
        }
        this.waitUntilIdle();
        BufferedImage image = new BufferedImage(width, height, 1);
        this.writeToImageImmediately(image);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToImageImmediately(Image image) {
        try {
            Object object = this.displayLockObject;
            synchronized (object) {
                if (this.displayLockCount != 0) {
                    this.displayLockObject.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, image.getWidth(this), image.getHeight(this));
        this.print(graphics);
    }

    public void add(DasCanvasComponent c, DasRow row, DasColumn column) {
        if (c.getRow() == DasRow.NULL || c.getRow().getParent() != this || c.getRow() instanceof RowWrapper) {
            c.setRow(RowWrapper.wrap(this, row));
        }
        if (c.getColumn() == DasColumn.NULL || c.getColumn().getParent() != this || c.getColumn() instanceof ColumnWrapper) {
            c.setColumn(ColumnWrapper.wrap(this, column));
        }
        this.add(c);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp == null) {
            DasDie.println("NULL COMPONENT");
            Thread.dumpStack();
            return;
        }
        if (index < 0) {
            index = 0;
        }
        if (comp instanceof DasPlot) {
            ((DasPlot)comp).putClientProperty("layeredContainerLayer", PLOT_LAYER);
        } else if (comp instanceof DasAxis) {
            ((DasAxis)comp).putClientProperty("layeredContainerLayer", AXIS_LAYER);
        } else if (comp instanceof JComponent) {
            ((JComponent)comp).putClientProperty("layeredContainerLayer", DEFAULT_LAYER);
        }
        super.addImpl(comp, constraints, index);
        if (comp instanceof DasCanvasComponent) {
            ((DasCanvasComponent)comp).installComponent();
        }
    }

    public void setPreferredWidth(int width) {
        Dimension pref = this.getPreferredSize();
        pref.width = width;
        this.setPreferredSize(pref);
    }

    public void setPreferredHeight(int height) {
        Dimension pref = this.getPreferredSize();
        pref.height = height;
        this.setPreferredSize(pref);
    }

    public Font getBaseFont() {
        return this.getFont();
    }

    private ComponentListener createResizeListener() {
        return new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                int height;
                int width = DasCanvas.this.getWidth();
                int area = width * (height = DasCanvas.this.getHeight());
                Font f = area >= 633216 ? DasCanvas.this.getFont().deriveFont(18.0f) : (area >= 393600 ? DasCanvas.this.getFont().deriveFont(14.0f) : (area >= 192000 ? DasCanvas.this.getFont().deriveFont(12.0f) : (area >= 38400 ? DasCanvas.this.getFont().deriveFont(8.0f) : DasCanvas.this.getFont().deriveFont(6.0f))));
                DasCanvas.this.setFont(f);
            }
        };
    }

    public Element getDOMElement(Document document) {
        int index;
        Element element = document.createElement("canvas");
        Dimension size = this.getPreferredSize();
        element.setAttribute("name", this.getDasName());
        element.setAttribute("width", Integer.toString(size.width));
        element.setAttribute("height", Integer.toString(size.height));
        for (int index2 = 0; index2 < this.devicePositionList.size(); ++index2) {
            Object obj = this.devicePositionList.get(index2);
            if (obj instanceof DasRow) {
                DasRow row = (DasRow)obj;
                element.appendChild(row.getDOMElement(document));
                continue;
            }
            if (!(obj instanceof DasColumn)) continue;
            DasColumn column = (DasColumn)obj;
            element.appendChild(column.getDOMElement(document));
        }
        Component[] components = this.getComponents();
        LinkedHashMap<String, Element> elementMap = new LinkedHashMap<String, Element>();
        for (index = 0; index < components.length; ++index) {
            if (!(components[index] instanceof DasAxis)) continue;
            DasAxis axis = (DasAxis)components[index];
            elementMap.put(axis.getDasName(), axis.getDOMElement(document));
        }
        for (index = 0; index < components.length; ++index) {
            if (!(components[index] instanceof DasColorBar)) continue;
            DasColorBar colorbar = (DasColorBar)components[index];
            elementMap.put(colorbar.getDasName(), colorbar.getDOMElement(document));
        }
        for (index = 0; index < components.length; ++index) {
            DasPlot plot;
            if (components[index] instanceof DasSpectrogramPlot) {
                plot = (DasSpectrogramPlot)components[index];
                elementMap.remove(plot.getXAxis().getDasName());
                elementMap.remove(plot.getYAxis().getDasName());
                elementMap.remove(((DasSpectrogramPlot)plot).getColorBar().getDasName());
                elementMap.put(plot.getDasName(), ((DasSpectrogramPlot)plot).getDOMElement(document));
                continue;
            }
            if (!(components[index] instanceof DasPlot)) continue;
            plot = (DasPlot)components[index];
            elementMap.remove(plot.getXAxis().getDasName());
            elementMap.remove(plot.getYAxis().getDasName());
            Renderer[] renderers = plot.getRenderers();
            for (int i = 0; i < renderers.length; ++i) {
                if (!(renderers[i] instanceof SpectrogramRenderer)) continue;
                SpectrogramRenderer spectrogram = (SpectrogramRenderer)renderers[i];
                elementMap.remove(spectrogram.getColorBar().getDasName());
            }
            elementMap.put(plot.getDasName(), plot.getDOMElement(document));
        }
        Iterator iterator = elementMap.values().iterator();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            if (e == null) continue;
            element.appendChild(e);
        }
        return element;
    }

    public static DasCanvas processCanvasElement(Element element, FormBase form) throws DasPropertyException, DasNameException, DasException, ParsedExpressionException, ParseException {
        try {
            String name = element.getAttribute("name");
            int width = Integer.parseInt(element.getAttribute("width"));
            int height = Integer.parseInt(element.getAttribute("height"));
            DasApplication app = form.getDasApplication();
            NameContext nc = app.getNameContext();
            DasCanvas canvas = new DasCanvas(width, height);
            NodeList children = element.getChildNodes();
            int childCount = children.getLength();
            for (int index = 0; index < childCount; ++index) {
                Node node = children.item(index);
                if (!(node instanceof Element)) continue;
                String tagName = node.getNodeName();
                if (tagName.equals("row")) {
                    DasRow row = DasRow.processRowElement((Element)node, canvas, form);
                    continue;
                }
                if (tagName.equals("column")) {
                    DasColumn column = DasColumn.processColumnElement((Element)node, canvas, form);
                    continue;
                }
                if (tagName.equals("axis")) {
                    DasAxis axis = DasAxis.processAxisElement((Element)node, form);
                    canvas.add(axis);
                    continue;
                }
                if (tagName.equals("timeaxis")) {
                    DasAxis timeaxis = DasAxis.processTimeaxisElement((Element)node, form);
                    canvas.add(timeaxis);
                    continue;
                }
                if (tagName.equals("attachedaxis")) {
                    DasAxis attachedaxis = DasAxis.processAttachedaxisElement((Element)node, form);
                    canvas.add(attachedaxis);
                    continue;
                }
                if (tagName.equals("colorbar")) {
                    DasColorBar colorbar = DasColorBar.processColorbarElement((Element)node, form);
                    canvas.add(colorbar);
                    continue;
                }
                if (tagName.equals("spectrogram")) {
                    DasSpectrogramPlot spectrogram = DasSpectrogramPlot.processSpectrogramElement((Element)node, form);
                    canvas.add(spectrogram);
                    continue;
                }
                if (!tagName.equals("plot")) continue;
                DasPlot plot = DasPlot.processPlotElement((Element)node, form);
                canvas.add(plot);
            }
            canvas.setDasName(name);
            nc.put(name, canvas);
            return canvas;
        }
        catch (DasPropertyException dpe) {
            if (!element.getAttribute("name").equals("")) {
                dpe.setObjectName(element.getAttribute("name"));
            }
            throw dpe;
        }
    }

    public static DasCanvas createFormCanvas(String name, int width, int height) {
        DasCanvas canvas = new DasCanvas(width, height);
        if (name == null) {
            name = "canvas_" + Integer.toHexString(System.identityHashCode(canvas));
        }
        try {
            canvas.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle(dne);
        }
        return canvas;
    }

    public DasCanvasComponent getCanvasComponentAt(int x, int y) {
        Component[] components = this.getComponents();
        for (int index = 1; index < components.length; ++index) {
            DasCanvasComponent cc;
            Component c = components[index];
            if (!(c instanceof DasCanvasComponent) || !(cc = (DasCanvasComponent)c).getActiveRegion().contains(x, y)) continue;
            return cc;
        }
        return null;
    }

    public void remove(int index) {
        Component comp = this.getComponent(index);
        super.remove(index);
        if (comp instanceof DasCanvasComponent) {
            ((DasCanvasComponent)comp).uninstallComponent();
        }
    }

    public HotLine getLineAt(int x, int y) {
        HotLine line;
        Iterator iterator = this.horizontalLineSet.iterator();
        while (iterator.hasNext()) {
            line = (HotLine)iterator.next();
            if (y < line.position - 1 || y > line.position + 1) continue;
            return line;
        }
        iterator = this.verticalLineSet.iterator();
        while (iterator.hasNext()) {
            line = (HotLine)iterator.next();
            if (x < line.position - 1 || x > line.position + 1) continue;
            return line;
        }
        return null;
    }

    public Cell getCellAt(int x, int y) {
        Cell best = null;
        Point bestCenter = null;
        Point boxCenter = null;
        Iterator iterator = this.cellSet.iterator();
        while (iterator.hasNext()) {
            Cell box = (Cell)iterator.next();
            Rectangle rc = box.rc;
            if (!rc.contains(x, y)) continue;
            if (best == null) {
                best = box;
                continue;
            }
            if (bestCenter == null) {
                bestCenter = new Point();
                boxCenter = new Point();
            }
            if (best.rc.contains(rc)) {
                best = box;
                continue;
            }
            bestCenter.setLocation(best.rc.x + best.rc.width / 2, best.rc.y + best.rc.height / 2);
            boxCenter.setLocation(rc.x + rc.width / 2, rc.y + rc.height / 2);
            int bestDistance = DasCanvas.distanceSquared(x, y, bestCenter.x, bestCenter.y);
            int boxDistance = DasCanvas.distanceSquared(x, y, boxCenter.x, boxCenter.y);
            if (boxDistance < bestDistance) {
                best = box;
                continue;
            }
            if (boxDistance != bestDistance || rc.width * rc.height >= best.rc.width * best.rc.height) continue;
            best = box;
        }
        return best;
    }

    private static int distanceSquared(int x1, int y1, int x2, int y2) {
        return (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1);
    }

    void addDevicePosition(DasDevicePosition position) {
        this.devicePositionList.add(position);
        if (position instanceof DasRow) {
            this.addRow((DasRow)position);
        } else if (position instanceof DasColumn) {
            this.addColumn((DasColumn)position);
        }
    }

    private void addRow(DasRow row) {
        if (row instanceof RowWrapper) {
            return;
        }
        HotLine min = new HotLine(row, -1);
        HotLine max = new HotLine(row, 1);
        this.horizontalLineSet.add(min);
        this.horizontalLineSet.add(max);
        Iterator iterator = this.devicePositionList.iterator();
        while (iterator.hasNext()) {
            DasDevicePosition position = (DasDevicePosition)iterator.next();
            if (!(position instanceof DasColumn)) continue;
            DasColumn column = (DasColumn)position;
            this.cellSet.add(new Cell(row, column));
        }
    }

    private void addColumn(DasColumn column) {
        if (column instanceof ColumnWrapper) {
            return;
        }
        HotLine min = new HotLine(column, -1);
        HotLine max = new HotLine(column, 1);
        this.verticalLineSet.add(min);
        this.verticalLineSet.add(max);
        Iterator iterator = this.devicePositionList.iterator();
        while (iterator.hasNext()) {
            DasDevicePosition position = (DasDevicePosition)iterator.next();
            if (!(position instanceof DasRow)) continue;
            DasRow row = (DasRow)position;
            this.cellSet.add(new Cell(row, column));
        }
    }

    public void removepwDevicePosition(DasDevicePosition position) {
        this.devicePositionList.remove(position);
        if (position instanceof DasRow) {
            this.removeRow((DasRow)position);
        } else if (position instanceof DasColumn) {
            this.removeColumn((DasColumn)position);
        }
    }

    private void removeRow(DasRow row) {
        Iterator i = this.horizontalLineSet.iterator();
        while (i.hasNext()) {
            HotLine line = (HotLine)i.next();
            if (line.devicePosition != row) continue;
            i.remove();
        }
        i = this.cellSet.iterator();
        while (i.hasNext()) {
            Cell cell = (Cell)i.next();
            if (cell.row != row) continue;
            i.remove();
        }
    }

    private void removeColumn(DasColumn column) {
        Iterator i = this.verticalLineSet.iterator();
        while (i.hasNext()) {
            HotLine line = (HotLine)i.next();
            if (line.devicePosition != column) continue;
            i.remove();
        }
        i = this.cellSet.iterator();
        while (i.hasNext()) {
            Cell cell = (Cell)i.next();
            if (cell.column != column) continue;
            i.remove();
        }
    }

    public FormBase getForm() {
        Container parent = this.getParent();
        if (parent instanceof FormComponent) {
            return ((FormComponent)((Object)parent)).getForm();
        }
        return null;
    }

    public boolean getEditingMode() {
        return this.editable;
    }

    public void setEditingMode(boolean b) {
        if (this.editable == b) {
            return;
        }
        this.editable = b;
        this.revalidate();
    }

    public DnDSupport getDnDSupport() {
        return this.dndSupport;
    }

    public boolean startDrag(int x, int y, int action, MouseEvent evt) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!this.getComponent(i).getBounds().contains(x, y)) continue;
            this.dndSupport.startDrag(x, y, action, evt);
            return true;
        }
        return false;
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String name) throws DasNameException {
        if (name.equals(this.dasName)) {
            return;
        }
        String oldName = this.dasName;
        this.dasName = name;
        DasApplication app = this.getDasApplication();
        if (app != null) {
            app.getNameContext().put(name, this);
            if (oldName != null) {
                app.getNameContext().remove(oldName);
            }
        }
        this.firePropertyChange("name", oldName, name);
    }

    public void deregisterComponent() {
        DasApplication app = this.getDasApplication();
        if (app != null) {
            IllegalStateException se;
            NameContext nc = app.getNameContext();
            Iterator i = this.devicePositionList.iterator();
            while (i.hasNext()) {
                DasDevicePosition dp = (DasDevicePosition)i.next();
                try {
                    if (nc.get(dp.getDasName()) != dp) continue;
                    nc.remove(dp.getDasName());
                }
                catch (DasPropertyException dpe) {
                    IllegalStateException se2 = new IllegalStateException(dpe.toString());
                    se2.initCause(dpe);
                    throw se2;
                }
                catch (InvocationTargetException ite) {
                    IllegalStateException se3 = new IllegalStateException(ite.toString());
                    se3.initCause(ite);
                    throw se3;
                }
            }
            for (int index = 0; index < this.getComponentCount(); ++index) {
                Component c = this.getComponent(index);
                if (!(c instanceof DasCanvasComponent)) continue;
                DasCanvasComponent cc = (DasCanvasComponent)c;
                try {
                    if (nc.get(cc.getDasName()) != cc) continue;
                    nc.remove(cc.getDasName());
                    continue;
                }
                catch (DasPropertyException dpe) {
                    IllegalStateException se4 = new IllegalStateException(dpe.toString());
                    se4.initCause(dpe);
                    throw se4;
                }
                catch (InvocationTargetException ite) {
                    IllegalStateException se5 = new IllegalStateException(ite.toString());
                    se5.initCause(ite);
                    throw se5;
                }
            }
            try {
                if (nc.get(this.getDasName()) == this) {
                    nc.remove(this.getDasName());
                }
            }
            catch (DasPropertyException dpe) {
                se = new IllegalStateException(dpe.toString());
                se.initCause(dpe);
                throw se;
            }
            catch (InvocationTargetException ite) {
                se = new IllegalStateException(ite.toString());
                se.initCause(ite);
                throw se;
            }
        }
    }

    public DasApplication getDasApplication() {
        Container p = this.getParent();
        if (p instanceof FormComponent) {
            return ((FormComponent)((Object)p)).getDasApplication();
        }
        return null;
    }

    public void registerComponent() throws DasException {
        try {
            DasApplication app = this.getDasApplication();
            if (app != null) {
                NameContext nc = app.getNameContext();
                Iterator i = this.devicePositionList.iterator();
                while (i.hasNext()) {
                    DasDevicePosition dp = (DasDevicePosition)i.next();
                    nc.put(dp.getDasName(), dp);
                }
                for (int index = 0; index < this.getComponentCount(); ++index) {
                    Component c = this.getComponent(index);
                    if (!(c instanceof DasCanvasComponent)) continue;
                    DasCanvasComponent cc = (DasCanvasComponent)c;
                    nc.put(cc.getDasName(), cc);
                }
                nc.put(this.getDasName(), this);
            }
        }
        catch (DasNameException dne) {
            this.deregisterComponent();
            throw dne;
        }
    }

    static {
        float thick = 3.0f;
        int cap = 2;
        int join = 0;
        float[] dash = new float[]{thick * 4.0f, thick * 4.0f};
        STROKE_DASHED = new BasicStroke(thick, cap, join, thick, dash, 0.0f);
        SAVE_AS_PNG_ACTION = new CanvasAction("Save as PNG"){
            JFileChooser pngFileChooser;
            JPanel pngFileNamePanel;
            JTextField pngFileTextField;

            public void actionPerformed(ActionEvent e) {
                if (this.pngFileNamePanel == null) {
                    this.pngFileNamePanel = new JPanel();
                    this.pngFileNamePanel.setLayout(new BoxLayout(this.pngFileNamePanel, 0));
                    this.pngFileTextField = new JTextField(32);
                    this.pngFileTextField.setMaximumSize(this.pngFileTextField.getPreferredSize());
                    this.pngFileChooser = new JFileChooser();
                    this.pngFileChooser.setApproveButtonText("Select File");
                    this.pngFileChooser.setDialogTitle("Write to PNG");
                    JButton b = new JButton("Browse");
                    b.setActionCommand("pngBrowse");
                    b.addActionListener(new ActionListener(this){
                        private final /* synthetic */ 1 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void actionPerformed(ActionEvent e) {
                            int choice = this.this$0.pngFileChooser.showDialog(CanvasAction.currentCanvas, "Select File");
                            if (choice == 0) {
                                this.this$0.pngFileTextField.setText(this.this$0.pngFileChooser.getSelectedFile().getPath());
                            }
                        }
                    });
                    this.pngFileNamePanel.add(this.pngFileTextField);
                    this.pngFileNamePanel.add(b);
                }
                this.pngFileTextField.setText(this.pngFileChooser.getCurrentDirectory().getPath());
                Object[] options = new String[]{"Save as PNG", "Cancel"};
                int choice = JOptionPane.showOptionDialog(currentCanvas, this.pngFileNamePanel, "Write to PNG", 0, 3, null, options, "Ok");
                if (choice == 0) {
                    DasCanvas canvas = currentCanvas;
                    try {
                        canvas.writeToPng(this.pngFileTextField.getText());
                    }
                    catch (IOException ioe) {
                        DasExceptionHandler.handle(ioe);
                    }
                }
            }
        };
        SAVE_AS_SVG_ACTION = new CanvasAction("Save as SVG"){
            JFileChooser svgFileChooser;
            JPanel svgFileNamePanel;
            JTextField svgFileTextField;

            public void actionPerformed(ActionEvent e) {
                if (this.svgFileNamePanel == null) {
                    this.svgFileNamePanel = new JPanel();
                    this.svgFileNamePanel.setLayout(new BoxLayout(this.svgFileNamePanel, 0));
                    this.svgFileTextField = new JTextField(32);
                    this.svgFileTextField.setMaximumSize(this.svgFileTextField.getPreferredSize());
                    this.svgFileChooser = new JFileChooser();
                    this.svgFileChooser.setApproveButtonText("Select File");
                    this.svgFileChooser.setDialogTitle("Write to SVG");
                    JButton b = new JButton("Browse");
                    b.setActionCommand("pngBrowse");
                    b.addActionListener(new ActionListener(this){
                        private final /* synthetic */ 3 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void actionPerformed(ActionEvent e) {
                            int choice = this.this$0.svgFileChooser.showDialog(CanvasAction.currentCanvas, "Select File");
                            if (choice == 0) {
                                this.this$0.svgFileTextField.setText(this.this$0.svgFileChooser.getSelectedFile().getPath());
                            }
                        }
                    });
                    this.svgFileNamePanel.add(this.svgFileTextField);
                    this.svgFileNamePanel.add(b);
                }
                this.svgFileTextField.setText(this.svgFileChooser.getCurrentDirectory().getPath());
                Object[] options = new String[]{"Save as SVG", "Cancel"};
                int choice = JOptionPane.showOptionDialog(currentCanvas, this.svgFileNamePanel, "Write to SVG", 0, 3, null, options, "Ok");
                if (choice == 0) {
                    DasCanvas canvas = currentCanvas;
                    try {
                        canvas.writeToSVG(this.svgFileTextField.getText());
                    }
                    catch (IOException ioe) {
                        DasExceptionHandler.handle(ioe);
                    }
                }
            }
        };
        SAVE_AS_PDF_ACTION = new CanvasAction("Save as PDF"){
            JFileChooser pdfFileChooser;
            JPanel pdfFileNamePanel;
            JTextField pdfFileTextField;

            public void actionPerformed(ActionEvent e) {
                if (this.pdfFileNamePanel == null) {
                    this.pdfFileNamePanel = new JPanel();
                    this.pdfFileNamePanel.setLayout(new BoxLayout(this.pdfFileNamePanel, 0));
                    this.pdfFileTextField = new JTextField(32);
                    this.pdfFileTextField.setMaximumSize(this.pdfFileTextField.getPreferredSize());
                    this.pdfFileChooser = new JFileChooser();
                    this.pdfFileChooser.setApproveButtonText("Select File");
                    this.pdfFileChooser.setDialogTitle("Write to PDF");
                    JButton b = new JButton("Browse");
                    b.setActionCommand("pngBrowse");
                    b.addActionListener(new ActionListener(this){
                        private final /* synthetic */ 5 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void actionPerformed(ActionEvent e) {
                            int choice = this.this$0.pdfFileChooser.showDialog(CanvasAction.currentCanvas, "Select File");
                            if (choice == 0) {
                                this.this$0.pdfFileTextField.setText(this.this$0.pdfFileChooser.getSelectedFile().getPath());
                            }
                        }
                    });
                    this.pdfFileNamePanel.add(this.pdfFileTextField);
                    this.pdfFileNamePanel.add(b);
                }
                this.pdfFileTextField.setText(this.pdfFileChooser.getCurrentDirectory().getPath());
                Object[] options = new String[]{"Save as PDF", "Cancel"};
                int choice = JOptionPane.showOptionDialog(currentCanvas, this.pdfFileNamePanel, "Write to PDF", 0, 3, null, options, "Ok");
                if (choice == 0) {
                    DasCanvas canvas = currentCanvas;
                    try {
                        canvas.writeToPDF(this.pdfFileTextField.getText());
                    }
                    catch (IOException ioe) {
                        DasExceptionHandler.handle(ioe);
                    }
                }
            }
        };
        EDIT_DAS_PROPERTIES_ACTION = new AbstractAction("DAS Properties"){

            public void actionPerformed(ActionEvent e) {
                DasProperties.showEditor();
            }
        };
        PRINT_ACTION = new CanvasAction("Print..."){

            public void actionPerformed(ActionEvent e) {
                Printable p = currentCanvas.getPrintable();
                PrinterJob pj = PrinterJob.getPrinterJob();
                pj.setPrintable(p);
                if (pj.printDialog()) {
                    try {
                        pj.print();
                    }
                    catch (PrinterException pe) {
                        Object[] message = new Object[]{"Error printing", pe.getMessage()};
                        JOptionPane.showMessageDialog(null, message, "ERROR", 0);
                    }
                }
            }
        };
        REFRESH_ACTION = new CanvasAction("Refresh"){

            public void actionPerformed(ActionEvent e) {
            }
        };
        ABOUT_ACTION = new CanvasAction("About"){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showConfirmDialog(currentCanvas, "release version " + Splash.getVersion(), "about das2", -1);
                currentCanvas.setSize(currentCanvas.getWidth() + 1, currentCanvas.getHeight() + 1);
                currentCanvas.setSize(currentCanvas.getWidth(), currentCanvas.getHeight());
            }
        };
    }

    public static class Cell
    implements PropertyChangeListener {
        Rectangle rc;
        DasRow row;
        DasColumn column;

        Cell(DasRow row, DasColumn column) {
            this.row = row;
            this.column = column;
            this.rc = new Rectangle();
            row.addPropertyChangeListener("dMinimum", this);
            row.addPropertyChangeListener("dMaximum", this);
            column.addPropertyChangeListener("dMinimum", this);
            column.addPropertyChangeListener("dMaximum", this);
            this.rc.x = (int)Math.floor((double)column.getDMinimum() + 0.5);
            this.rc.y = (int)Math.floor((double)row.getDMinimum() + 0.5);
            this.rc.width = (int)Math.floor((double)column.getDMaximum() + 0.5) - this.rc.x;
            this.rc.height = (int)Math.floor((double)row.getDMaximum() + 0.5) - this.rc.y;
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() == this.row) {
                this.rc.y = (int)Math.floor((double)this.row.getDMinimum() + 0.5);
                this.rc.height = (int)Math.floor((double)this.row.getDMaximum() + 0.5) - this.rc.y;
            } else {
                this.rc.x = (int)Math.floor((double)this.column.getDMinimum() + 0.5);
                this.rc.width = (int)Math.floor((double)this.column.getDMaximum() + 0.5) - this.rc.x;
            }
        }

        public boolean equals(Object o) {
            if (o instanceof Cell) {
                Cell box = (Cell)o;
                return box.row == this.row && box.column == this.column;
            }
            return false;
        }

        public String toString() {
            return "{" + this.row.getDasName() + " x " + this.column.getDasName() + ": " + this.rc.toString() + "}";
        }

        public Rectangle getCellBounds() {
            return new Rectangle(this.rc);
        }

        public Rectangle getCellBounds(Rectangle r) {
            if (r == null) {
                return this.getCellBounds();
            }
            r.setBounds(this.rc);
            return r;
        }

        public DasRow getRow() {
            return this.row;
        }

        public DasColumn getColumn() {
            return this.column;
        }
    }

    public static class HotLine
    implements PropertyChangeListener {
        public static final int MIN = -1;
        public static final int NONE = 0;
        public static final int MAX = 1;
        int position;
        DasDevicePosition devicePosition;
        int minOrMax;

        HotLine(DasDevicePosition devicePosition, int minOrMax) {
            this.devicePosition = devicePosition;
            this.minOrMax = minOrMax;
            if (!(devicePosition instanceof RowWrapper) && !(devicePosition instanceof ColumnWrapper)) {
                this.refresh();
            }
            devicePosition.addPropertyChangeListener(minOrMax == -1 ? "dMinimum" : "dMaximum", this);
        }

        void refresh() {
            this.position = this.minOrMax == -1 ? (int)Math.floor((double)this.devicePosition.getDMinimum() + 0.5) : (int)Math.floor((double)this.devicePosition.getDMaximum() + 0.5);
        }

        public void propertyChange(PropertyChangeEvent e) {
            this.refresh();
        }

        public boolean equals(Object o) {
            if (o instanceof HotLine) {
                HotLine h = (HotLine)o;
                return h.devicePosition == this.devicePosition && h.minOrMax == this.minOrMax;
            }
            return false;
        }

        public int hashCode() {
            return this.minOrMax * this.devicePosition.hashCode();
        }

        public String toString() {
            return "{" + this.devicePosition.getDasName() + (this.minOrMax == -1 ? ", MIN, " : ", MAX, ") + this.position + "}";
        }

        public DasDevicePosition getDevicePosition() {
            return this.devicePosition;
        }

        public int getMinOrMax() {
            return this.minOrMax;
        }
    }

    private static class GlassPane
    extends JPanel
    implements MouseInputListener,
    KeyListener {
        boolean blocking = false;
        boolean accepting = false;
        Rectangle target;

        public GlassPane() {
            this.setOpaque(false);
            this.setLayout(null);
        }

        DasCanvas getCanvas() {
            return (DasCanvas)this.getParent();
        }

        void setBlocking(boolean b) {
            if (b != this.blocking) {
                this.blocking = b;
                if (b) {
                    this.addMouseListener(this);
                    this.addMouseMotionListener(this);
                } else {
                    this.removeMouseListener(this);
                    this.removeMouseMotionListener(this);
                }
                this.repaint();
            }
        }

        void setAccepting(boolean b) {
            if (b != this.accepting) {
                this.accepting = b;
                this.repaint();
            }
        }

        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.blocking) {
                this.paintLoading(g2);
            }
            if (((DasCanvas)this.getParent()).getEditingMode()) {
                this.paintRowColumn(g2);
            }
            if (this.accepting && this.target != null) {
                this.paintDnDTarget(g2);
            }
        }

        private void paintRowColumn(Graphics2D g2) {
            g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            DasCanvas canvas = this.getCanvas();
            Iterator i = canvas.devicePositionList.iterator();
            while (i.hasNext()) {
                Paint paint;
                int height;
                int y;
                int width;
                int x;
                DasDevicePosition d = (DasDevicePosition)i.next();
                double minimum = d.getMinimum();
                double maximum = d.getMaximum();
                int cWidth = canvas.getWidth();
                int cHeight = canvas.getHeight();
                if (d instanceof DasRow) {
                    x = 0;
                    width = cWidth;
                    y = (int)Math.floor(minimum * (double)cHeight + 0.5);
                    height = (int)Math.floor(maximum * (double)cHeight + 0.5) - y;
                    paint = PAINT_ROW;
                } else {
                    x = (int)Math.floor(minimum * (double)cWidth + 0.5);
                    width = (int)Math.floor(maximum * (double)cWidth + 0.5) - x;
                    y = 0;
                    height = cHeight;
                    paint = PAINT_COLUMN;
                }
                g2.setPaint(paint);
                g2.fillRect(x, y, width, height);
            }
        }

        private void paintDnDTarget(Graphics2D g2) {
            g2.setStroke(STROKE_DASHED);
            g2.setPaint(PAINT_SELECTION);
            g2.drawRect(this.target.x + 1, this.target.y + 1, this.target.width - 2, this.target.height - 2);
        }

        private void paintLoading(Graphics2D g2) {
            g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            g2.setColor(new Color(-587202561, true));
            Rectangle rect = g2.getClipBounds();
            if (rect == null) {
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else {
                g2.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    private class CanvasDnDSupport
    extends DnDSupport {
        private List acceptList = Arrays.asList(TransferableCanvasComponent.PLOT_FLAVOR, TransferableCanvasComponent.AXIS_FLAVOR, TransferableCanvasComponent.COLORBAR_FLAVOR);

        CanvasDnDSupport() {
            super(DasCanvas.this, 3, null);
        }

        private Rectangle getAxisRectangle(Rectangle rc, Rectangle t, int x, int y) {
            if (t == null) {
                t = new Rectangle();
            }
            int o = this.getAxisOrientation(rc, x, y);
            switch (o) {
                case 1: {
                    t.width = rc.width;
                    t.height = 3 * DasCanvas.this.getFont().getSize();
                    t.x = rc.x;
                    t.y = rc.y - t.height;
                    break;
                }
                case 4: {
                    t.width = 3 * DasCanvas.this.getFont().getSize();
                    t.height = rc.height;
                    t.x = rc.x + rc.width;
                    t.y = rc.y;
                    break;
                }
                case 3: {
                    t.width = 3 * DasCanvas.this.getFont().getSize();
                    t.height = rc.height;
                    t.x = rc.x - t.width;
                    t.y = rc.y;
                    break;
                }
                case 2: {
                    t.width = rc.width;
                    t.height = 3 * DasCanvas.this.getFont().getSize();
                    t.x = rc.x;
                    t.y = rc.y + rc.height;
                    break;
                }
                default: {
                    throw new RuntimeException("invalid orientation: " + o);
                }
            }
            return t;
        }

        private int getAxisOrientation(Rectangle rc, int x, int y) {
            boolean b;
            int nx = (x - rc.x) * rc.height;
            int ny = (y - rc.y) * rc.width;
            int a = rc.width * rc.height;
            boolean bl = b = nx + ny < a;
            return nx > ny ? (b ? 1 : 4) : (b ? 3 : 2);
        }

        protected int canAccept(DataFlavor[] flavors, int x, int y, int action) {
            DasCanvas.this.glassPane.setAccepting(true);
            List<DataFlavor> flavorList = Arrays.asList(flavors);
            Cell cell = DasCanvas.this.getCellAt(x, y);
            Rectangle cellBounds = cell == null ? null : cell.getCellBounds();
            Rectangle target = ((DasCanvas)DasCanvas.this).glassPane.target;
            if (flavorList.contains(TransferableCanvasComponent.COLORBAR_FLAVOR)) {
                return action;
            }
            if (flavorList.contains(TransferableCanvasComponent.AXIS_FLAVOR)) {
                if (!(target == cellBounds || target != null && target.equals(cellBounds))) {
                    if (target != null) {
                        DasCanvas.this.glassPane.repaint(target.x - 1, target.y - 1, target.width + 2, target.height + 2);
                    }
                    if (cellBounds != null) {
                        target = ((DasCanvas)DasCanvas.this).glassPane.target = this.getAxisRectangle(cellBounds, target, x, y);
                        DasCanvas.this.glassPane.repaint(target.x - 1, target.y - 1, target.width + 2, target.height + 2);
                    } else {
                        ((DasCanvas)DasCanvas.this).glassPane.target = null;
                    }
                }
                return action;
            }
            if (flavorList.contains(TransferableCanvasComponent.CANVAS_COMPONENT_FLAVOR)) {
                if (!(target == cellBounds || target != null && target.equals(cellBounds))) {
                    if (target != null) {
                        DasCanvas.this.glassPane.repaint(target.x - 1, target.y - 1, target.width + 2, target.height + 2);
                    }
                    target = ((DasCanvas)DasCanvas.this).glassPane.target = cellBounds;
                    if (cellBounds != null) {
                        DasCanvas.this.glassPane.repaint(target.x - 1, target.y - 1, target.width + 2, target.height + 2);
                    }
                }
                return action;
            }
            return -1;
        }

        protected void done() {
            DasCanvas.this.glassPane.setAccepting(false);
            if (((DasCanvas)DasCanvas.this).glassPane.target != null) {
                Rectangle target = ((DasCanvas)DasCanvas.this).glassPane.target;
                ((DasCanvas)DasCanvas.this).glassPane.target = null;
                DasCanvas.this.glassPane.repaint(target.x - 1, target.y - 1, target.width + 2, target.height + 2);
            }
        }

        protected boolean importData(Transferable t, int x, int y, int action) {
            boolean success = false;
            try {
                Cell c;
                if (t.isDataFlavorSupported(TransferableCanvasComponent.COLORBAR_FLAVOR)) {
                    Cell c2 = DasCanvas.this.getCellAt(x, y);
                    if (c2 != null) {
                        DasCanvasComponent comp = (DasCanvasComponent)t.getTransferData(TransferableCanvasComponent.CANVAS_COMPONENT_FLAVOR);
                        comp.setRow(c2.getRow());
                        comp.setColumn(c2.getColumn());
                        DasCanvas.this.add(comp);
                        DasCanvas.this.revalidate();
                        success = true;
                    }
                } else if (t.isDataFlavorSupported(TransferableCanvasComponent.AXIS_FLAVOR)) {
                    Cell c3 = DasCanvas.this.getCellAt(x, y);
                    if (c3 != null) {
                        DasAxis axis = (DasAxis)t.getTransferData(TransferableCanvasComponent.AXIS_FLAVOR);
                        axis.setRow(c3.getRow());
                        axis.setColumn(c3.getColumn());
                        Rectangle cellBounds = c3.getCellBounds();
                        int orientation = this.getAxisOrientation(cellBounds, x, y);
                        axis.setOrientation(orientation);
                        DasCanvas.this.add(axis);
                        DasCanvas.this.revalidate();
                        success = true;
                    }
                } else if (t.isDataFlavorSupported(TransferableCanvasComponent.CANVAS_COMPONENT_FLAVOR) && (c = DasCanvas.this.getCellAt(x, y)) != null) {
                    DasCanvasComponent comp = (DasCanvasComponent)t.getTransferData(TransferableCanvasComponent.CANVAS_COMPONENT_FLAVOR);
                    comp.setRow(c.getRow());
                    comp.setColumn(c.getColumn());
                    DasCanvas.this.add(comp);
                    DasCanvas.this.revalidate();
                    success = true;
                }
            }
            catch (UnsupportedFlavorException ufe) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return success;
        }

        protected Transferable getTransferable(int x, int y, int action) {
            DasCanvasComponent component = DasCanvas.this.getCanvasComponentAt(x, y);
            if (component instanceof DasColorBar) {
                return new TransferableCanvasComponent((DasColorBar)component);
            }
            if (component instanceof DasAxis) {
                return new TransferableCanvasComponent((DasAxis)component);
            }
            if (component instanceof DasPlot) {
                return new TransferableCanvasComponent((DasPlot)component);
            }
            return null;
        }

        protected void exportDone(Transferable t, int action) {
        }
    }

    protected static class RowColumnLayout
    implements LayoutManager {
        protected RowColumnLayout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                int count = target.getComponentCount();
                for (int i = 0; i < count; ++i) {
                    Component c = target.getComponent(i);
                    if (c instanceof DasCanvasComponent) {
                        ((DasCanvasComponent)c).update();
                        continue;
                    }
                    if (c != ((DasCanvas)target).glassPane) continue;
                    Dimension size = target.getSize();
                    c.setBounds(0, 0, size.width, size.height);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension minimumLayoutSize(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                int count = target.getComponentCount();
                Rectangle r = new Rectangle(0, 0, 0, 0);
                for (int i = 0; i < count; ++i) {
                    r.add(target.getComponent(i).getBounds());
                }
                return new Dimension(r.width, r.height);
            }
        }

        public Dimension preferredLayoutSize(Container target) {
            return this.minimumLayoutSize(target);
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }
    }

    public static class ColumnWrapper
    extends DasColumn {
        private DasColumn delegate;

        private static ColumnWrapper wrap(DasCanvas canvas, DasColumn column) {
            return column instanceof ColumnWrapper ? (ColumnWrapper)column : new ColumnWrapper(canvas, column);
        }

        private ColumnWrapper(DasCanvas canvas, DasColumn delegate) {
            super(canvas, 1.0, 1.0);
            this.delegate = delegate;
        }

        public void setDasName(String name) throws DasNameException {
            this.delegate.setDasName(name);
        }

        public boolean contains(int x) {
            return this.delegate.contains(x);
        }

        public void setDMaximum(int maximum) {
            this.delegate.setDMaximum(maximum);
        }

        public void dTranslate(int delta) {
            this.delegate.dTranslate(delta);
        }

        public void setDMinimum(int minimum) {
            this.delegate.setDMinimum(minimum);
        }

        public void removepwUpdateListener(DasUpdateListener l) {
            this.delegate.removepwUpdateListener(l);
        }

        public void addpwUpdateListener(DasUpdateListener l) {
            this.delegate.addpwUpdateListener(l);
        }

        public void translate(double nDelta) {
            this.delegate.translate(nDelta);
        }

        public void setMinimum(double minimum) {
            this.delegate.setMinimum(minimum);
        }

        public void setMaximum(double maximum) {
            this.delegate.setMaximum(maximum);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.delegate.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.delegate.removePropertyChangeListener(propertyName, listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.delegate.addPropertyChangeListener(propertyName, listener);
        }

        public String toString() {
            return this.delegate.toString();
        }

        public void setPosition(double minimum, double maximum) {
            this.delegate.setPosition(minimum, maximum);
        }

        public int getDMaximum() {
            return this.delegate.getDMaximum();
        }

        public int getDMinimum() {
            return this.delegate.getDMinimum();
        }

        public void setDPosition(int minimum, int maximum) {
            this.delegate.setDPosition(minimum, maximum);
        }

        public String getDasName() {
            return this.delegate.getDasName();
        }

        public double getMinimum() {
            return this.delegate.getMinimum();
        }

        public int getWidth() {
            return this.delegate.getWidth();
        }

        public double getMaximum() {
            return this.delegate.getMaximum();
        }

        public int getDMiddle() {
            return this.delegate.getDMiddle();
        }
    }

    public static class RowWrapper
    extends DasRow {
        private DasRow delegate = DasRow.NULL;

        private static RowWrapper wrap(DasCanvas canvas, DasRow row) {
            return row instanceof RowWrapper ? (RowWrapper)row : new RowWrapper(canvas, row);
        }

        private RowWrapper(DasCanvas parent, DasRow delegate) {
            super(parent, 0.0, 0.0);
            this.delegate = delegate;
        }

        public void setDasName(String name) throws DasNameException {
            this.delegate.setDasName(name);
        }

        public void setDMaximum(int maximum) {
            this.delegate.setDMaximum(maximum);
        }

        public boolean contains(int x) {
            return this.delegate.contains(x);
        }

        public void dTranslate(int delta) {
            this.delegate.dTranslate(delta);
        }

        public void setDMinimum(int minimum) {
            this.delegate.setDMinimum(minimum);
        }

        public void addpwUpdateListener(DasUpdateListener l) {
            this.delegate.addpwUpdateListener(l);
        }

        public void removepwUpdateListener(DasUpdateListener l) {
            this.delegate.removepwUpdateListener(l);
        }

        public void translate(double nDelta) {
            this.delegate.translate(nDelta);
        }

        public void setMinimum(double minimum) {
            this.delegate.setMinimum(minimum);
        }

        public void setMaximum(double maximum) {
            this.delegate.setMaximum(maximum);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.delegate.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.delegate.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.delegate.removePropertyChangeListener(propertyName, listener);
        }

        public String toString() {
            return this.delegate.toString();
        }

        public void setPosition(double minimum, double maximum) {
            this.delegate.setPosition(minimum, maximum);
        }

        public int getDMaximum() {
            return this.delegate.getDMaximum();
        }

        public int getHeight() {
            return this.delegate.getHeight();
        }

        public void setDPosition(int minimum, int maximum) {
            this.delegate.setDPosition(minimum, maximum);
        }

        public String getDasName() {
            return this.delegate.getDasName();
        }

        public int getDMiddle() {
            return this.delegate.getDMiddle();
        }

        public double getMaximum() {
            return this.delegate.getMaximum();
        }

        public double getMinimum() {
            return this.delegate.getMinimum();
        }

        public int getDMinimum() {
            return this.delegate.getDMinimum();
        }
    }

    protected static abstract class CanvasAction
    extends AbstractAction {
        protected static DasCanvas currentCanvas;

        CanvasAction(String label) {
            super(label);
        }
    }
}

