/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.event.DragRenderer;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.event.MouseRangeSelectionEvent;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class HorizontalRangeRenderer
implements DragRenderer {
    protected int xInitial;
    protected int yInitial;
    private Rectangle dirtyBounds;
    DasCanvasComponent parent;

    public HorizontalRangeRenderer(DasCanvasComponent parent) {
        this.parent = parent;
        this.dirtyBounds = new Rectangle();
    }

    public void renderDrag(Graphics g1, Point p1, Point p2) {
        Graphics2D g = (Graphics2D)g1;
        int x2 = p2.x;
        int x1 = p1.x;
        if (x2 < x1) {
            int t = x2;
            x2 = x1;
            x1 = t;
        }
        int width = x2 - x1;
        int y = p2.y;
        Color color0 = g.getColor();
        g.setColor(new Color(255, 255, 255, 100));
        g.setStroke(new BasicStroke(3.0f, 1, 1));
        if (width > 6) {
            g.drawLine(x1 + 3, y, x2 - 3, y);
        }
        g.drawLine(x1, y + 2, x1, y - 2);
        g.drawLine(x2, y + 2, x2, y - 2);
        g.setStroke(new BasicStroke());
        g.setColor(color0);
        if (width > 6) {
            g.drawLine(x1 + 3, y, x2 - 3, y);
        }
        g.drawLine(x1, y + 2, x1, y - 2);
        g.drawLine(x2, y + 2, x2, y - 2);
        this.dirtyBounds.setLocation(x1 - 2, y + 3);
        this.dirtyBounds.add(x2 + 2, y - 3);
    }

    public MouseDragEvent getMouseDragEvent(Object source, Point p1, Point p2, boolean isModified) {
        return new MouseRangeSelectionEvent(source, p1.x, p2.x, isModified);
    }

    public void clear(Graphics g) {
        this.parent.paintImmediately(this.dirtyBounds);
    }

    public boolean isXRangeSelection() {
        return true;
    }

    public boolean isPointSelection() {
        return false;
    }

    public boolean isYRangeSelection() {
        return false;
    }

    public boolean isUpdatingDragSelection() {
        return false;
    }
}

