/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.dataset.DataSetConsumer;
import edu.uiowa.physics.pw.das.dataset.TableDataSetConsumer;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionListener;
import edu.uiowa.physics.pw.das.event.HorizontalDragRangeRenderer;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.MouseRangeSelectionEvent;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import javax.swing.event.EventListenerList;

public class HorizontalDragRangeSelectorMouseModule
extends MouseModule {
    DasAxis axis;
    int start;
    private EventListenerList listenerList = null;
    private DataSetConsumer dataSetConsumer;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener;

    public HorizontalDragRangeSelectorMouseModule(DasPlot parent, DataSetConsumer dataSetConsumer, DasAxis axis) {
        super(parent, new HorizontalDragRangeRenderer(parent), "Horizontal Drag Range");
        if (!axis.isHorizontal()) {
            throw new IllegalArgumentException("Axis orientation is not horizontal");
        }
        this.dataSetConsumer = dataSetConsumer;
        this.axis = axis;
    }

    public static HorizontalDragRangeSelectorMouseModule create(DasPlot parent) {
        DasAxis axis = parent.getXAxis();
        HorizontalDragRangeSelectorMouseModule result = new HorizontalDragRangeSelectorMouseModule(parent, parent, parent.getXAxis());
        return result;
    }

    public void mouseRangeSelected(MouseDragEvent e0) {
        MouseRangeSelectionEvent e = (MouseRangeSelectionEvent)e0;
        Datum min = this.axis.invTransform(e.getMinimum());
        Datum max = this.axis.invTransform(e.getMaximum());
        DataRangeSelectionEvent te = new DataRangeSelectionEvent(this.parent, min, max);
        this.fireDataRangeSelectionListenerDataRangeSelected(te);
    }

    public synchronized void addDataRangeSelectionListener(DataRangeSelectionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener = HorizontalDragRangeSelectorMouseModule.class$("edu.uiowa.physics.pw.das.event.DataRangeSelectionListener")) : class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener, listener);
    }

    public synchronized void removeDataRangeSelectionListener(DataRangeSelectionListener listener) {
        this.listenerList.remove(class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener = HorizontalDragRangeSelectorMouseModule.class$("edu.uiowa.physics.pw.das.event.DataRangeSelectionListener")) : class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener, listener);
    }

    private void fireDataRangeSelectionListenerDataRangeSelected(DataRangeSelectionEvent event) {
        if (this.dataSetConsumer instanceof TableDataSetConsumer) {
            event.setDataSet(this.dataSetConsumer.getDataSet());
        }
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener == null ? HorizontalDragRangeSelectorMouseModule.class$("edu.uiowa.physics.pw.das.event.DataRangeSelectionListener") : class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener)) continue;
            ((DataRangeSelectionListener)listeners[i + 1]).DataRangeSelected(event);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

