/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.dataset.ClippedTableDataSet;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetConsumer;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSetBuilder;
import edu.uiowa.physics.pw.das.dataset.VectorUtil;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.event.BoxRenderer;
import edu.uiowa.physics.pw.das.event.MouseBoxEvent;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class DumpToFileMouseModule
extends MouseModule {
    DasAxis xAxis;
    DasAxis yAxis;
    DataSetConsumer dsConsumer;

    public DumpToFileMouseModule(DasCanvasComponent parent, DataSetConsumer dsConsumer, DasAxis xAxis, DasAxis yAxis) {
        super(parent, new BoxRenderer(parent), "Dump to File");
        if (!xAxis.isHorizontal()) {
            throw new IllegalArgumentException("X Axis orientation is not horizontal");
        }
        if (yAxis.isHorizontal()) {
            throw new IllegalArgumentException("Y Axis orientation is not vertical");
        }
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.dsConsumer = dsConsumer;
    }

    public static DumpToFileMouseModule create(DasPlot parent, DataSetConsumer dsConsumer) {
        DumpToFileMouseModule result = new DumpToFileMouseModule(parent, dsConsumer, parent.getXAxis(), parent.getYAxis());
        return result;
    }

    public void mouseRangeSelected(MouseDragEvent e0) {
        DataSet outds;
        MouseBoxEvent e = (MouseBoxEvent)e0;
        DatumRange xrange = new DatumRange(this.xAxis.invTransform(e.getXMinimum()), this.xAxis.invTransform(e.getXMaximum()));
        DatumRange yrange = new DatumRange(this.yAxis.invTransform(e.getYMaximum()), this.yAxis.invTransform(e.getYMinimum()));
        DataSet ds = this.dsConsumer.getDataSet();
        if (ds instanceof TableDataSet) {
            TableDataSet tds = (TableDataSet)ds;
            outds = new ClippedTableDataSet(tds, xrange, yrange);
        } else {
            VectorDataSet vds = (VectorDataSet)ds;
            VectorDataSetBuilder builder = new VectorDataSetBuilder(vds.getXUnits(), vds.getYUnits());
            for (int i = 0; i < vds.getXLength(); ++i) {
                if (!(yrange.contains(vds.getDatum(i)) & xrange.contains(vds.getXTagDatum(i)))) continue;
                builder.insertY(vds.getXTagDouble(i, vds.getXUnits()), vds.getDouble(i, vds.getYUnits()));
            }
            outds = builder.toVectorDataSet();
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.toString().matches(".*\\.das2Stream");
            }

            public String getDescription() {
                return "*.das2Stream";
            }
        });
        int result = chooser.showSaveDialog(this.parent);
        if (result == 0) {
            File selected = chooser.getSelectedFile();
            try {
                FileChannel out = new FileOutputStream(selected).getChannel();
                if (outds instanceof TableDataSet) {
                    TableUtil.dumpToAsciiStream((TableDataSet)outds, out);
                } else if (outds instanceof VectorDataSet) {
                    VectorUtil.dumpToAsciiStream((VectorDataSet)outds, out);
                }
            }
            catch (IOException ioe) {
                DasExceptionHandler.handle(ioe);
            }
        }
    }

    public DumpToFileMouseModule() {
    }
}

