/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.event.BoxRenderer;
import edu.uiowa.physics.pw.das.event.DragRenderer;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.MousePointSelectionEvent;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class DasMouseInputAdapter
extends MouseInputAdapter
implements Editable {
    private MouseModule primary = null;
    private MouseModule secondary = null;
    private MouseModule tertiary = null;
    private Vector active = null;
    private Vector modules;
    private HashMap primaryActionButtonMap;
    private HashMap secondaryActionButtonMap;
    protected JPopupMenu primaryPopup;
    protected JPopupMenu secondaryPopup;
    private Point primaryPopupLocation;
    private Point secondaryPopupLocation;
    private JPanel pngFileNamePanel;
    private JTextField pngFileTextField;
    private JFileChooser pngFileChooser;
    JCheckBoxMenuItem primarySelectedItem;
    JCheckBoxMenuItem secondarySelectedItem;
    int numInserted;
    protected ActionListener popupListener;
    protected DasCanvasComponent parent = null;
    private Point selectionStart;
    private Point selectionEnd;
    private Point dSelectionStart;
    private Point dSelectionEnd;
    private Graphics2D graphics;
    private MousePointSelectionEvent mousePointSelection;
    private int xOffset;
    private int yOffset;
    private int button = 0;
    private MouseMode mouseMode = MouseMode.idle;
    private DragRenderer resizeRenderer = null;
    private Point resizeStart = null;
    Vector hotSpots = null;
    Rectangle dirtyBounds = null;

    public DasMouseInputAdapter(DasCanvasComponent parent) {
        this.parent = parent;
        this.modules = new Vector();
        this.primaryActionButtonMap = new HashMap();
        this.secondaryActionButtonMap = new HashMap();
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            this.primaryPopup = this.createPopup();
            this.secondaryPopup = this.createPopup();
        }
        this.active = null;
        this.mousePointSelection = new MousePointSelectionEvent(this, 0, 0);
        this.resizeRenderer = new BoxRenderer(parent);
        this.numInserted = 0;
    }

    public void replaceMouseModule(MouseModule oldModule, MouseModule newModule) {
        JCheckBoxMenuItem j = (JCheckBoxMenuItem)this.primaryActionButtonMap.get(oldModule);
        this.primaryActionButtonMap.put(newModule, j);
        this.primaryActionButtonMap.remove(oldModule);
        this.secondaryActionButtonMap.put(newModule, this.secondaryActionButtonMap.get(oldModule));
        this.secondaryActionButtonMap.remove(oldModule);
        this.modules.removeElement(oldModule);
        this.modules.addElement(newModule);
    }

    public void addMouseModule(MouseModule module) {
        if (DasApplication.getDefaultApplication().isHeadless()) {
            DasApplication.getDefaultApplication().getLogger().fine("not adding module since headless is true");
        } else {
            MouseModule preExisting = this.getModuleByLabel(module.getLabel());
            if (preExisting != null) {
                DasDie.println(DasDie.INFORM, "Replacing mouse module " + module.getLabel() + ".");
                this.replaceMouseModule(preExisting, module);
            } else {
                this.modules.add(module);
                String name = module.getLabel();
                JCheckBoxMenuItem primaryNewItem = new JCheckBoxMenuItem(name);
                JCheckBoxMenuItem secondaryNewItem = new JCheckBoxMenuItem(name);
                primaryNewItem.addActionListener(this.popupListener);
                primaryNewItem.setActionCommand("primary");
                secondaryNewItem.addActionListener(this.popupListener);
                secondaryNewItem.setActionCommand("secondary");
                this.primaryActionButtonMap.put(module, primaryNewItem);
                this.secondaryActionButtonMap.put(module, secondaryNewItem);
                this.primaryPopup.add((Component)primaryNewItem, this.primaryActionButtonMap.size() - 1);
                this.secondaryPopup.add((Component)secondaryNewItem, this.secondaryActionButtonMap.size() - 1);
            }
        }
    }

    public KeyAdapter getKeyAdapter() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent ev) {
                if (ev.getKeyCode() == 27 & DasMouseInputAdapter.this.active != null) {
                    DasMouseInputAdapter.this.clearSelection(DasMouseInputAdapter.this.graphics);
                    DasMouseInputAdapter.this.active = null;
                }
            }
        };
    }

    public void setPrimaryModule(MouseModule module) {
        Iterator i = this.primaryActionButtonMap.entrySet().iterator();
        while (i.hasNext()) {
            try {
                Object ii = i.next().getValue();
                ((JCheckBoxMenuItem)ii).setSelected(false);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }
        JCheckBoxMenuItem j = (JCheckBoxMenuItem)this.primaryActionButtonMap.get(module);
        if (j != null) {
            j.setSelected(true);
        }
        this.primarySelectedItem = j;
        this.primary = module;
        this.parent.setCursor(this.primary.getCursor());
    }

    public void setSecondaryModule(MouseModule module) {
        Iterator i = this.secondaryActionButtonMap.entrySet().iterator();
        while (i.hasNext()) {
            try {
                Object ii = i.next().getValue();
                ((JCheckBoxMenuItem)ii).setSelected(false);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }
        JCheckBoxMenuItem j = (JCheckBoxMenuItem)this.secondaryActionButtonMap.get(module);
        if (j != null) {
            j.setSelected(true);
        }
        this.secondarySelectedItem = j;
        this.secondary = module;
    }

    public void setTertiaryModule(MouseModule module) {
        this.tertiary = module;
    }

    private JPopupMenu createPopup() {
        JPopupMenu popup = new JPopupMenu();
        this.popupListener = this.createPopupMenuListener();
        Action[] componentActions = this.parent.getActions();
        for (int iaction = 0; iaction < componentActions.length; ++iaction) {
            JMenuItem item = new JMenuItem();
            item.setAction(componentActions[iaction]);
            popup.add(item);
        }
        popup.addSeparator();
        Action[] canvasActions = DasCanvas.getActions();
        for (int iaction = 0; iaction < canvasActions.length; ++iaction) {
            JMenuItem item = new JMenuItem();
            item.setAction(canvasActions[iaction]);
            popup.add(item);
        }
        popup.addSeparator();
        return popup;
    }

    private ActionListener createPopupMenuListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DasMouseInputAdapter outer = DasMouseInputAdapter.this;
                String command = e.getActionCommand();
                if (command.equals("properties")) {
                    DasMouseInputAdapter.this.parent.showProperties();
                } else if (command.equals("print")) {
                    Printable p = ((DasCanvas)DasMouseInputAdapter.this.parent.getParent()).getPrintable();
                    PrinterJob pj = PrinterJob.getPrinterJob();
                    pj.setPrintable(p);
                    if (pj.printDialog()) {
                        try {
                            pj.print();
                        }
                        catch (PrinterException pe) {
                            Object[] message = new Object[]{"Error printing", pe.getMessage()};
                            JOptionPane.showMessageDialog(null, message, "ERROR", 0);
                        }
                    }
                } else if (command.equals("toPng")) {
                    if (DasMouseInputAdapter.this.pngFileNamePanel == null) {
                        DasMouseInputAdapter.this.pngFileNamePanel = new JPanel();
                        DasMouseInputAdapter.this.pngFileNamePanel.setLayout(new BoxLayout(DasMouseInputAdapter.this.pngFileNamePanel, 0));
                        DasMouseInputAdapter.this.pngFileTextField = new JTextField(32);
                        DasMouseInputAdapter.this.pngFileTextField.setMaximumSize(DasMouseInputAdapter.this.pngFileTextField.getPreferredSize());
                        DasMouseInputAdapter.this.pngFileChooser = new JFileChooser();
                        DasMouseInputAdapter.this.pngFileChooser.setApproveButtonText("Select File");
                        DasMouseInputAdapter.this.pngFileChooser.setDialogTitle("Write to PNG");
                        JButton b = new JButton("Browse");
                        b.setActionCommand("pngBrowse");
                        b.addActionListener(this);
                        DasMouseInputAdapter.this.pngFileNamePanel.add(DasMouseInputAdapter.this.pngFileTextField);
                        DasMouseInputAdapter.this.pngFileNamePanel.add(b);
                    }
                    DasMouseInputAdapter.this.pngFileTextField.setText(DasMouseInputAdapter.this.pngFileChooser.getCurrentDirectory().getPath());
                    Object[] options = new String[]{"Write to PNG", "Cancel"};
                    int choice = JOptionPane.showOptionDialog(DasMouseInputAdapter.this.parent, DasMouseInputAdapter.this.pngFileNamePanel, "Write to PNG", 0, 3, null, options, "Ok");
                    if (choice == 0) {
                        DasCanvas canvas = (DasCanvas)DasMouseInputAdapter.this.parent.getParent();
                        try {
                            canvas.writeToPng(DasMouseInputAdapter.this.pngFileTextField.getText());
                        }
                        catch (IOException ioe) {
                            DasExceptionHandler.handle(ioe);
                        }
                    }
                } else if (command.equals("pngBrowse")) {
                    int choice = DasMouseInputAdapter.this.pngFileChooser.showDialog(DasMouseInputAdapter.this.parent, "Select File");
                    if (choice == 0) {
                        DasMouseInputAdapter.this.pngFileTextField.setText(DasMouseInputAdapter.this.pngFileChooser.getSelectedFile().getPath());
                    }
                } else if (!command.equals("close")) {
                    if (command.equals("primary")) {
                        if (DasMouseInputAdapter.this.primarySelectedItem != null) {
                            DasMouseInputAdapter.this.primarySelectedItem.setSelected(false);
                        }
                        for (int i = 0; i < DasMouseInputAdapter.this.modules.size(); ++i) {
                            JCheckBoxMenuItem j = (JCheckBoxMenuItem)DasMouseInputAdapter.this.primaryActionButtonMap.get(DasMouseInputAdapter.this.modules.get(i));
                            if (!j.isSelected()) continue;
                            DasMouseInputAdapter.this.primarySelectedItem = j;
                            break;
                        }
                        DasMouseInputAdapter.this.primarySelectedItem.setSelected(true);
                    } else if (command.equals("secondary")) {
                        if (DasMouseInputAdapter.this.secondarySelectedItem != null) {
                            DasMouseInputAdapter.this.secondarySelectedItem.setSelected(false);
                        }
                        Point l = DasMouseInputAdapter.this.secondaryPopupLocation;
                        for (int i = 0; i < DasMouseInputAdapter.this.modules.size(); ++i) {
                            JCheckBoxMenuItem j = (JCheckBoxMenuItem)DasMouseInputAdapter.this.secondaryActionButtonMap.get(DasMouseInputAdapter.this.modules.get(i));
                            if (!j.isSelected()) continue;
                            DasMouseInputAdapter.this.secondarySelectedItem = j;
                            break;
                        }
                    } else {
                        DasDie.println("" + command);
                    }
                }
            }
        };
    }

    public void renderSelection(Graphics2D g) {
        for (int i = 0; i < this.active.size(); ++i) {
            DasCanvas canvas = this.parent.getCanvas();
            this.selectionStart = SwingUtilities.convertPoint(canvas, this.dSelectionStart, this.parent);
            this.selectionEnd = SwingUtilities.convertPoint(canvas, this.dSelectionEnd, this.parent);
            ((MouseModule)this.active.get((int)i)).dragRenderer.renderDrag(g, this.selectionStart, this.selectionEnd);
        }
    }

    public void clearSelection(Graphics2D g) {
        if (this.active == null) {
            return;
        }
        for (int i = 0; i < this.active.size(); ++i) {
            ((MouseModule)this.active.get((int)i)).dragRenderer.clear(g);
        }
    }

    private MouseMode activateMouseMode(MouseEvent e) {
        boolean xLeftSide = false;
        boolean xRightSide = false;
        boolean yTopSide = false;
        boolean yBottomSide = false;
        if (this.parent.getRow() != DasRow.NULL && this.parent.getColumn() != DasColumn.NULL) {
            int xLeft = this.parent.getColumn().getDMinimum() - this.xOffset;
            int xRight = this.parent.getColumn().getDMaximum() - this.xOffset;
            int yTop = this.parent.getRow().getDMinimum() - this.yOffset;
            int yBottom = this.parent.getRow().getDMaximum() - this.yOffset;
            xLeftSide = e.getX() < xLeft + 5;
            xRightSide = e.getX() > xRight - 5;
            yTopSide = e.getY() < yTop + 5 && e.getY() >= yTop;
            yBottomSide = e.getY() > yBottom - 5;
        }
        MouseMode result = MouseMode.idle;
        Cursor cursor = new Cursor(0);
        if (!(this.parent instanceof DasAxis)) {
            if (xLeftSide) {
                if (yTopSide) {
                    result = MouseMode.resize;
                    cursor = new Cursor(6);
                } else if (yBottomSide) {
                    result = MouseMode.resize;
                    cursor = new Cursor(4);
                }
            } else if (xRightSide) {
                if (yTopSide) {
                    result = MouseMode.resize;
                    cursor = new Cursor(7);
                } else if (yBottomSide) {
                    result = MouseMode.resize;
                    cursor = new Cursor(5);
                }
            }
        }
        Shape hotSpotShape = null;
        if (this.hotSpots != null) {
            Vector v = this.hotSpots;
            for (int i = 0; i < v.size(); ++i) {
                Shape s = (Shape)v.get(i);
                if (!s.contains(e.getX(), e.getY())) continue;
                cursor = new Cursor(12);
                result = MouseMode.hotSpot;
                hotSpotShape = s;
            }
        }
        if (result == MouseMode.resize) {
            result.resizeBottom = yBottomSide;
            result.resizeTop = yTopSide;
            result.resizeRight = xRightSide;
            result.resizeLeft = xLeftSide;
        }
        if (result != this.mouseMode) {
            this.getGlassPane().setCursor(cursor);
            if (this.mouseMode == MouseMode.hotSpot && result != MouseMode.hotSpot) {
                this.parent.repaint(this.dirtyBounds);
                this.dirtyBounds = null;
            } else if (result == MouseMode.hotSpot && this.mouseMode != MouseMode.hotSpot) {
                Graphics2D g = (Graphics2D)this.parent.getGraphics();
                g.setColor(new Color(0, 200, 255, 50));
                g.fill(hotSpotShape);
                this.dirtyBounds = hotSpotShape.getBounds();
            }
        }
        return result;
    }

    public void mouseMoved(MouseEvent e) {
        Point l = this.parent.getLocation();
        this.xOffset = l.x;
        this.yOffset = l.y;
        MouseMode m = this.activateMouseMode(e);
        this.mouseMode = m != null ? m : MouseMode.idle;
    }

    private void showPopup(JPopupMenu menu, Point p) {
        HashMap map = null;
        if (menu == this.primaryPopup) {
            map = this.primaryActionButtonMap;
        } else if (menu == this.secondaryPopup) {
            map = this.secondaryActionButtonMap;
        } else {
            throw new IllegalArgumentException("menu must be primary or secondary popup menu");
        }
        Iterator i = this.modules.iterator();
        while (i.hasNext()) {
            MouseModule mm = (MouseModule)i.next();
            JCheckBoxMenuItem j = (JCheckBoxMenuItem)this.primaryActionButtonMap.get(mm);
            j.setText(mm.getLabel());
        }
        menu.show(this.parent, p.x, p.y);
    }

    public void mousePressed(MouseEvent e) {
        block18: {
            block16: {
                block17: {
                    Point l = this.parent.getLocation();
                    this.parent.requestFocus();
                    this.xOffset = l.x;
                    this.yOffset = l.y;
                    if (this.mouseMode != MouseMode.resize) break block16;
                    this.resizeStart = new Point(0, 0);
                    this.graphics = (Graphics2D)this.getGlassPane().getGraphics();
                    this.graphics.translate(this.parent.getX(), this.parent.getY());
                    if (this.mouseMode.resizeRight) {
                        this.resizeStart.x = 0;
                    } else if (this.mouseMode.resizeLeft) {
                        this.resizeStart.x = this.parent.getWidth();
                    }
                    if (!this.mouseMode.resizeTop) break block17;
                    this.resizeStart.y = this.parent.getHeight();
                    break block18;
                }
                if (!this.mouseMode.resizeBottom) break block18;
                this.resizeStart.y = 0;
                break block18;
            }
            if (this.mouseMode == MouseMode.hotSpot) {
                Vector v = this.hotSpots;
                for (int i = 0; i < v.size(); ++i) {
                    if (!((Shape)v.get(i)).contains(e.getX(), e.getY())) continue;
                    this.primary.hotSpotPressed((Shape)v.get(i));
                }
            } else if (this.active == null) {
                this.button = e.getButton();
                this.selectionStart = e.getPoint();
                this.dSelectionStart = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.parent.getCanvas());
                this.selectionEnd = e.getPoint();
                this.dSelectionEnd = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.parent.getCanvas());
                this.graphics = (Graphics2D)this.parent.getGraphics();
                if (e.isControlDown() || this.button == 3) {
                    if (this.button == 1 || this.button == 3) {
                        this.showPopup(this.primaryPopup, e.getPoint());
                    } else {
                        this.showPopup(this.secondaryPopup, e.getPoint());
                    }
                } else {
                    Object j;
                    int i;
                    this.active = new Vector();
                    if (this.button == 1 || this.button == 3) {
                        for (i = 0; i < this.modules.size(); ++i) {
                            j = (JCheckBoxMenuItem)this.primaryActionButtonMap.get(this.modules.get(i));
                            if (!((AbstractButton)j).isSelected()) continue;
                            this.active.add(this.modules.get(i));
                        }
                    } else {
                        for (i = 0; i < this.modules.size(); ++i) {
                            j = (JCheckBoxMenuItem)this.secondaryActionButtonMap.get(this.modules.get(i));
                            if (!((AbstractButton)j).isSelected()) continue;
                            this.active.add(this.modules.get(i));
                        }
                    }
                    this.mouseMode = MouseMode.moduleDrag;
                    this.mousePointSelection.set(e.getX() + this.xOffset, e.getY() + this.yOffset);
                    for (i = 0; i < this.active.size(); ++i) {
                        j = (MouseModule)this.active.get(i);
                        ((MouseModule)j).mousePressed(e);
                        if (!((MouseModule)j).dragRenderer.isPointSelection()) continue;
                        this.mouseDragged(e);
                    }
                }
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.mouseMode == MouseMode.resize) {
            this.resizeRenderer.clear(this.graphics);
            this.resizeRenderer.renderDrag(this.graphics, this.resizeStart, e.getPoint());
        } else if (this.active != null) {
            this.clearSelection(this.graphics);
            this.selectionEnd = e.getPoint();
            this.dSelectionEnd = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.parent.getCanvas());
            this.renderSelection(this.graphics);
            this.mousePointSelection.set((int)this.dSelectionEnd.getX(), (int)this.dSelectionEnd.getY());
            for (int i = 0; i < this.active.size(); ++i) {
                MouseModule j = (MouseModule)this.active.get(i);
                if (j.dragRenderer.isPointSelection()) {
                    j.mousePointSelected(this.mousePointSelection);
                }
                if (j.dragRenderer.isUpdatingDragSelection()) {
                    MouseDragEvent de = j.dragRenderer.getMouseDragEvent(this.parent, this.dSelectionStart, this.dSelectionEnd, e.isShiftDown());
                    j.mouseRangeSelected(de);
                }
                j.mouseDragged(e);
            }
        }
    }

    private void performResize(MouseEvent e) {
        DasCanvas canvas = (DasCanvas)this.parent.getParent();
        int dxLeft = this.parent.getColumn().getDMinimum();
        int dxRight = this.parent.getColumn().getDMaximum();
        int dyTop = this.parent.getRow().getDMinimum();
        int dyBottom = this.parent.getRow().getDMaximum();
        int dx = e.getX() + this.xOffset;
        int dy = e.getY() + this.yOffset;
        if (this.mouseMode.resizeRight) {
            dxRight = dx;
        } else if (this.mouseMode.resizeLeft) {
            dxLeft = dx;
        }
        if (this.mouseMode.resizeTop) {
            dyTop = dy;
        } else if (this.mouseMode.resizeBottom) {
            dyBottom = dy;
        }
        this.parent.getColumn().setDPosition(dxLeft, dxRight);
        this.parent.getRow().setDPosition(dyTop, dyBottom);
        this.parent.resize();
        this.getGlassPane().setCursor(new Cursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent e) {
        if (this.mouseMode == MouseMode.resize) {
            this.performResize(e);
        } else if (e.getButton() == this.button && this.active != null) {
            this.clearSelection(this.graphics);
            int x = e.getX();
            int y = e.getY();
            for (int i = 0; i < this.active.size(); ++i) {
                MouseModule j = (MouseModule)this.active.get(i);
                try {
                    MouseDragEvent de = j.dragRenderer.getMouseDragEvent(this.parent, this.dSelectionStart, this.dSelectionEnd, e.isShiftDown());
                    j.mouseRangeSelected(de);
                    continue;
                }
                finally {
                    this.button = 0;
                    j.mouseReleased(e);
                }
            }
            this.active = null;
        }
    }

    public void removeMouseModule(MouseModule module) {
    }

    public MouseModule getMouseModule(int i) {
        return (MouseModule)this.modules.get(i);
    }

    public MouseModule[] getMouseModules() {
        Object[] result = new MouseModule[this.modules.size()];
        this.modules.copyInto(result);
        return result;
    }

    public void setMouseModule(int i, MouseModule mouseModule2) {
        this.modules.set(i, mouseModule2);
    }

    public void mouseEntered(MouseEvent e) {
        if (this.primary != null) {
            this.hotSpots = this.primary.getHotSpots();
            this.getGlassPane().setCursor(this.primary.getCursor());
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.mouseMode == MouseMode.hotSpot) {
            this.parent.repaint(this.dirtyBounds);
            this.mouseMode = MouseMode.idle;
        }
        this.getGlassPane().setCursor(Cursor.getDefaultCursor());
    }

    public void addMenuItem(Component b) {
        if (this.numInserted == 0) {
            this.primaryPopup.insert(new JPopupMenu.Separator(), 0);
        }
        this.primaryPopup.insert(b, this.numInserted);
        ++this.numInserted;
    }

    public Component getGlassPane() {
        return ((DasCanvas)this.parent.getParent()).getGlassPane();
    }

    public MouseModule getModuleByLabel(String label) {
        MouseModule result = null;
        for (int i = 0; i < this.modules.size(); ++i) {
            if (!label.equals(((MouseModule)this.modules.get(i)).getLabel())) continue;
            result = (MouseModule)this.modules.get(i);
        }
        return result;
    }

    private static class MouseMode {
        String s;
        boolean resizeTop = false;
        boolean resizeBottom = false;
        boolean resizeRight = false;
        boolean resizeLeft = false;
        static MouseMode idle = new MouseMode("idle");
        static MouseMode resize = new MouseMode("resize");
        static MouseMode moduleDrag = new MouseMode("moduleDrag");
        static MouseMode hotSpot = new MouseMode("hotSpot");

        MouseMode(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }
    }
}

