/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.event.DragRenderer;
import edu.uiowa.physics.pw.das.event.MouseBoxEvent;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class BoxRenderer
implements DragRenderer {
    boolean xRangeSelection;
    boolean yRangeSelection;
    Rectangle dirtyBounds;
    DasCanvasComponent parent;

    public BoxRenderer(DasCanvasComponent parent) {
        this.parent = parent;
        this.dirtyBounds = new Rectangle();
        this.xRangeSelection = true;
        this.yRangeSelection = true;
    }

    public void clear(Graphics g) {
        this.parent.paintImmediately(this.dirtyBounds);
    }

    public void renderDrag(Graphics g1, Point p1, Point p2) {
        Graphics2D g = (Graphics2D)g1;
        Rectangle r = new Rectangle(p1);
        r.add(p2);
        Color color0 = g.getColor();
        g.setColor(new Color(255, 255, 255, 100));
        g.setStroke(new BasicStroke(3.0f, 1, 1));
        g.drawRect(r.x, r.y, r.width, r.height);
        g.setStroke(new BasicStroke());
        g.setColor(color0);
        g.drawRect(r.x, r.y, r.width, r.height);
        this.dirtyBounds.setLocation(r.x - 2, r.y - 3);
        this.dirtyBounds.add(r.x + r.width + 2, r.y + r.height + 3);
    }

    public MouseDragEvent getMouseDragEvent(Object source, Point p1, Point p2, boolean isModified) {
        return new MouseBoxEvent(source, p1, p2, isModified);
    }

    public boolean isPointSelection() {
        return false;
    }

    public boolean isXRangeSelection() {
        return this.xRangeSelection;
    }

    public boolean isYRangeSelection() {
        return this.yRangeSelection;
    }

    public boolean isUpdatingDragSelection() {
        return false;
    }
}

