/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.dataset.DataSetConsumer;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.event.BoxGesturesRenderer;
import edu.uiowa.physics.pw.das.event.BoxSelectionEvent;
import edu.uiowa.physics.pw.das.event.BoxSelectionListener;
import edu.uiowa.physics.pw.das.event.MouseBoxEvent;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import javax.swing.event.EventListenerList;

public class BoxRangeSelectorMouseModule
extends MouseModule {
    private DasAxis xAxis;
    private DasAxis yAxis;
    private DataSetConsumer consumer;
    private EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$event$BoxSelectionListener;

    public BoxRangeSelectorMouseModule(DasCanvasComponent parent, DataSetConsumer consumer, DasAxis xAxis, DasAxis yAxis) {
        super(parent, new BoxGesturesRenderer(parent), "Box Selection");
        if (!xAxis.isHorizontal()) {
            throw new IllegalArgumentException("X Axis orientation is not horizontal");
        }
        if (yAxis.isHorizontal()) {
            throw new IllegalArgumentException("Y Axis orientation is not vertical");
        }
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.consumer = consumer;
    }

    public static BoxRangeSelectorMouseModule create(DasPlot parent) {
        BoxRangeSelectorMouseModule result = new BoxRangeSelectorMouseModule(parent, null, parent.getXAxis(), parent.getYAxis());
        return result;
    }

    public void mouseRangeSelected(MouseDragEvent e0) {
        if (e0 instanceof MouseBoxEvent) {
            MouseBoxEvent e = (MouseBoxEvent)e0;
            Datum xMin = this.xAxis.invTransform(e.getXMinimum());
            Datum xMax = this.xAxis.invTransform(e.getXMaximum());
            Datum yMin = this.yAxis.invTransform(e.getYMinimum());
            Datum yMax = this.yAxis.invTransform(e.getYMaximum());
            BoxSelectionEvent evt = new BoxSelectionEvent(this, xMin, xMax, yMin, yMax);
            if (this.consumer != null) {
                evt.setDataSet(this.consumer.getDataSet());
            }
            this.fireBoxSelected(evt);
        }
    }

    public void addBoxSelectionListener(BoxSelectionListener listener) {
        this.listenerList.add(class$edu$uiowa$physics$pw$das$event$BoxSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$BoxSelectionListener = BoxRangeSelectorMouseModule.class$("edu.uiowa.physics.pw.das.event.BoxSelectionListener")) : class$edu$uiowa$physics$pw$das$event$BoxSelectionListener, listener);
    }

    public void removeBoxSelectionListener(BoxSelectionListener listener) {
        this.listenerList.remove(class$edu$uiowa$physics$pw$das$event$BoxSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$BoxSelectionListener = BoxRangeSelectorMouseModule.class$("edu.uiowa.physics.pw.das.event.BoxSelectionListener")) : class$edu$uiowa$physics$pw$das$event$BoxSelectionListener, listener);
    }

    protected void fireBoxSelected(BoxSelectionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$edu$uiowa$physics$pw$das$event$BoxSelectionListener == null ? BoxRangeSelectorMouseModule.class$("edu.uiowa.physics.pw.das.event.BoxSelectionListener") : class$edu$uiowa$physics$pw$das$event$BoxSelectionListener)) continue;
            ((BoxSelectionListener)listeners[i + 1]).BoxSelected(event);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

