/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.MonthDatumRange;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.format.TimeDatumFormatter;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DatumRangeUtil {
    private static final int DATEFORMAT_USA = 1;
    private static final int DATEFORMAT_EUROPE = 0;
    private static final int DATEFORMAT_YYYY_DDD = 2;
    private static final boolean DEBUG = false;
    private static Pattern yyyymmddPattern = Pattern.compile("((\\d{4})(\\d{2})(\\d{2}))( |T|-)");

    private static boolean isYear(String string) {
        return string.length() == 4 && Pattern.matches("\\d{4}", string);
    }

    private static boolean isDayOfYear(String string) {
        return string.length() == 3 && Pattern.matches("\\d{3}", string);
    }

    private static int monthNumber(String string) throws ParseException {
        if (Pattern.matches("\\d+", string)) {
            return DatumRangeUtil.parseInt(string);
        }
        int month = DatumRangeUtil.monthNameNumber(string);
        if (month == -1) {
            throw new ParseException("hoping for month at, got " + string, 0);
        }
        return month;
    }

    private static int monthNameNumber(String string) {
        if (string.length() < 3) {
            return -1;
        }
        String[] monthNames = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
        string = string.substring(0, 3).toLowerCase();
        int r = -1;
        for (int i = 0; i < monthNames.length; ++i) {
            if (!string.equals(monthNames[i])) continue;
            r = i;
        }
        if (r == -1) {
            return -1;
        }
        return r + 1;
    }

    private static int y2k(String syear) throws ParseException {
        int year = DatumRangeUtil.parseInt(syear);
        if (year > 100) {
            return year;
        }
        if (year < 70) {
            return 2000 + year;
        }
        return 1900 + year;
    }

    private int stregex(String string, String regex) {
        Matcher matcher = Pattern.compile(regex).matcher(string);
        if (matcher.find()) {
            return matcher.start();
        }
        return -1;
    }

    private static void caldat(int julday, DateDescriptor dateDescriptor) {
        int jalpha = (int)(((double)(julday - 1867216) - 0.25) / 36524.25);
        int j1 = julday + 1 + jalpha - jalpha / 4;
        int j2 = j1 + 1524;
        int j3 = 6680 + (int)(((double)(j2 - 2439870) - 122.1) / 365.25);
        int j4 = 365 * j3 + j3 / 4;
        int j5 = (int)((double)(j2 - j4) / 30.6001);
        int day = j2 - j4 - (int)(30.6001 * (double)j5);
        int month = j5 - 1;
        month = (month - 1) % 12 + 1;
        int year = j3 - 4715;
        dateDescriptor.day = "" + day;
        dateDescriptor.month = "" + month;
        dateDescriptor.year = "" + (year -= (year -= month > 2 ? 1 : 0) <= 0 ? 1 : 0);
    }

    private static int julday(int month, int day, int year) {
        int jd = 367 * year - 7 * (year + (month + 9) / 12) / 4 - 3 * ((year + (month - 9) / 7) / 100 + 1) / 4 + 275 * month / 9 + day + 1721029;
        return jd;
    }

    private static void printGroups(Matcher matcher) {
        for (int i = 0; i <= matcher.groupCount(); ++i) {
            System.out.println(" " + i + ": " + matcher.group(i));
        }
        System.out.println(" ");
    }

    private static boolean tryPattern(Pattern regex, String string, int[] groups, DateDescriptor dateDescriptor) throws ParseException {
        Matcher matcher = regex.matcher(string.toLowerCase());
        if (matcher.find() && matcher.start() == 0) {
            int posDate = matcher.start();
            int length = matcher.end() - matcher.start();
            dateDescriptor.date = string.substring(posDate, posDate + length);
            dateDescriptor.day = matcher.group(groups[2]);
            dateDescriptor.month = matcher.group(groups[1]);
            dateDescriptor.year = matcher.group(groups[0]);
            return true;
        }
        return false;
    }

    public static boolean isDate(String string, DateDescriptor dateDescriptor) throws ParseException {
        int[] groups;
        String euroDateRegex;
        if (string.length() < 6) {
            return false;
        }
        String yearRegex = "(\\d{2}(\\d{2})?)( |t|-)";
        if (DatumRangeUtil.tryPattern(yyyymmddPattern, string, new int[]{2, 3, 4}, dateDescriptor)) {
            dateDescriptor.dateformat = 1;
            return true;
        }
        String delims = "(/|\\.|-| )";
        Matcher matcher = Pattern.compile(delims).matcher(string);
        if (!matcher.find()) {
            return false;
        }
        int posDelim = matcher.start();
        String delim = string.substring(matcher.start(), matcher.end());
        String monthNameRegex = "(jan[a-z]*|feb[a-z]*|mar[a-z]*|apr[a-z]*|may|june?|july?|aug[a-z]*|sep[a-z]*|oct[a-z]*|nov[a-z]*|dec[a-z]*)";
        String monthRegex = "((\\d?\\d)|" + monthNameRegex + ")";
        String dayRegex = "(\\d?\\d)";
        if (delim.equals(".")) {
            euroDateRegex = "(" + dayRegex + "\\." + monthRegex + "\\." + yearRegex + ")";
            groups = new int[]{6, 3, 2};
        } else {
            euroDateRegex = "(" + dayRegex + delim + monthNameRegex + delim + yearRegex + ")";
            groups = new int[]{4, 3, 2};
        }
        if (DatumRangeUtil.tryPattern(Pattern.compile(euroDateRegex), string, groups, dateDescriptor)) {
            dateDescriptor.dateformat = 0;
            return true;
        }
        String usaDateRegex = monthRegex + delim + dayRegex + delim + yearRegex;
        if (DatumRangeUtil.tryPattern(Pattern.compile(usaDateRegex), string, new int[]{5, 1, 4}, dateDescriptor)) {
            dateDescriptor.dateformat = 1;
            return true;
        }
        String lastDateRegex = "(\\d{4})" + delim + monthRegex + delim + dayRegex + "( |t|-)";
        if (DatumRangeUtil.tryPattern(Pattern.compile(lastDateRegex), string, new int[]{1, 2, 5}, dateDescriptor)) {
            dateDescriptor.dateformat = 1;
            return true;
        }
        String doyRegex = "(\\d{3})";
        String dateRegex = doyRegex + "(-|/)" + yearRegex + "( |t|-)";
        if (DatumRangeUtil.tryPattern(Pattern.compile(dateRegex), string, new int[]{3, 1, 1}, dateDescriptor)) {
            int doy = DatumRangeUtil.parseInt(dateDescriptor.day);
            if (doy > 366) {
                return false;
            }
            int year = DatumRangeUtil.parseInt(dateDescriptor.year);
            DatumRangeUtil.caldat(DatumRangeUtil.julday(12, 31, year - 1) + doy, dateDescriptor);
            dateDescriptor.dateformat = 2;
            return true;
        }
        return false;
    }

    private static int parseInt(String s) throws ParseException {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new ParseException("failed attempt to parse int in " + s, 0);
        }
    }

    public static DatumRange parseTimeRange(String string_in) throws ParseException {
        int i;
        String string = string_in + " ";
        String delimRegEx = " |-|/|\\.|:|to|through|T|Z";
        int[] ts1 = new int[]{-1, -1, -1, -1, -1, -1, -1};
        int[] ts2 = new int[]{-1, -1, -1, -1, -1, -1, -1};
        int[] ts = null;
        ArrayList<String> beforeToUnresolved = new ArrayList<String>();
        ArrayList<String> afterToUnresolved = new ArrayList<String>();
        String[] formatCodes = new String[]{"%y", "%m", "%d", "%H", "%M", "%S", ""};
        String[] digitIdentifiers = new String[]{"YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "NANO"};
        boolean YEAR = false;
        boolean MONTH = true;
        int DAY = 2;
        int HOUR = 3;
        int MINUTE = 4;
        int SECOND = 5;
        int NANO = 6;
        int STATE_OPEN = 89;
        int STATE_TS1TIME = 90;
        int STATE_TS2TIME = 90;
        int state = 89;
        int ipos = 0;
        String delim = "";
        String format = "";
        boolean beforeTo = true;
        DateDescriptor dateDescriptor = new DateDescriptor();
        int dateFormat = 1;
        while (ipos < string.length()) {
            boolean isWithinTime;
            String token;
            int month;
            String lastdelim = delim;
            format = format + lastdelim;
            if (lastdelim.equals("to")) {
                beforeTo = false;
            }
            if (lastdelim.equals("through")) {
                beforeTo = false;
            }
            if (lastdelim.equals("-")) {
                beforeTo = false;
            }
            if (DatumRangeUtil.isDate(string.substring(ipos), dateDescriptor)) {
                format = format + "%x";
                if (ts1[2] != -1 || ts1[1] != -1 || ts1[0] != -1) {
                    beforeTo = false;
                }
                month = DatumRangeUtil.monthNumber(dateDescriptor.month);
                int year = DatumRangeUtil.y2k(dateDescriptor.year);
                int day = DatumRangeUtil.parseInt(dateDescriptor.day);
                if (beforeTo) {
                    ts1[2] = day;
                    ts1[1] = month;
                    ts1[0] = year;
                } else {
                    ts2[2] = day;
                    ts2[1] = month;
                    ts2[0] = year;
                }
                delim = dateDescriptor.date.substring(dateDescriptor.date.length() - 1, dateDescriptor.date.length());
                ipos += dateDescriptor.date.length();
                continue;
            }
            Matcher matcher = Pattern.compile(delimRegEx).matcher(string.substring(ipos));
            if (matcher.find()) {
                int r = matcher.start();
                int length = matcher.end() - matcher.start();
                token = string.substring(ipos, ipos + r);
                delim = string.substring(ipos + r, ipos + r + length);
                ipos = ipos + r + length;
            } else {
                token = string.substring(ipos);
                delim = "";
                ipos = string.length();
            }
            if (token.equals("")) continue;
            if (DatumRangeUtil.isYear(token)) {
                format = format + "%Y";
                if (ts1[0] == -1 && beforeTo) {
                    ts1[0] = DatumRangeUtil.parseInt(token);
                    ts2[0] = ts1[0];
                    continue;
                }
                beforeTo = false;
                ts2[0] = DatumRangeUtil.parseInt(token);
                if (ts1[0] != -1) continue;
                ts1[0] = ts2[0];
                continue;
            }
            if (DatumRangeUtil.isDayOfYear(token)) {
                dateFormat = 2;
                format = format + "%j";
                if (ts1[0] == -1) {
                    throw new ParseException("day of year before year", ipos);
                }
                int doy = DatumRangeUtil.parseInt(token);
                DatumRangeUtil.caldat(DatumRangeUtil.julday(12, 31, ts1[0] - 1) + doy, dateDescriptor);
                dateFormat = 2;
                int day = DatumRangeUtil.parseInt(dateDescriptor.day);
                int month2 = DatumRangeUtil.parseInt(dateDescriptor.month);
                if (ts1[2] == -1 && beforeTo) {
                    ts1[2] = day;
                    ts1[1] = month2;
                    ts2[2] = day;
                    ts2[1] = month2;
                    continue;
                }
                beforeTo = false;
                ts2[2] = day;
                ts2[1] = month2;
                if (ts1[2] != -1) continue;
                ts1[2] = day;
                ts1[1] = month2;
                continue;
            }
            if (DatumRangeUtil.monthNameNumber(token) != -1) {
                format = format + "%b";
                month = DatumRangeUtil.monthNameNumber(token);
                if (ts1[1] == -1) {
                    ts1[1] = month;
                    ts2[1] = month;
                    continue;
                }
                beforeTo = false;
                ts2[1] = month;
                if (ts1[1] != -1) continue;
                ts1[1] = month;
                continue;
            }
            boolean bl = isWithinTime = delim.equals(":") || lastdelim.equals(":");
            if (isWithinTime) {
                if (delim.equals(":") && !lastdelim.equals(":") && state == 89) {
                    format = format + "%H";
                    if (ts1[3] == -1) {
                        state = 90;
                        ts = ts1;
                    } else {
                        beforeTo = false;
                        state = 90;
                        ts = ts2;
                    }
                    ts[3] = DatumRangeUtil.parseInt(token);
                } else {
                    int i2;
                    for (i2 = 3; i2 <= 6 && ts[i2] != -1; ++i2) {
                    }
                    if (i2 == 6) {
                        int tokenDigits = token.length();
                        ts[i2] = DatumRangeUtil.parseInt(token) * 10 ^ 9 - tokenDigits;
                        switch (tokenDigits) {
                            case 3: {
                                format = format + "%_ms";
                                break;
                            }
                            case 6: {
                                format = format + "%_us";
                                break;
                            }
                            default: {
                                format = format + "%N";
                                break;
                            }
                        }
                    } else {
                        ts[i2] = DatumRangeUtil.parseInt(token);
                        format = format + formatCodes[i2];
                    }
                }
                if (delim.equals(":") || delim.equals(".")) continue;
                state = 89;
                continue;
            }
            if (beforeTo) {
                beforeToUnresolved.add(token);
                format = format + "UNRSV1" + beforeToUnresolved.size();
                continue;
            }
            afterToUnresolved.add(token);
            format = format + "UNRSV2" + afterToUnresolved.size();
        }
        format = format + " ";
        if (beforeTo) {
            int idx = 0;
            for (int i3 = 0; i3 < beforeToUnresolved.size(); ++i3) {
                while (ts1[idx] != -1) {
                    ++idx;
                }
                ts1[idx] = DatumRangeUtil.parseInt((String)beforeToUnresolved.get(i3));
                String[] s = format.split("UNRSV1" + (i3 + 1));
                format = s[0] + formatCodes[idx] + s[1];
            }
            beforeToUnresolved.removeAll(beforeToUnresolved);
        }
        if (beforeToUnresolved.size() + afterToUnresolved.size() > 0) {
            String formatUn;
            ArrayList<String> unload;
            String[] s;
            int i4;
            int idx = 0;
            if (beforeToUnresolved.size() < afterToUnresolved.size()) {
                if (beforeToUnresolved.size() > 0) {
                    for (i4 = 0; i4 < afterToUnresolved.size(); ++i4) {
                        while (ts2[idx] != -1) {
                            ++idx;
                        }
                        ts2[idx] = DatumRangeUtil.parseInt((String)afterToUnresolved.get(i4));
                        s = format.split("UNRSV2" + (i4 + 1));
                        format = s[0] + formatCodes[idx] + s[1];
                    }
                    unload = beforeToUnresolved;
                    formatUn = "UNRSV1";
                    ts = ts1;
                } else {
                    while (ts1[idx] != -1) {
                        ++idx;
                    }
                    --idx;
                    unload = afterToUnresolved;
                    formatUn = "UNRSV2";
                    ts = ts2;
                }
            } else if (afterToUnresolved.size() > 0) {
                for (i4 = 0; i4 < beforeToUnresolved.size(); ++i4) {
                    while (ts1[idx] != -1) {
                        ++idx;
                    }
                    ts1[idx] = DatumRangeUtil.parseInt((String)beforeToUnresolved.get(i4));
                    s = format.split("UNRSV1" + (i4 + 1));
                    format = s[0] + formatCodes[idx] + s[1];
                }
                unload = afterToUnresolved;
                formatUn = "UNRSV2";
                ts = ts2;
            } else {
                while (ts2[idx] != -1) {
                    ++idx;
                }
                --idx;
                unload = beforeToUnresolved;
                formatUn = "UNRSV1";
                ts = ts1;
            }
            int lsd = idx;
            for (int i5 = unload.size() - 1; i5 >= 0; --i5) {
                while (ts[lsd] != -1 && lsd > 0) {
                    --lsd;
                }
                if (ts[lsd] != -1) {
                    throw new ParseException("can't resolve these tokens: " + unload, 0);
                }
                ts[lsd] = DatumRangeUtil.parseInt((String)unload.get(i5));
                String[] s2 = format.split(formatUn + (i5 + 1));
                format = s2[0] + formatCodes[lsd] + s2[1];
            }
        }
        for (i = 0; i <= 2; ++i) {
            if (ts2[i] == -1 && ts1[i] != -1) {
                ts2[i] = ts1[i];
            }
            if (ts1[i] != -1 || ts2[i] == -1) continue;
            ts1[i] = ts2[i];
        }
        int[] implicit_timearr = new int[]{-1, 1, 1, 0, 0, 0, 0};
        int ts1lsd = -1;
        int ts2lsd = -1;
        for (i = 6; i >= 0; --i) {
            if (ts2[i] != -1 && ts2lsd == -1) {
                ts2lsd = i;
            }
            if (ts2lsd == -1) {
                ts2[i] = implicit_timearr[i];
            }
            if (ts2[i] == -1 && ts2lsd != -1) {
                throw new ParseException("not specified in stop time: " + digitIdentifiers[i], ipos);
            }
            if (ts1[i] != -1 && ts1lsd == -1) {
                ts1lsd = i;
            }
            if (ts1lsd == -1) {
                ts1[i] = implicit_timearr[i];
            }
            if (ts1[i] != -1 || ts1lsd == -1) continue;
            throw new ParseException("not specified in start time:" + digitIdentifiers[i], ipos);
        }
        if (ts1lsd != ts2lsd) {
            throw new ParseException("resolution mismatch: " + digitIdentifiers[ts1lsd] + " specified for start, but " + digitIdentifiers[ts2lsd] + " specified for end, must be same", ipos);
        }
        if (ts2lsd < 3) {
            int n = ts2lsd;
            ts2[n] = ts2[n] + 1;
        }
        if (ts1[0] < 1900) {
            ts1[0] = DatumRangeUtil.y2k("" + ts1[0]);
        }
        if (ts2[0] < 1900) {
            ts2[0] = DatumRangeUtil.y2k("" + ts2[0]);
        }
        if (ts1lsd < 2) {
            return new MonthDatumRange(ts1, ts2);
        }
        Datum time1 = TimeUtil.createTimeDatum(ts1[0], ts1[1], ts1[2], ts1[3], ts1[4], ts1[5], ts1[6]);
        Datum time2 = TimeUtil.createTimeDatum(ts2[0], ts2[1], ts2[2], ts2[3], ts2[4], ts2[5], ts2[6]);
        return new DatumRange(time1, time2);
    }

    public static DatumRange parseTimeRangeValid(String s) {
        try {
            return DatumRangeUtil.parseTimeRange(s);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private static String efficientTime(Datum time, Datum time2, DatumRange context2) {
        TimeUtil.TimeStruct ts = TimeUtil.toTimeStruct(time);
        int stopRes = 3;
        if (TimeUtil.getSecondsSinceMidnight(time) == 0.0 && time.equals(context2.max())) {
            ts.hour = 24;
            --ts.day;
        }
        String timeString = "" + ts.hour;
        Datum[] times = new Datum[]{time, time2};
        for (int i = 0; i < times.length; ++i) {
            int idigit;
            int[] arr = TimeUtil.toTimeArray(times[i]);
            for (idigit = 7; idigit > 3 && arr[idigit] <= 0; --idigit) {
            }
            stopRes = Math.max(stopRes, idigit);
        }
        int[] arr = TimeUtil.toTimeArray(time);
        if (stopRes > 3) {
            timeString = timeString + ":" + (arr[4] < 10 ? "0" : "") + arr[4];
            if (stopRes > 4) {
                int second = arr[5];
                timeString = timeString + ":" + (second < 10 ? "0" : "") + second;
                if (stopRes > 5) {
                    int millis = arr[6];
                    DecimalFormat nf = new DecimalFormat("000");
                    timeString = timeString + "." + nf.format(millis);
                    if (stopRes > 6) {
                        int micros = arr[7];
                        timeString = timeString + nf.format(micros);
                    }
                }
            }
        }
        return timeString;
    }

    public static String formatTimeRange(DatumRange self) {
        boolean isYearBoundry2;
        String[] monthStr = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "June", "July", "Aug", "Sep", "Oct", "Nov", "Dec"};
        double seconds = self.width().doubleValue(Units.seconds);
        TimeUtil.TimeStruct ts1 = TimeUtil.toTimeStruct(self.min());
        TimeUtil.TimeStruct ts2 = TimeUtil.toTimeStruct(self.max());
        boolean isMidnight1 = TimeUtil.getSecondsSinceMidnight(self.min()) == 0.0;
        boolean isMidnight2 = TimeUtil.getSecondsSinceMidnight(self.max()) == 0.0;
        boolean isMonthBoundry1 = isMidnight1 && ts1.day == 1;
        boolean isMonthBoundry2 = isMidnight2 && ts2.day == 1;
        boolean isYearBoundry1 = isMonthBoundry1 && ts1.month == 1;
        boolean bl = isYearBoundry2 = isMonthBoundry2 && ts2.month == 1;
        if (isYearBoundry1 && isYearBoundry2) {
            if (ts2.year - ts1.year == 1) {
                return "" + ts1.year;
            }
            return "" + ts1.year + " to " + ts2.year;
        }
        if (isMonthBoundry1 && isMonthBoundry2) {
            if (ts2.month == 1) {
                ts2.month = 13;
                --ts2.year;
            }
            if (ts2.year == ts1.year) {
                if (ts2.month - ts1.month == 1) {
                    return monthStr[ts1.month - 1] + " " + ts1.year;
                }
                return monthStr[ts1.month - 1] + " to " + monthStr[ts2.month - 1 - 1] + " " + ts1.year;
            }
            return monthStr[ts1.month - 1] + " " + ts1.year + " to " + monthStr[ts2.month - 1 - 1] + " " + ts2.year;
        }
        if (isMidnight1 && isMidnight2) {
            if (TimeUtil.getJulianDay(self.max()) - TimeUtil.getJulianDay(self.min()) == 1) {
                return TimeDatumFormatter.DAYS.format(self.min());
            }
            Datum endtime = self.max().subtract(Datum.create(1, Units.days));
            return TimeDatumFormatter.DAYS.format(self.min()) + " to " + TimeDatumFormatter.DAYS.format(endtime);
        }
        if (seconds < 1.0) {
            TimeDatumFormatter timeOfDayFormatter = TimeDatumFormatter.MILLISECONDS;
        } else if (seconds < 60.0) {
            TimeDatumFormatter timeOfDayFormatter = TimeDatumFormatter.MILLISECONDS;
        } else if (seconds < 3600.0) {
            TimeDatumFormatter timeOfDayFormatter = TimeDatumFormatter.SECONDS;
        } else {
            TimeDatumFormatter timeOfDayFormatter = TimeDatumFormatter.MINUTES;
        }
        int maxDay = TimeUtil.getJulianDay(self.max());
        if (TimeUtil.getSecondsSinceMidnight(self.max()) == 0.0) {
            --maxDay;
        }
        if (maxDay == TimeUtil.getJulianDay(self.min())) {
            return TimeDatumFormatter.DAYS.format(self.min()) + " " + DatumRangeUtil.efficientTime(self.min(), self.max(), self) + " to " + DatumRangeUtil.efficientTime(self.max(), self.min(), self);
        }
        String t1str = DatumRangeUtil.efficientTime(self.min(), self.max(), self);
        String t2str = DatumRangeUtil.efficientTime(self.max(), self.min(), self);
        return TimeDatumFormatter.DAYS.format(self.min()) + " " + t1str + " to " + TimeDatumFormatter.DAYS.format(self.max()) + " " + t2str;
    }

    public static List generateList(DatumRange bounds, DatumRange element) {
        ArrayList<DatumRange> result = new ArrayList<DatumRange>();
        DatumRange dr = element;
        while (dr.max().gt(bounds.min())) {
            result.add(0, dr);
            dr = dr.previous();
        }
        dr = element.next();
        while (dr.min().lt(bounds.max())) {
            result.add(dr);
            dr = dr.next();
        }
        return result;
    }

    public static DatumRange newDimensionless(double lower, double upper) {
        return new DatumRange(Datum.create(lower), Datum.create(upper));
    }

    public static DatumRange parseDatumRange(String str, DatumRange orig) {
        String[] ss = str.split("to");
        if (ss.length != 2) {
            if (ss.length == 3) {
                ss[0] = "-" + ss[1];
                ss[1] = ss[2];
            } else {
                throw new IllegalArgumentException("failed to parse: " + str);
            }
        }
        double d1 = Double.parseDouble(ss[0]);
        double d2 = Double.parseDouble(ss[1]);
        return DatumRange.newDatumRange(d1, d2, orig.getUnits());
    }

    public static class DateDescriptor {
        String date;
        String year;
        String month;
        String day;
        int dateformat;
    }
}

