/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRangeUtil;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.Units;

public class DatumRange
implements Comparable {
    Datum s1;
    Datum s2;

    public DatumRange(Datum s1, Datum s2) {
        if (s2.lt(s1)) {
            throw new IllegalArgumentException("s2<s1: " + s2 + "<" + s1);
        }
        this.s1 = s1;
        this.s2 = s2;
    }

    public boolean intersects(DatumRange dr) {
        return this.s2.gt(dr.s1) && this.s1.lt(dr.s2);
    }

    public boolean contains(Datum d) {
        return this.s1.le(d) && d.lt(this.s2);
    }

    public Datum width() {
        return this.s2.subtract(this.s1);
    }

    public String toString() {
        if (this.s1.getUnits() instanceof TimeLocationUnits) {
            return DatumRangeUtil.formatTimeRange(this);
        }
        return "" + this.s1 + " to " + this.s2;
    }

    public boolean equals(Object o) {
        return this == o || 0 == this.compareTo(o);
    }

    public int compareTo(Object o) {
        if (!(o instanceof DatumRange)) {
            throw new IllegalArgumentException("argument is not a DatumRange");
        }
        DatumRange dr = (DatumRange)o;
        int comp = this.s1.compareTo(dr.s1);
        if (comp != 0) {
            return comp;
        }
        return this.s2.compareTo(dr.s2);
    }

    public DatumRange zoomOut(double factor) {
        double add = (factor - 1.0) / 2.0;
        return this.rescale(-add, 1.0 + add);
    }

    public DatumRange rescale(double min, double max) {
        Datum w = this.width();
        if (!w.isFinite()) {
            throw new RuntimeException("width is not finite");
        }
        if (w.doubleValue(w.getUnits()) == 0.0) {
            throw new RuntimeException("width is zero!");
        }
        return new DatumRange(this.s1.add(w.multiply(min)), this.s1.add(w.multiply(max)));
    }

    public Datum min() {
        return this.s1;
    }

    public Datum max() {
        return this.s2;
    }

    public DatumRange next() {
        return this.rescale(1.0, 2.0);
    }

    public DatumRange previous() {
        return this.rescale(-1.0, 0.0);
    }

    public DatumRange include(Datum d) {
        if (d.isFill()) {
            return this;
        }
        if (this.contains(d)) {
            return this;
        }
        Datum min = this.min().le(d) ? this.min() : d;
        Datum max = this.max().ge(d) ? this.max() : d;
        return new DatumRange(min, max);
    }

    public Units getUnits() {
        return this.s1.getUnits();
    }

    public static DatumRange newDatumRange(double min, double max, Units units) {
        return new DatumRange(Datum.create(min, units), Datum.create(max, units));
    }
}

