/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset.test;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DefaultVectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public class SineWaveDataSetDescriptor
extends DataSetDescriptor {
    Datum amplitude;
    Datum period;
    Datum phase;

    public SineWaveDataSetDescriptor(Datum amplitude, Datum period) {
        super(null);
        if (0.0 == period.doubleValue(period.getUnits())) {
            throw new IllegalArgumentException("period is zero");
        }
        this.amplitude = amplitude;
        this.period = period;
        this.phase = null;
    }

    public DataSet getDataSetImpl(Datum start, Datum end, Datum resolution, DasProgressMonitor monitor) throws DasException {
        int nstep = (int)(end.subtract(start).doubleValue(resolution.getUnits()) / resolution.doubleValue(resolution.getUnits()));
        int stepSize = 1;
        nstep /= stepSize;
        if (this.phase == null) {
            this.phase = start;
        }
        double[] yvalues = new double[nstep];
        double[] xtags = new double[nstep];
        Units xunits = this.phase.getUnits();
        Units offsetUnits = this.period.getUnits();
        Units yunits = this.amplitude.getUnits();
        for (int i = 0; i < nstep; ++i) {
            Datum x = start.add(resolution.multiply(i * stepSize));
            double y = this.amplitude.doubleValue(yunits) * Math.sin(Math.PI * 2 * (x.subtract(this.phase).doubleValue(offsetUnits) / this.period.doubleValue(offsetUnits)));
            xtags[i] = x.doubleValue(xunits);
            yvalues[i] = y;
        }
        DefaultVectorDataSet result = new DefaultVectorDataSet(xtags, xunits, yvalues, yunits, new HashMap());
        return result;
    }

    public Units getXUnits() {
        return this.period.getUnits();
    }

    public static SineWaveDataSetDescriptor newDataSetDescriptor(Map map) throws DasException {
        String periodStr = (String)map.get("period");
        String xUnitsStr = (String)map.get("xUnits");
        String amplitudeStr = (String)map.get("amplitude");
        String yUnitsStr = (String)map.get("yUnits");
        if (periodStr == null || amplitudeStr == null) {
            throw new DasException("period and amplitude must be specified for SineWaveDataSetDescriptors");
        }
        Units xUnits = xUnitsStr == null ? Units.dimensionless : Units.getByName(xUnitsStr);
        Units yUnits = xUnitsStr == null ? Units.dimensionless : Units.getByName(yUnitsStr);
        try {
            Datum period = xUnits.getOffsetUnits().parse(periodStr);
            Datum amplitude = yUnits.parse(amplitudeStr);
            return new SineWaveDataSetDescriptor(amplitude, period);
        }
        catch (ParseException pe) {
            throw new DasException(pe.getMessage());
        }
    }
}

