/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset.test;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;

public class RipplesDataSetDescriptor
extends DataSetDescriptor {
    double x1;
    double y1;
    double p1;
    double x2;
    double y2;
    double p2;

    public RipplesDataSetDescriptor() {
        this(14.0, 17.0, 10.0, 20.0, 60.0, 15.0);
    }

    public RipplesDataSetDescriptor(double x1, double y1, double p1, double x2, double y2, double p2) {
        this.x1 = x1;
        this.y1 = y1;
        this.p1 = p1;
        this.x2 = x2;
        this.y2 = y2;
        this.p2 = p2;
    }

    public Units getXUnits() {
        return Units.dimensionless;
    }

    public Units getYUnits() {
        return Units.dimensionless;
    }

    public Units getZUnits() {
        return Units.dimensionless;
    }

    public DataSet getDataSetImpl(Datum start, Datum end, Datum resolution, DasProgressMonitor monitor) throws DasException {
        int nx = 100;
        int ny = 100;
        double[] x = new double[nx];
        double[] y = new double[ny];
        double[][] z = new double[nx][ny];
        monitor.setTaskSize(x.length);
        monitor.started();
        for (int i = 0; i < x.length; ++i) {
            x[i] = i;
            for (int j = 0; j < y.length; ++j) {
                double rad1 = Math.sqrt(((double)i - this.x1) * ((double)i - this.x1) + ((double)j - this.y1) * ((double)j - this.y1));
                double exp1 = Math.exp(-rad1 / this.p1) * Math.cos(Math.PI * this.p1 * rad1);
                double rad2 = Math.sqrt((i - nx * 2 / 3) * (i - nx * 2 / 3) + (j - ny * 2 / 3) * (j - ny * 2 / 3));
                double exp2 = Math.exp(-rad2 / this.p2) * Math.cos(Math.PI * this.p2 * rad2);
                z[i][j] = exp1 + exp2;
                if (22 >= i || i >= 24) continue;
                z[i][j] = -1.0E31f;
            }
            if (monitor.isCancelled()) break;
            monitor.setTaskProgress(i);
        }
        for (int j = 0; j < y.length; ++j) {
            y[j] = j;
        }
        z[50][50] = -1.0;
        z[0][0] = 1.0;
        z[25][25] = -0.5;
        return DefaultTableDataSet.createSimple(x, y, z);
    }
}

