/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset.test;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.XSliceDataSet;
import edu.uiowa.physics.pw.das.dataset.YSliceDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import java.util.HashMap;
import java.util.Map;

public abstract class FunctionTableDataSet
implements TableDataSet {
    Units zUnits = Units.dimensionless;
    Units yUnits = Units.dimensionless;
    Units xUnits = Units.dimensionless;
    protected int ytags;
    protected int xtags;
    double[] data;

    public abstract double getDoubleImpl(int var1, int var2, Units var3);

    public FunctionTableDataSet(int nx, int ny) {
        this.xtags = nx;
        this.ytags = ny;
        this.data = new double[nx * ny];
        for (int i = 0; i < nx; ++i) {
            for (int j = 0; j < ny; ++j) {
                int idx = i + j * this.xtags;
                this.data[idx] = this.getDoubleImpl(i, j, Units.dimensionless);
            }
        }
    }

    protected void fillCache() {
        this.data = new double[this.xtags * this.ytags];
        for (int i = 0; i < this.xtags; ++i) {
            for (int j = 0; j < this.ytags; ++j) {
                int idx = i + j * this.xtags;
                this.data[idx] = this.getDoubleImpl(i, j, Units.dimensionless);
            }
        }
    }

    public double getDouble(int i, int j, Units units) {
        int idx = i + j * this.xtags;
        return this.data[idx];
    }

    public Datum getDatum(int i, int j) {
        return this.zUnits.createDatum(this.getDouble(i, j, this.zUnits));
    }

    public double[] getDoubleScan(int i, Units units) {
        int yLength = this.getYLength(this.tableOfIndex(i));
        double[] array = new double[yLength];
        for (int j = 0; j < yLength; ++j) {
            array[j] = this.getDouble(i, j, units);
        }
        return array;
    }

    public DatumVector getScan(int i) {
        return DatumVector.newDatumVector(this.getDoubleScan(i, this.zUnits), this.zUnits);
    }

    public int getInt(int i, int j, Units units) {
        return (int)this.getDouble(i, j, units);
    }

    public DataSet getPlanarView(String planeID) {
        return null;
    }

    public String[] getPlaneIds() {
        return new String[0];
    }

    public Object getProperty(String name) {
        return null;
    }

    public Map getProperties() {
        return new HashMap();
    }

    public int getXLength() {
        return this.xtags;
    }

    public VectorDataSet getXSlice(int i) {
        return new XSliceDataSet(this, i);
    }

    public Datum getXTagDatum(int i) {
        return this.xUnits.createDatum(this.getXTagDouble(i, this.xUnits));
    }

    public double getXTagDouble(int i, Units units) {
        return this.xUnits.convertDoubleTo(units, (double)i * 20.0 / (double)this.xtags);
    }

    public int getXTagInt(int i, Units units) {
        return (int)this.getXTagDouble(i, units);
    }

    public Units getXUnits() {
        return this.xUnits;
    }

    public int getYLength(int table) {
        return this.ytags;
    }

    public VectorDataSet getYSlice(int j, int table) {
        return new YSliceDataSet(this, j, table);
    }

    public Datum getYTagDatum(int table, int j) {
        return this.yUnits.createDatum(this.getYTagDouble(table, j, this.yUnits));
    }

    public double getYTagDouble(int table, int j, Units units) {
        if (table > 0) {
            throw new IllegalArgumentException("table doesn't exist: " + table);
        }
        return this.yUnits.convertDoubleTo(units, (double)j * 20.0 / (double)this.ytags);
    }

    public int getYTagInt(int table, int j, Units units) {
        return (int)this.getYTagDouble(table, j, units);
    }

    public Units getYUnits() {
        return this.yUnits;
    }

    public Units getZUnits() {
        return this.zUnits;
    }

    public int tableCount() {
        return 1;
    }

    public int tableEnd(int table) {
        return this.xtags;
    }

    public int tableOfIndex(int i) {
        return 0;
    }

    public int tableStart(int table) {
        return 0;
    }

    public DatumVector getYTags(int table) {
        double[] tags = new double[this.getYLength(table)];
        for (int j = 0; j < tags.length; ++j) {
            tags[j] = this.getYTagDouble(table, j, this.yUnits);
        }
        return DatumVector.newDatumVector(tags, this.yUnits);
    }

    public String toString() {
        return TableUtil.toString(this);
    }
}

