/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;

public class RebinDescriptor {
    Units units;
    protected double start;
    protected double end;
    protected int nBin;
    protected boolean isLog = false;
    public static final int FIRSTORLAST = -2;
    public static final int MINUSONE = -3;
    public static final int EXTRAPOLATE = -4;
    private int outOfBoundsAction = -4;

    private RebinDescriptor() {
    }

    public RebinDescriptor(double start, double end, Units units, int nBin, boolean isLog) {
        this.units = units;
        if (isLog) {
            this.start = Math.log(start);
            this.end = Math.log(end);
        } else {
            this.start = start;
            this.end = end;
        }
        this.nBin = nBin;
        this.isLog = isLog;
    }

    public RebinDescriptor(Datum start, Datum end, int nBin, boolean isLog) {
        this(start.doubleValue(start.getUnits()), end.doubleValue(end.getUnits()), start.getUnits(), nBin, isLog);
        if (start.getUnits() != end.getUnits()) {
            throw new IllegalArgumentException("start and end units differ");
        }
    }

    public int numberOfBins() {
        return this.nBin;
    }

    public int whichBin(double x, Units units) {
        if (units != this.units) {
            x = Units.getConverter(units, this.units).convert(x);
        }
        int result = 0;
        if (this.isLog) {
            x = Math.log(x);
        }
        if ((x < this.start || x >= this.end) && this.outOfBoundsAction != -4) {
            switch (this.outOfBoundsAction) {
                case -2: {
                    result = x < this.start ? 0 : this.nBin - 1;
                }
                case -3: {
                    result = -1;
                }
            }
        } else {
            result = (int)((x - this.start) * (double)this.nBin / (this.end - this.start));
        }
        return result;
    }

    public double[] binCenters() {
        int i;
        double[] result = new double[this.nBin];
        for (i = 0; i < this.nBin; ++i) {
            result[i] = this.start + ((double)i + 0.5) / (double)this.nBin * (this.end - this.start);
        }
        if (this.isLog) {
            for (i = 0; i < this.nBin; ++i) {
                result[i] = Math.exp(result[i]);
            }
        }
        return result;
    }

    public double binCenter(int ibin) {
        double result = this.start + ((double)ibin + 0.5) / (double)this.nBin * (this.end - this.start);
        if (this.isLog) {
            return Math.exp(result);
        }
        return result;
    }

    public double binStart(int ibin, Units units) {
        if (this.outOfBoundsAction != -4 && (ibin < 0 || ibin >= this.numberOfBins())) {
            throw new IllegalArgumentException("bin " + ibin + " is out of bounds");
        }
        double result = this.start + (double)ibin / (double)this.nBin * (this.end - this.start);
        UnitsConverter uc = this.units.getConverter(units);
        if (this.isLog) {
            return uc.convert(Math.exp(result));
        }
        return uc.convert(result);
    }

    public double binStop(int ibin, Units units) {
        if (this.outOfBoundsAction != -4 && (ibin < 0 || ibin >= this.numberOfBins())) {
            throw new IllegalArgumentException("bin " + ibin + " is out of bounds");
        }
        double result = this.start + (double)(ibin + 1) / (double)this.nBin * (this.end - this.start);
        UnitsConverter uc = this.units.getConverter(units);
        if (this.isLog) {
            return uc.convert(Math.exp(result));
        }
        return uc.convert(result);
    }

    public double[] binStarts() {
        int i;
        double[] result = new double[this.nBin];
        for (i = 0; i < this.nBin; ++i) {
            result[i] = this.start + (double)((float)i / (float)this.nBin) * (this.end - this.start);
        }
        if (this.isLog) {
            for (i = 0; i < this.nBin; ++i) {
                result[i] = Math.exp(result[i]);
            }
        }
        return result;
    }

    public double[] binStops() {
        int i;
        double[] result = new double[this.nBin];
        for (i = 0; i < this.nBin; ++i) {
            result[i] = this.start + (double)((float)(i + 1) / (float)this.nBin) * (this.end - this.start);
        }
        if (this.isLog) {
            for (i = 0; i < this.nBin; ++i) {
                result[i] = Math.exp(result[i]);
            }
        }
        return result;
    }

    public void setOutOfBoundsAction(int action) {
        this.outOfBoundsAction = action;
    }

    private Object clone(int outOfBoundsAction) {
        RebinDescriptor result = new RebinDescriptor();
        result.units = this.units;
        result.start = this.start;
        result.end = this.end;
        result.nBin = this.nBin;
        result.isLog = this.isLog;
        result.outOfBoundsAction = outOfBoundsAction;
        return result;
    }

    public static RebinDescriptor createSubsumingRebinDescriptor(RebinDescriptor ddY, Datum ymin, Datum ymax) {
        Units units;
        if (ddY == null) {
            return null;
        }
        RebinDescriptor dd = (RebinDescriptor)ddY.clone(-4);
        int i0 = dd.whichBin(ymin.doubleValue(units = ddY.getUnits()), units);
        if (i0 > 0) {
            i0 = 0;
            ymin = units.createDatum(ddY.binStart(0, units));
        }
        if (i0 < -10000000) {
            throw new IllegalArgumentException("ymin would result in impossibly large rebin descriptor (ymin=" + ymin + " falls in bin number " + i0 + ")");
        }
        int i1 = dd.whichBin(ymax.doubleValue(units), units);
        if (i1 < dd.numberOfBins()) {
            i1 = dd.numberOfBins();
            ymax = units.createDatum(dd.binStop(dd.numberOfBins() - 1, units));
        }
        if (i0 > 10000000) {
            throw new IllegalArgumentException("ymax would result in impossibly large rebin descriptor (ymax=" + ymax + " falls in bin number " + i0 + ")");
        }
        int nbins = i1 - i0 + 1;
        return new RebinDescriptor(units.createDatum(dd.binStart(i0, units)), units.createDatum(dd.binStop(i1, units)), nbins, dd.isLog());
    }

    public double binWidth() {
        return (this.end - this.start) / (double)this.nBin;
    }

    public boolean isLog() {
        return this.isLog;
    }

    public Units getUnits() {
        return this.units;
    }

    public String toString() {
        return "[" + this.units.createDatum(this.start) + " - " + this.units.createDatum(this.end) + " in " + this.nBin + " bins " + (this.isLog ? "Log" : "") + "]";
    }
}

