/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import java.util.Map;

public class ClippedTableDataSet
implements TableDataSet {
    TableDataSet source;
    int xoffset;
    int xlength;
    int[] yoffsets;
    int[] ylengths;
    int tableOffset;
    int tableCount;

    void calculateXOffset(Datum xmin, Datum xmax) {
        this.xoffset = DataSetUtil.getPreviousColumn(this.source, xmin);
        int ix1 = DataSetUtil.getNextColumn(this.source, xmax);
        this.xlength = ix1 - this.xoffset;
    }

    void calculateTableOffset() {
        this.tableOffset = -99;
        for (int itable = 0; itable < this.source.tableCount(); ++itable) {
            if (this.tableOffset == -99 && this.source.tableEnd(itable) > this.xoffset) {
                this.tableOffset = itable;
            }
            if (this.tableOffset == -99 || this.source.tableEnd(itable) < this.xoffset + this.xlength) continue;
            this.tableCount = itable - this.tableOffset + 1;
        }
    }

    void calculateYOffsets(Datum ymin, Datum ymax) {
        this.yoffsets = new int[this.tableCount];
        this.ylengths = new int[this.tableCount];
        for (int itable = this.tableOffset; itable < this.tableOffset + this.tableCount; ++itable) {
            this.yoffsets[itable - this.tableOffset] = TableUtil.getPreviousRow(this.source, itable, ymin);
            int ix1 = TableUtil.getNextRow(this.source, itable, ymax);
            this.ylengths[itable - this.tableOffset] = ix1 - this.yoffsets[itable];
        }
    }

    public ClippedTableDataSet(TableDataSet source, Datum xmin, Datum xmax, Datum ymin, Datum ymax) {
        this(source, new DatumRange(xmin, xmax), new DatumRange(ymin, ymax));
    }

    public ClippedTableDataSet(TableDataSet source, DatumRange xrange, DatumRange yrange) {
        this.source = source;
        this.calculateXOffset(xrange.min(), xrange.max());
        this.calculateTableOffset();
        this.calculateYOffsets(yrange.min(), yrange.max());
    }

    public ClippedTableDataSet(TableDataSet source, int xoffset, int xlength, int yoffset, int ylength) {
        if (source.tableCount() > 1) {
            throw new IllegalArgumentException("this ClippedTableDataSet constructor requires that there be only one table");
        }
        if (source.getXLength() < xoffset + xlength) {
            throw new IllegalArgumentException("xoffset + xlength greater than the number of XTags in source");
        }
        if (source.getYLength(0) < yoffset + ylength) {
            throw new IllegalArgumentException("yoffset + ylength greater than the number of YTags in source");
        }
        if (yoffset < 0 || xoffset < 0) {
            throw new IllegalArgumentException("yoffset(" + yoffset + ") or xoffset(" + xoffset + ") is negative");
        }
        this.source = source;
        this.xoffset = xoffset;
        this.xlength = xlength;
        this.tableOffset = 0;
        this.tableCount = 1;
        this.yoffsets = new int[]{yoffset};
        this.ylengths = new int[]{ylength};
    }

    private ClippedTableDataSet(TableDataSet source, int xoffset, int xlength, int[] yoffsets, int[] ylengths, int tableOffset, int tableCount) {
        if (source == null) {
            throw new IllegalArgumentException("source is null");
        }
        this.source = source;
        this.xoffset = xoffset;
        this.xlength = xlength;
        this.yoffsets = yoffsets;
        this.ylengths = ylengths;
        this.tableOffset = tableOffset;
        this.tableCount = tableCount;
    }

    public Datum getDatum(int i, int j) {
        return this.source.getDatum(i + this.xoffset, j + this.yoffsets[this.tableOfIndex(i)]);
    }

    public double getDouble(int i, int j, Units units) {
        return this.source.getDouble(i + this.xoffset, j + this.yoffsets[this.tableOfIndex(i)], units);
    }

    public double[] getDoubleScan(int i, Units units) {
        int table = this.tableOfIndex(i);
        int yLength = this.getYLength(table);
        double[] array = new double[yLength];
        double[] sourceArray = this.source.getDoubleScan(i + this.xoffset, units);
        System.arraycopy(sourceArray, this.yoffsets[table], array, 0, yLength);
        return array;
    }

    public DatumVector getScan(int i) {
        int table = this.tableOfIndex(i);
        int yLength = this.getYLength(table);
        return this.source.getScan(i + this.xoffset).getSubVector(this.yoffsets[table], this.yoffsets[table] + yLength);
    }

    public int getInt(int i, int j, Units units) {
        return this.source.getInt(i + this.xoffset, j + this.yoffsets[this.tableOfIndex(i)], units);
    }

    public DataSet getPlanarView(String planeID) {
        return new ClippedTableDataSet((TableDataSet)this.source.getPlanarView(planeID), this.xoffset, this.xlength, this.yoffsets, this.ylengths, this.tableOffset, this.tableCount);
    }

    public String[] getPlaneIds() {
        return this.source.getPlaneIds();
    }

    public Map getProperties() {
        return this.source.getProperties();
    }

    public Object getProperty(String name) {
        return this.source.getProperty(name);
    }

    public int getXLength() {
        return this.xlength;
    }

    public VectorDataSet getXSlice(int i) {
        return this.source.getXSlice(i + this.xoffset);
    }

    public Datum getXTagDatum(int i) {
        return this.source.getXTagDatum(i + this.xoffset);
    }

    public double getXTagDouble(int i, Units units) {
        return this.source.getXTagDouble(i + this.xoffset, units);
    }

    public int getXTagInt(int i, Units units) {
        return this.source.getXTagInt(i + this.xoffset, units);
    }

    public Units getXUnits() {
        return this.source.getXUnits();
    }

    public int getYLength(int table) {
        return this.ylengths[table];
    }

    public VectorDataSet getYSlice(int j, int table) {
        return this.source.getYSlice(j + this.yoffsets[table], table + this.tableOffset);
    }

    public Datum getYTagDatum(int table, int j) {
        return this.source.getYTagDatum(table + this.tableOffset, j + this.yoffsets[table]);
    }

    public double getYTagDouble(int table, int j, Units units) {
        return this.source.getYTagDouble(table + this.tableOffset, j + this.yoffsets[table], units);
    }

    public int getYTagInt(int table, int j, Units units) {
        return this.source.getYTagInt(table + this.tableOffset, j + this.yoffsets[table], units);
    }

    public Units getYUnits() {
        return this.source.getYUnits();
    }

    public Units getZUnits() {
        return this.source.getZUnits();
    }

    public int tableCount() {
        return this.tableCount;
    }

    public int tableEnd(int table) {
        int i = this.source.tableEnd(table + this.tableOffset) - this.xoffset;
        if (i > this.getXLength()) {
            return this.getXLength();
        }
        return i;
    }

    public int tableOfIndex(int i) {
        return this.source.tableOfIndex(i + this.xoffset) - this.tableOffset;
    }

    public int tableStart(int table) {
        int i = this.source.tableStart(table + this.tableOffset) - this.xoffset;
        if (i < 0) {
            return 0;
        }
        return i;
    }

    public String toString() {
        return "ClippedTableDataSet " + TableUtil.toString(this);
    }

    public DatumVector getYTags(int table) {
        double[] tags = new double[this.getYLength(table)];
        Units yUnits = this.getYUnits();
        for (int j = 0; j < tags.length; ++j) {
            tags[j] = this.getYTagDouble(table, j, yUnits);
        }
        return DatumVector.newDatumVector(tags, yUnits);
    }
}

