/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetRebinner;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet;
import edu.uiowa.physics.pw.das.dataset.NoDataInIntervalException;
import edu.uiowa.physics.pw.das.dataset.RebinDescriptor;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Logger;

public class AverageTableRebinner
implements DataSetRebinner {
    private static Logger logger = DasApplication.getDefaultApplication().getLogger();
    private boolean interpolate = true;
    private boolean enlargePixels = true;

    public DataSet rebin(DataSet ds, RebinDescriptor ddX, RebinDescriptor ddY) throws IllegalArgumentException, DasException {
        Object yTags;
        double[] xTags;
        if (!(ds instanceof TableDataSet)) {
            throw new IllegalArgumentException();
        }
        TableDataSet tds = (TableDataSet)ds;
        TableDataSet weights = (TableDataSet)ds.getPlanarView("weights");
        if (ddX != null && tds.getXLength() > 0) {
            double start = tds.getXTagDouble(0, ddX.getUnits());
            double end = tds.getXTagDouble(tds.getXLength() - 1, ddX.getUnits());
            if (start > ddX.end) {
                throw new NoDataInIntervalException("data starts after range");
            }
            if (end < ddX.start) {
                throw new NoDataInIntervalException("data ends before range");
            }
        }
        long timer = System.currentTimeMillis();
        Units xunits = ddX.getUnits();
        int nx = ddX == null ? tds.getXLength() : ddX.numberOfBins();
        int ny = ddY == null ? tds.getYLength(0) : ddY.numberOfBins();
        logger.finest("Allocating rebinData and rebinWeights: " + nx + " x " + ny);
        double[][] rebinData = new double[nx][ny];
        double[][] rebinWeights = new double[nx][ny];
        AverageTableRebinner.average(tds, weights, rebinData, rebinWeights, ddX, ddY);
        if (ddX != null) {
            xTags = ddX.binCenters();
        } else {
            xTags = new double[nx];
            for (int i = 0; i < nx; ++i) {
                xTags[i] = tds.getXTagDouble(i, tds.getXUnits());
            }
        }
        if (ddY != null) {
            yTags = new double[][]{ddY.binCenters()};
        } else {
            yTags = new double[1][ny];
            for (int j = 0; j < ny; ++j) {
                yTags[0][j] = tds.getYTagDouble(0, j, tds.getYUnits());
            }
        }
        Datum xTagWidth = (Datum)ds.getProperty("xTagWidth");
        if (xTagWidth == null) {
            xTagWidth = DataSetUtil.guessXTagWidth(tds);
        }
        double xTagWidthDouble = xTagWidth.doubleValue(ddX.getUnits().getOffsetUnits());
        Datum yTagWidth = (Datum)ds.getProperty("yTagWidth");
        double yTagWidthDouble = yTagWidth == null ? Double.POSITIVE_INFINITY : yTagWidth.doubleValue(ddY.getUnits().getOffsetUnits());
        if (this.interpolate) {
            if (ddX != null) {
                AverageTableRebinner.fillInterpolateX(rebinData, rebinWeights, xTags, xTagWidthDouble);
            }
            if (ddY != null) {
                AverageTableRebinner.fillInterpolateY(rebinData, rebinWeights, yTags[0], yTagWidthDouble, ddY.isLog());
            }
        } else if (this.enlargePixels) {
            this.enlargePixels(rebinData, rebinWeights);
        }
        double[][][] zValues = new double[][][]{rebinData, rebinWeights};
        int[] tableOffsets = new int[]{0};
        Units[] zUnits = new Units[]{tds.getZUnits(), Units.dimensionless};
        String[] planeIDs = new String[]{"", "weights"};
        Units resultXUnits = ddX == null ? tds.getXUnits() : ddX.getUnits();
        Units resultYUnits = ddY == null ? tds.getYUnits() : ddY.getUnits();
        DefaultTableDataSet result = new DefaultTableDataSet(xTags, resultXUnits, (double[][])yTags, resultYUnits, (double[][][])zValues, zUnits, planeIDs, tableOffsets, Collections.EMPTY_MAP);
        return result;
    }

    static void average(TableDataSet tds, TableDataSet weights, double[][] rebinData, double[][] rebinWeights, RebinDescriptor ddX, RebinDescriptor ddY) {
        int j;
        double[] ycoordinate;
        int i;
        Units xUnits = tds.getXUnits();
        Units zUnits = tds.getZUnits();
        int nx = ddX == null ? tds.getXLength() : ddX.numberOfBins();
        int ny = ddY == null ? tds.getYLength(0) : ddY.numberOfBins();
        double[][] hInterpData = new double[nx][2];
        double[][] hInterpWeights = new double[nx][2];
        int[][] hInterpIndex = new int[nx][2];
        double[][] vInterpData = new double[2][ny];
        double[][] vInterpWeights = new double[2][ny];
        int[][] vInterpIndex = new int[2][ny];
        for (i = 0; i < hInterpIndex.length; ++i) {
            Arrays.fill(hInterpIndex[i], -1);
        }
        for (i = 0; i < vInterpIndex.length; ++i) {
            Arrays.fill(vInterpIndex[i], -1);
        }
        if (ddY != null) {
            ycoordinate = ddY.binCenters();
        } else {
            ycoordinate = new double[tds.getYLength(0)];
            for (j = 0; j < ycoordinate.length; ++j) {
                ycoordinate[j] = tds.getDouble(0, j, zUnits);
            }
        }
        int nTables = tds.tableCount();
        for (int iTable = 0; iTable < nTables; ++iTable) {
            int[] ibiny = new int[tds.getYLength(iTable)];
            for (int j2 = 0; j2 < ibiny.length; ++j2) {
                ibiny[j2] = ddY != null ? ddY.whichBin(tds.getYTagDouble(iTable, j2, tds.getYUnits()), tds.getYUnits()) : j2;
            }
            for (int i2 = tds.tableStart(iTable); i2 < tds.tableEnd(iTable); ++i2) {
                double w;
                double z;
                int j3;
                int ibinx = ddX != null ? ddX.whichBin(tds.getXTagDouble(i2, xUnits), xUnits) : i2;
                if (ibinx < 0) {
                    for (j3 = 0; j3 < tds.getYLength(iTable); ++j3) {
                        if (ibiny[j3] < 0 || ibiny[j3] >= ny) continue;
                        z = tds.getDouble(i2, j3, zUnits);
                        double d = weights == null ? (zUnits.isFill(z) ? 0.0 : 1.0) : (w = weights.getDouble(i2, j3, Units.dimensionless));
                        if (vInterpIndex[0][ibiny[j3]] == -1 || ibinx > vInterpIndex[0][ibiny[j3]]) {
                            vInterpData[0][ibiny[j3]] = z * w;
                            vInterpWeights[0][ibiny[j3]] = w;
                            vInterpIndex[0][ibiny[j3]] = ibinx;
                            continue;
                        }
                        if (ibinx != vInterpIndex[0][ibiny[j3]]) continue;
                        double[] dArray = vInterpData[0];
                        int n = ibiny[j3];
                        dArray[n] = dArray[n] + z * w;
                        double[] dArray2 = vInterpWeights[0];
                        int n2 = ibiny[j3];
                        dArray2[n2] = dArray2[n2] + w;
                    }
                    continue;
                }
                if (ibinx >= nx) {
                    for (j3 = 0; j3 < tds.getYLength(iTable); ++j3) {
                        if (ibiny[j3] < 0 || ibiny[j3] >= ny) continue;
                        z = tds.getDouble(i2, j3, zUnits);
                        double d = weights == null ? (zUnits.isFill(z) ? 0.0 : 1.0) : (w = weights.getDouble(i2, j3, Units.dimensionless));
                        if (vInterpIndex[1][ibiny[j3]] == -1 || ibinx < vInterpIndex[1][ibiny[j3]]) {
                            vInterpData[1][ibiny[j3]] = z * w;
                            vInterpWeights[1][ibiny[j3]] = w;
                            vInterpIndex[1][ibiny[j3]] = ibinx;
                            continue;
                        }
                        double[] dArray = vInterpData[1];
                        int n = ibiny[j3];
                        dArray[n] = dArray[n] + z * w;
                        double[] dArray3 = vInterpWeights[1];
                        int n3 = ibiny[j3];
                        dArray3[n3] = dArray3[n3] + w;
                    }
                    continue;
                }
                for (j3 = 0; j3 < tds.getYLength(iTable); ++j3) {
                    z = tds.getDouble(i2, j3, zUnits);
                    double d = weights == null ? (zUnits.isFill(z) ? 0.0 : 1.0) : (w = weights.getDouble(i2, j3, Units.dimensionless));
                    if (ibiny[j3] < 0) {
                        if (hInterpIndex[ibinx][0] == -1 || ibiny[j3] > hInterpIndex[ibinx][0]) {
                            hInterpData[ibinx][0] = z * w;
                            hInterpWeights[ibinx][0] = w;
                            hInterpIndex[ibinx][0] = ibiny[j3];
                            continue;
                        }
                        if (ibiny[j3] != hInterpIndex[ibinx][0]) continue;
                        double[] dArray = hInterpData[ibinx];
                        dArray[0] = dArray[0] + z * w;
                        double[] dArray4 = hInterpWeights[ibinx];
                        dArray4[0] = dArray4[0] + w;
                        continue;
                    }
                    if (ibiny[j3] >= ny) {
                        if (hInterpIndex[ibinx][1] == -1 || ibiny[j3] < hInterpIndex[ibinx][1]) {
                            hInterpData[ibinx][1] = z * w;
                            hInterpWeights[ibinx][1] = w;
                            hInterpIndex[ibinx][1] = ibiny[j3];
                            continue;
                        }
                        if (ibiny[j3] != hInterpIndex[ibinx][1]) continue;
                        double[] dArray = hInterpData[ibinx];
                        dArray[1] = dArray[1] + z * w;
                        double[] dArray5 = hInterpWeights[ibinx];
                        dArray5[1] = dArray5[1] + w;
                        continue;
                    }
                    double[] dArray = rebinData[ibinx];
                    int n = ibiny[j3];
                    dArray[n] = dArray[n] + z * w;
                    double[] dArray6 = rebinWeights[ibinx];
                    int n4 = ibiny[j3];
                    dArray6[n4] = dArray6[n4] + w;
                }
            }
        }
        AverageTableRebinner.multiplyWeights(rebinData, rebinWeights, zUnits);
        AverageTableRebinner.multiplyWeights(hInterpData, hInterpWeights, zUnits);
        AverageTableRebinner.multiplyWeights(vInterpData, vInterpWeights, zUnits);
        for (i = 0; i < nx; ++i) {
            int j0;
            if (rebinWeights[i][0] == 0.0 && hInterpWeights[i][0] != 0.0) {
                for (j0 = 0; j0 < ny && rebinWeights[i][j0] == 0.0; ++j0) {
                }
                if (j0 < ny) {
                    rebinData[i][0] = AverageTableRebinner.linearlyInterpolate(hInterpIndex[i][0], hInterpData[i][0], j0, rebinData[i][j0], 0);
                    rebinWeights[i][0] = AverageTableRebinner.linearlyInterpolate(hInterpIndex[i][0], hInterpWeights[i][0], j0, rebinWeights[i][j0], 0);
                }
            }
            if (rebinWeights[i][ny - 1] != 0.0 || hInterpWeights[i][1] == 0.0) continue;
            for (j0 = ny - 1; j0 >= 0 && rebinWeights[i][j0] == 0.0; --j0) {
            }
            if (j0 < 0) continue;
            rebinData[i][ny - 1] = AverageTableRebinner.linearlyInterpolate(j0, rebinData[i][j0], hInterpIndex[i][1], hInterpData[i][1], ny - 1);
            rebinWeights[i][ny - 1] = AverageTableRebinner.linearlyInterpolate(j0, rebinWeights[i][j0], hInterpIndex[i][1], hInterpWeights[i][1], ny - 1);
        }
        for (j = 0; j < ny; ++j) {
            int i0;
            if (rebinWeights[0][j] == 0.0 && vInterpWeights[0][j] != 0.0) {
                for (i0 = 0; i0 < nx && rebinWeights[i0][j] == 0.0; ++i0) {
                }
                if (i0 < nx) {
                    rebinData[0][j] = AverageTableRebinner.linearlyInterpolate(vInterpIndex[0][j], vInterpData[0][j], i0, rebinData[i0][j], 0);
                    rebinWeights[0][j] = AverageTableRebinner.linearlyInterpolate(vInterpIndex[0][j], vInterpWeights[0][j], i0, rebinWeights[i0][j], 0);
                }
            }
            if (rebinWeights[nx - 1][j] != 0.0 || vInterpWeights[1][j] == 0.0) continue;
            for (i0 = nx - 1; i0 >= 0 && rebinWeights[i0][j] == 0.0; --i0) {
            }
            if (i0 < 0) continue;
            rebinData[nx - 1][j] = AverageTableRebinner.linearlyInterpolate(i0, rebinData[i0][j], vInterpIndex[1][j], vInterpData[1][j], nx - 1);
            rebinWeights[nx - 1][j] = AverageTableRebinner.linearlyInterpolate(i0, rebinWeights[i0][j], vInterpIndex[1][j], vInterpWeights[1][j], nx - 1);
        }
    }

    private static double linearlyInterpolate(int i0, double z0, int i1, double z1, int i) {
        double r = (double)(i - i0) / (double)(i1 - i0);
        return z0 + r * (z1 - z0);
    }

    private static void multiplyWeights(double[][] data, double[][] weights, Units zUnits) {
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                data[i][j] = weights[i][j] > 0.0 ? data[i][j] / weights[i][j] : zUnits.getFillDouble();
            }
        }
    }

    static void fillInterpolateX(double[][] data, double[][] weights, double[] xTags, double xSampleWidth) {
        int nx = xTags.length;
        int ny = data[0].length;
        int[] i1 = new int[nx];
        int[] i2 = new int[nx];
        for (int j = 0; j < ny; ++j) {
            int i;
            int ii1 = -1;
            int ii2 = -1;
            for (i = 0; i < nx; ++i) {
                if (weights[i][j] > 0.0 && ii1 == i - 1) {
                    i1[i] = -1;
                    i2[i] = -1;
                    ii1 = i;
                    continue;
                }
                if (weights[i][j] > 0.0 && ii1 == -1) {
                    i1[i] = -1;
                    i2[i] = -1;
                    ii1 = i;
                    continue;
                }
                if (weights[i][j] > 0.0 && ii1 < i - 1) {
                    if (ii1 <= -1) continue;
                    i1[i] = -1;
                    i2[i] = -1;
                    for (int ii = i - 1; ii >= ii1; --ii) {
                        ii2 = i;
                        i1[ii] = ii1;
                        i2[ii] = ii2;
                    }
                    ii1 = i;
                    continue;
                }
                i1[i] = -1;
                i2[i] = -1;
            }
            for (i = 0; i < nx; ++i) {
                if (i1[i] == -1 || !(xTags[i2[i]] - xTags[i1[i]] < xSampleWidth * 1.5)) continue;
                double a2 = (float)((xTags[i] - xTags[i1[i]]) / (xTags[i2[i]] - xTags[i1[i]]));
                double a1 = 1.0 - a2;
                data[i][j] = data[i1[i]][j] * a1 + data[i2[i]][j] * a2;
                weights[i][j] = weights[i1[i]][j] * a1 + weights[i2[i]][j] * a2;
            }
        }
    }

    static void fillInterpolateY(double[][] data, double[][] weights, double[] yTags, double ySampleWidth, boolean log) {
        int j;
        int nx = data.length;
        int ny = yTags.length;
        int[] i1 = new int[ny];
        int[] i2 = new int[ny];
        double[] y_temp = new double[yTags.length];
        if (log) {
            for (j = 0; j < ny; ++j) {
                y_temp[j] = Math.log(yTags[j]);
            }
        } else {
            for (j = 0; j < ny; ++j) {
                y_temp[j] = yTags[j];
            }
        }
        for (int i = 0; i < nx; ++i) {
            int j2;
            int ii1 = -1;
            int ii2 = -1;
            for (j2 = 0; j2 < ny; ++j2) {
                if (weights[i][j2] > 0.0 && ii1 == j2 - 1) {
                    i1[j2] = -1;
                    i2[j2] = -1;
                    ii1 = j2;
                    continue;
                }
                if (weights[i][j2] > 0.0 && ii1 == -1) {
                    i1[j2] = -1;
                    i2[j2] = -1;
                    ii1 = j2;
                    continue;
                }
                if (weights[i][j2] > 0.0 && ii1 < j2 - 1) {
                    if (ii1 <= -1) continue;
                    i1[j2] = -1;
                    i2[j2] = -1;
                    for (int jj = j2 - 1; jj >= ii1; --jj) {
                        ii2 = j2;
                        i1[jj] = ii1;
                        i2[jj] = ii2;
                    }
                    ii1 = j2;
                    continue;
                }
                i1[j2] = -1;
                i2[j2] = -1;
            }
            for (j2 = 0; j2 < ny; ++j2) {
                if (i1[j2] == -1 || !(yTags[i2[j2]] - yTags[i1[j2]] < ySampleWidth * 1.5)) continue;
                float a2 = (float)((y_temp[j2] - y_temp[i1[j2]]) / (y_temp[i2[j2]] - y_temp[i1[j2]]));
                float a1 = 1.0f - a2;
                data[i][j2] = data[i][i1[j2]] * (double)a1 + data[i][i2[j2]] * (double)a2;
                weights[i][j2] = weights[i][i1[j2]] * (double)a1 + weights[i][i2[j2]] * (double)a2;
            }
        }
    }

    private void enlargePixels(double[][] rebinData, double[][] rebinWeights) {
        int ii;
        int jj;
        int jj2;
        int ii2;
        for (ii2 = 0; ii2 < rebinData.length - 1; ++ii2) {
            for (jj2 = 0; jj2 < rebinData[0].length; ++jj2) {
                if (rebinWeights[ii2][jj2] != 0.0) continue;
                rebinData[ii2][jj2] = rebinData[ii2 + 1][jj2];
                rebinWeights[ii2][jj2] = rebinWeights[ii2 + 1][jj2];
            }
        }
        for (ii2 = rebinData.length - 1; ii2 > 0; --ii2) {
            for (jj2 = 0; jj2 < rebinData[0].length; ++jj2) {
                if (rebinWeights[ii2][jj2] != 0.0) continue;
                rebinData[ii2][jj2] = rebinData[ii2 - 1][jj2];
                rebinWeights[ii2][jj2] = rebinWeights[ii2 - 1][jj2];
            }
        }
        for (jj = 0; jj < rebinData[0].length - 1; ++jj) {
            for (ii = 0; ii < rebinData.length; ++ii) {
                if (rebinWeights[ii][jj] != 0.0) continue;
                rebinData[ii][jj] = rebinData[ii][jj + 1];
                rebinWeights[ii][jj] = rebinWeights[ii][jj + 1];
            }
        }
        for (jj = rebinData[0].length - 1; jj > 0; --jj) {
            for (ii = 0; ii < rebinData.length; ++ii) {
                if (rebinWeights[ii][jj] != 0.0) continue;
                rebinData[ii][jj] = rebinData[ii][jj - 1];
                rebinWeights[ii][jj] = rebinWeights[ii][jj - 1];
            }
        }
    }

    public boolean isInterpolate() {
        return this.interpolate;
    }

    public void setInterpolate(boolean interpolate) {
        this.interpolate = interpolate;
    }

    public void setEnlargePixels(boolean enlargePixels) {
        this.enlargePixels = enlargePixels;
    }

    public boolean isEnlargePixels() {
        return this.enlargePixels;
    }
}

