/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.AverageTableRebinner;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetRebinner;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet;
import edu.uiowa.physics.pw.das.dataset.PeakTableRebinner;
import edu.uiowa.physics.pw.das.dataset.RebinDescriptor;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import java.util.Collections;

public class AveragePeakTableRebinner
implements DataSetRebinner {
    private boolean debug = false;

    public DataSet rebin(DataSet ds, RebinDescriptor ddX, RebinDescriptor ddY) throws IllegalArgumentException {
        Object yTags;
        double[] xTags;
        if (!(ds instanceof TableDataSet)) {
            throw new IllegalArgumentException();
        }
        TableDataSet tds = (TableDataSet)ds;
        TableDataSet weights = (TableDataSet)ds.getPlanarView("weights");
        TableDataSet peaks = (TableDataSet)ds.getPlanarView("peaks");
        long timer = System.currentTimeMillis();
        int nx = ddX == null ? tds.getXLength() : ddX.numberOfBins();
        int ny = ddY == null ? tds.getYLength(0) : ddY.numberOfBins();
        double[][] averageData = new double[nx][ny];
        double[][] averageWeights = new double[nx][ny];
        double[][] peakData = new double[nx][ny];
        AverageTableRebinner.average(tds, weights, averageData, averageWeights, ddX, ddY);
        if (ddX != null) {
            xTags = ddX.binCenters();
        } else {
            xTags = new double[nx];
            for (int i = 0; i < nx; ++i) {
                xTags[i] = tds.getXTagDouble(i, tds.getXUnits());
            }
        }
        if (ddY != null) {
            yTags = new double[][]{ddY.binCenters()};
        } else {
            yTags = new double[1][ny];
            for (int j = 0; j < ny; ++j) {
                yTags[0][j] = tds.getYTagDouble(0, j, tds.getYUnits());
            }
        }
        Datum xTagWidth = (Datum)ds.getProperty("xTagWidth");
        if (xTagWidth == null) {
            xTagWidth = DataSetUtil.guessXTagWidth(tds);
        }
        double xTagWidthDouble = xTagWidth.doubleValue(ddX.getUnits().getOffsetUnits());
        AverageTableRebinner.fillInterpolateX(averageData, averageWeights, xTags, xTagWidthDouble);
        if (ddY != null) {
            AverageTableRebinner.fillInterpolateY(averageData, averageWeights, yTags[0], Double.POSITIVE_INFINITY, ddY == null ? false : ddY.isLog());
        }
        if (peaks == null) {
            PeakTableRebinner.peaks(tds, peakData, ddX, ddY);
        } else {
            PeakTableRebinner.peaks(peaks, peakData, ddX, ddY);
        }
        int[] tableOffsets = new int[]{0};
        String[] planeIDs = new String[]{"", "peaks", "weights"};
        double[][][] zValues = new double[][][]{averageData, peakData, averageWeights};
        Units[] zUnits = new Units[]{tds.getZUnits(), tds.getZUnits(), Units.dimensionless};
        return new DefaultTableDataSet(xTags, tds.getXUnits(), (double[][])yTags, tds.getYUnits(), (double[][][])zValues, zUnits, planeIDs, tableOffsets, Collections.EMPTY_MAP);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

