/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dasml;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.dasml.CommandAction;
import edu.uiowa.physics.pw.das.dasml.CommandBlock;
import edu.uiowa.physics.pw.das.dasml.DefaultComponentDnDSupport;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dasml.FormComponent;
import edu.uiowa.physics.pw.das.dasml.ListOption;
import edu.uiowa.physics.pw.das.dasml.OptionList;
import edu.uiowa.physics.pw.das.dasml.ParsedExpressionException;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DnDSupport;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FormChoice
extends JComboBox
implements Editable,
FormComponent,
OptionList {
    protected DnDSupport dndSupport;
    private boolean editable;
    private String dasName;

    public FormChoice(String name) {
        if (name == null) {
            name = "choice_" + Integer.toString(System.identityHashCode(this));
        }
        try {
            this.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle(dne);
        }
    }

    FormChoice(Element element, FormBase form) throws DasPropertyException, DasNameException, ParsedExpressionException {
        String name = element.getAttribute("name");
        NodeList children = element.getChildNodes();
        int childCount = children.getLength();
        for (int i = 0; i < childCount; ++i) {
            Node node = children.item(i);
            if (node instanceof Element && node.getNodeName().equals("option")) {
                this.processOptionElement((Element)node);
                continue;
            }
            if (!(node instanceof Element) || !node.getNodeName().equals("action")) continue;
            CommandBlock cb = new CommandBlock((Element)node, form);
            CommandAction action = new CommandAction(cb);
            this.addActionListener(action);
        }
        try {
            this.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle(dne);
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private void processOptionElement(Element element) {
        boolean selected = element.getAttribute("selected").equals("true");
        ListOption option = new ListOption(element);
        this.addItem(option);
        if (selected) {
            this.setSelectedItem(option);
        }
    }

    public String getSelectedValue() {
        ListOption selected = (ListOption)this.getSelectedItem();
        if (selected == null) {
            return null;
        }
        return selected.getValue();
    }

    public void addOption(ListOption option) {
        this.addItem(option);
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("choice");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("enabled", String.valueOf(this.isEnabled()));
        for (int index = 0; index < this.getItemCount(); ++index) {
            ListOption option = (ListOption)this.getItemAt(index);
            element.appendChild(option.getDOMElement(document));
        }
        return element;
    }

    public ListOption[] getOptions() {
        ComboBoxModel model = this.getModel();
        ListOption[] options = new ListOption[model.getSize()];
        for (int index = 0; index < options.length; ++index) {
            options[index] = (ListOption)model.getElementAt(index);
        }
        return options;
    }

    public void setOptions(ListOption[] options) {
        this.setModel(new DefaultComboBoxModel<ListOption>(options));
        if (options.length == 0) {
            this.setSelectedItem(null);
        } else {
            this.setSelectedItem(options[0]);
            for (int index = 0; index < options.length; ++index) {
                if (!options[index].isSelected()) continue;
                this.setSelectedItem(options[index]);
            }
        }
    }

    public Object getPrototypeDisplayValue() {
        if (this.getItemCount() == 0) {
            return "XXXXXXXXXXXX";
        }
        return null;
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String name) throws DasNameException {
        if (name.equals(this.dasName)) {
            return;
        }
        String oldName = this.dasName;
        this.dasName = name;
        DasApplication app = this.getDasApplication();
        if (app != null) {
            app.getNameContext().put(name, this);
            if (oldName != null) {
                app.getNameContext().remove(oldName);
            }
        }
        this.firePropertyChange("name", oldName, name);
    }

    public FormBase getForm() {
        FormComponent parent = (FormComponent)((Object)this.getParent());
        if (parent == null) {
            return null;
        }
        return parent.getForm();
    }

    public DnDSupport getDnDSupport() {
        if (this.dndSupport == null) {
            this.dndSupport = new DefaultComponentDnDSupport(this);
        }
        return this.dndSupport;
    }

    public boolean startDrag(int x, int y, int action, MouseEvent evt) {
        return false;
    }

    public boolean getEditingMode() {
        return this.editable;
    }

    public void setEditingMode(boolean b) {
        this.editable = b;
    }

    public void deregisterComponent() {
        DasApplication app = this.getDasApplication();
        if (app != null) {
            NameContext nc = app.getNameContext();
            try {
                if (nc.get(this.getDasName()) == this) {
                    nc.remove(this.getDasName());
                }
            }
            catch (DasPropertyException dpe) {
                IllegalStateException se = new IllegalStateException(dpe.toString());
                se.initCause(dpe);
                throw se;
            }
            catch (InvocationTargetException ite) {
                IllegalStateException se = new IllegalStateException(ite.toString());
                se.initCause(ite);
                throw se;
            }
        }
    }

    public DasApplication getDasApplication() {
        Container p = this.getParent();
        if (p instanceof FormComponent) {
            return ((FormComponent)((Object)p)).getDasApplication();
        }
        return null;
    }

    public void registerComponent() throws DasException {
        DasApplication app = this.getDasApplication();
        if (app != null) {
            NameContext nc = app.getNameContext();
            nc.put(this.getDasName(), this);
        }
    }
}

