/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dasml;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.dasml.CommandAction;
import edu.uiowa.physics.pw.das.dasml.CommandBlock;
import edu.uiowa.physics.pw.das.dasml.DefaultComponentDnDSupport;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dasml.FormComponent;
import edu.uiowa.physics.pw.das.dasml.ParsedExpressionException;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DnDSupport;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JCheckBox;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FormCheckBox
extends JCheckBox
implements Editable,
FormComponent {
    CommandAction commandAction;
    CommandBlock commandBlock;
    private String dasName;
    protected DnDSupport dndSupport;
    private boolean editable;

    public FormCheckBox(String name, String label) {
        super(label);
        if (name == null) {
            name = "checkbox_" + Integer.toHexString(System.identityHashCode(this));
        }
        try {
            this.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle(dne);
        }
    }

    FormCheckBox(Element element, FormBase form) throws DasPropertyException, ParsedExpressionException, DasNameException {
        String name = element.getAttribute("name");
        String label = element.getAttribute("label");
        boolean enabled = element.getAttribute("enabled").equals("true");
        boolean selected = element.getAttribute("selected").equals("true");
        this.setText(label);
        this.setEnabled(enabled);
        this.setSelected(selected);
        try {
            this.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle(dne);
        }
        NodeList children = element.getChildNodes();
        int childCount = children.getLength();
        for (int index = 0; index < childCount; ++index) {
            Node node = children.item(index);
            if (!(node instanceof Element) || !node.getNodeName().equals("action")) continue;
            this.commandBlock = new CommandBlock((Element)node, form);
            this.commandAction = new CommandAction(this.commandBlock);
            this.addActionListener(this.commandAction);
        }
    }

    public CommandBlock getFormAction() {
        return this.commandBlock;
    }

    public void setFormAction(CommandBlock cb) {
        if (cb == this.commandBlock) {
            return;
        }
        if (this.commandBlock != null) {
            this.removeActionListener(this.commandAction);
        }
        if (cb == null) {
            this.commandAction = null;
            this.commandBlock = null;
        } else {
            this.commandBlock = cb;
            this.commandAction = new CommandAction(this.commandBlock);
            this.addActionListener(this.commandAction);
        }
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("checkbox");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("enabled", String.valueOf(this.isEnabled()));
        element.setAttribute("selected", String.valueOf(this.isSelected()));
        element.setAttribute("label", this.getText());
        if (this.commandBlock != null) {
            Element commandElement = document.createElement("action");
            this.commandBlock.appendDOMElements(element);
        }
        return element;
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String name) throws DasNameException {
        if (name.equals(this.dasName)) {
            return;
        }
        String oldName = this.dasName;
        this.dasName = name;
        DasApplication app = this.getDasApplication();
        if (app != null) {
            app.getNameContext().put(name, this);
            if (oldName != null) {
                app.getNameContext().remove(oldName);
            }
        }
        this.firePropertyChange("name", oldName, name);
    }

    public FormBase getForm() {
        FormComponent parent = (FormComponent)((Object)this.getParent());
        if (parent == null) {
            return null;
        }
        return parent.getForm();
    }

    public boolean getEditingMode() {
        return this.editable;
    }

    public void setEditingMode(boolean b) {
        this.editable = b;
    }

    public DnDSupport getDnDSupport() {
        if (this.dndSupport == null) {
            this.dndSupport = new DefaultComponentDnDSupport(this);
        }
        return this.dndSupport;
    }

    public boolean startDrag(int x, int y, int action, MouseEvent evt) {
        return false;
    }

    public void deregisterComponent() {
        DasApplication app = this.getDasApplication();
        if (app != null) {
            NameContext nc = app.getNameContext();
            try {
                if (nc.get(this.getDasName()) == this) {
                    nc.remove(this.getDasName());
                }
            }
            catch (DasPropertyException dpe) {
                IllegalStateException se = new IllegalStateException(dpe.toString());
                se.initCause(dpe);
                throw se;
            }
            catch (InvocationTargetException ite) {
                IllegalStateException se = new IllegalStateException(ite.toString());
                se.initCause(ite);
                throw se;
            }
        }
    }

    public DasApplication getDasApplication() {
        Container p = this.getParent();
        if (p instanceof FormComponent) {
            return ((FormComponent)((Object)p)).getDasApplication();
        }
        return null;
    }

    public void registerComponent() throws DasException {
        DasApplication app = this.getDasApplication();
        if (app != null) {
            NameContext nc = app.getNameContext();
            nc.put(this.getDasName(), this);
        }
    }
}

