/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dasml;

import edu.uiowa.physics.pw.das.dasml.CommandBlock;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class CommandBlockEditor
extends JButton
implements TableCellEditor,
PropertyEditor {
    EventListenerList listenerList = new EventListenerList();
    JDialog dialog;
    JPanel contentPanel;
    JCheckBox enable;
    JTree commandTree;
    CommandBlockTreeModel commandBlockTreeModel;
    MultiPurposeListener listener = new MultiPurposeListener();
    JButton commitChanges;
    JButton cancelEdit;
    JPanel editorPanel;
    CardLayout switcher;
    JTextField x1Field;
    JLabel x1FieldLabel;
    JButton x1Commit;
    JButton x1Cancel;
    JTextField x2Field1;
    JTextField x2Field2;
    JLabel x2Field1Label;
    JLabel x2Field2Label;
    JButton x2Commit;
    JButton x2Cancel;
    JButton newCommand;
    JButton editCommand;
    JButton removeCommand;
    JButton moveUpCommand;
    JButton moveDownCommand;
    CommandBlock commandBlock;
    static /* synthetic */ Class class$javax$swing$event$CellEditorListener;
    static /* synthetic */ Class class$javax$swing$event$TreeModelListener;

    public CommandBlockEditor() {
        super("edit");
        this.addActionListener(this.listener);
        this.commandBlockTreeModel = new CommandBlockTreeModel(new CommandBlock());
        this.commandTree = new JTree(this.commandBlockTreeModel);
        this.commandTree.setRootVisible(true);
        this.commandTree.setShowsRootHandles(false);
        this.commandTree.getSelectionModel().setSelectionMode(1);
        this.commandTree.setVisibleRowCount(10);
        this.commandTree.setCellRenderer(new CommandRenderer());
        this.contentPanel = new JPanel(new BorderLayout());
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)new JScrollPane(this.commandTree, 22, 32), "Center");
        this.editorPanel = this.initEditorPanels();
        centerPanel.add((Component)this.editorPanel, "South");
        centerPanel.add((Component)this.initButtonPanel(), "East");
        this.contentPanel.add((Component)centerPanel, "Center");
        this.enable = new JCheckBox("Enabled", false);
        this.setTopEnabled(false);
        this.enable.addActionListener(this.listener);
        this.contentPanel.add((Component)this.enable, "North");
        JPanel dialogButtons = new JPanel(new FlowLayout(2));
        this.commitChanges = new JButton("Commit Changes");
        this.commitChanges.addActionListener(this.listener);
        this.cancelEdit = new JButton("Cancel Changes");
        this.cancelEdit.addActionListener(this.listener);
        dialogButtons.add(this.commitChanges);
        dialogButtons.add(this.cancelEdit);
        this.contentPanel.add((Component)dialogButtons, "South");
    }

    private JPanel initButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.newCommand = new JButton("new");
        this.editCommand = new JButton("edit");
        this.removeCommand = new JButton("remove");
        this.moveUpCommand = new JButton("move up");
        this.moveDownCommand = new JButton("move down");
        Dimension d = this.moveDownCommand.getPreferredSize();
        this.newCommand.setPreferredSize(d);
        this.newCommand.setMaximumSize(d);
        this.editCommand.setPreferredSize(d);
        this.editCommand.setMaximumSize(d);
        this.removeCommand.setPreferredSize(d);
        this.removeCommand.setMaximumSize(d);
        this.moveUpCommand.setPreferredSize(d);
        this.moveUpCommand.setMaximumSize(d);
        this.newCommand.addActionListener(this.listener);
        this.editCommand.addActionListener(this.listener);
        this.removeCommand.addActionListener(this.listener);
        this.moveUpCommand.addActionListener(this.listener);
        this.moveDownCommand.addActionListener(this.listener);
        panel.add(this.newCommand);
        panel.add(this.editCommand);
        panel.add(this.removeCommand);
        panel.add(this.moveUpCommand);
        panel.add(this.moveDownCommand);
        return panel;
    }

    void addCommand(CommandBlock.Command c) {
        int index;
        CommandBlock parent;
        TreePath selection = this.commandTree.getSelectionPath();
        if (selection == null) {
            parent = this.commandBlock;
            index = parent.commandList.size();
        } else if (selection.getLastPathComponent() instanceof CommandBlock) {
            parent = (CommandBlock)selection.getLastPathComponent();
            index = parent.commandList.size();
        } else {
            CommandBlock.Command item = (CommandBlock.Command)selection.getLastPathComponent();
            parent = item.getParent();
            index = parent.indexOf(item) + 1;
        }
        parent.insertCommand(c, index);
        Object[] path = this.commandBlockTreeModel.getPathToNode(parent);
        this.commandBlockTreeModel.fireTreeNodeInserted(path, index, c);
    }

    void removeCommands(TreePath[] selection) {
        HashMap<TreePath, ArrayList<Object>> map = new HashMap<TreePath, ArrayList<Object>>();
        for (int i = 0; i < selection.length; ++i) {
            if (selection[i].getPathCount() == 1) continue;
            TreePath parent = selection[i].getParentPath();
            Object child = selection[i].getLastPathComponent();
            ArrayList<Object> l = (ArrayList<Object>)map.get(parent);
            if (l == null) {
                l = new ArrayList<Object>();
                map.put(parent, l);
            }
            l.add(child);
        }
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            TreePath parent = (TreePath)entry.getKey();
            List list = (List)entry.getValue();
            Object[] children = new CommandBlock.Command[list.size()];
            list.toArray(children);
            int[] indices = new int[children.length];
            for (int index = 0; index < children.length; ++index) {
                indices[index] = children[index].getParent().indexOf((CommandBlock.Command)children[index]);
                children[index].getParent().removeCommand((CommandBlock.Command)children[index]);
            }
            this.commandBlockTreeModel.fireTreeNodesRemoved(parent, indices, children);
        }
    }

    private JPanel initEditorPanels() {
        this.switcher = new CardLayout();
        JPanel panel = new JPanel(this.switcher);
        panel.setBorder(new CompoundBorder(new CompoundBorder(new EmptyBorder(2, 2, 2, 2), new EtchedBorder()), new EmptyBorder(2, 2, 2, 2)));
        JPanel emptyPanel = new JPanel();
        panel.add((Component)emptyPanel, "EMPTY");
        JPanel singlePanel = new JPanel();
        singlePanel.setLayout(new BoxLayout(singlePanel, 1));
        this.x1Field = new JTextField(30);
        this.x1Field.setMaximumSize(this.x1Field.getPreferredSize());
        this.x1Field.setAlignmentX(0.0f);
        this.x1FieldLabel = new JLabel("field", 2);
        this.x1FieldLabel.setAlignmentX(0.0f);
        singlePanel.add(this.x1FieldLabel);
        singlePanel.add(this.x1Field);
        JPanel x1ButtonPanel = new JPanel(new FlowLayout(2));
        x1ButtonPanel.setAlignmentX(0.0f);
        this.x1Commit = new JButton("Commit Changes");
        this.x1Commit.addActionListener(this.listener);
        this.x1Cancel = new JButton("Cancel Changes");
        this.x1Cancel.addActionListener(this.listener);
        x1ButtonPanel.add(this.x1Commit);
        x1ButtonPanel.add(this.x1Cancel);
        singlePanel.add(Box.createVerticalGlue());
        singlePanel.add(x1ButtonPanel);
        panel.add((Component)singlePanel, "SINGLE");
        JPanel doublePanel = new JPanel();
        doublePanel.setLayout(new BoxLayout(doublePanel, 1));
        this.x2Field1 = new JTextField(30);
        this.x2Field1.setMaximumSize(this.x2Field1.getPreferredSize());
        this.x2Field1.setAlignmentX(0.0f);
        this.x2Field1Label = new JLabel("field1");
        this.x2Field1Label.setAlignmentX(0.0f);
        this.x2Field2 = new JTextField(30);
        this.x2Field2.setMaximumSize(this.x2Field2.getPreferredSize());
        this.x2Field2.setAlignmentX(0.0f);
        this.x2Field2Label = new JLabel("field2");
        this.x2Field2Label.setAlignmentX(0.0f);
        doublePanel.add(this.x2Field1Label);
        doublePanel.add(this.x2Field1);
        doublePanel.add(this.x2Field2Label);
        doublePanel.add(this.x2Field2);
        JPanel x2ButtonPanel = new JPanel(new FlowLayout(2));
        x2ButtonPanel.setAlignmentX(0.0f);
        this.x2Commit = new JButton("Commit Changes");
        this.x2Commit.addActionListener(this.listener);
        this.x2Cancel = new JButton("Cancel Changes");
        this.x2Cancel.addActionListener(this.listener);
        x2ButtonPanel.add(this.x2Commit);
        x2ButtonPanel.add(this.x2Cancel);
        doublePanel.add(Box.createVerticalGlue());
        doublePanel.add(x2ButtonPanel);
        panel.add((Component)doublePanel, "DOUBLE");
        return panel;
    }

    public void showDialog() {
        if (this.dialog == null) {
            Window w = SwingUtilities.windowForComponent(this);
            if (w instanceof Frame) {
                this.dialog = new JDialog((Frame)w, true);
            } else if (w instanceof Dialog) {
                this.dialog = new JDialog((Dialog)w, true);
            } else {
                this.dialog = new JDialog();
                this.dialog.setModal(true);
            }
            this.dialog.setContentPane(this.contentPanel);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.addWindowListener(this.listener);
        }
        this.dialog.setVisible(true);
    }

    public CommandBlock getCommandBlock() {
        if (this.enable.isSelected()) {
            return this.commandBlock;
        }
        return null;
    }

    public void setCommandBlock(CommandBlock commandBlock) {
        if (commandBlock == null) {
            commandBlock = new CommandBlock();
            this.enable.setSelected(false);
            this.setTopEnabled(false);
        } else {
            this.enable.setSelected(true);
            this.setTopEnabled(true);
        }
        this.commandBlock = commandBlock;
        this.commandBlockTreeModel.root = commandBlock;
        this.commandBlockTreeModel.fireTreeChanged();
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        this.dialog.setVisible(false);
        return true;
    }

    public void cancelCellEditing() {
        this.dialog.setVisible(false);
        this.fireEditingCanceled();
    }

    private void setTopEnabled(boolean b) {
        this.commandTree.setEnabled(b);
        this.newCommand.setEnabled(b);
        this.editCommand.setEnabled(b);
        this.removeCommand.setEnabled(b);
        this.moveUpCommand.setEnabled(b);
        this.moveDownCommand.setEnabled(b);
    }

    public static void main(String[] args) {
        CommandBlockEditor editor = new CommandBlockEditor();
        CommandBlock block = new CommandBlock();
        block.addCommand(new CommandBlock.SetCommand("property", "value"));
        block.addCommand(new CommandBlock.InvokeCommand("fred", new String[]{"arg1", "arg2"}));
        CommandBlock.IfCommand ifc = new CommandBlock.IfCommand("test");
        ifc.addCommand(new CommandBlock.SetCommand("fred", "larry"));
        block.addCommand(ifc);
        editor.setCommandBlock(block);
        JFrame frame = new JFrame();
        frame.setContentPane(editor);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.listenerList.add(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = CommandBlockEditor.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, l);
    }

    public Object getCellEditorValue() {
        return this.getCommandBlock();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setCommandBlock((CommandBlock)value);
        return this;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.listenerList.remove(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = CommandBlockEditor.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, l);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    private void fireEditingCanceled() {
        ChangeEvent e = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$CellEditorListener == null ? CommandBlockEditor.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) continue;
            if (e == null) {
                e = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingCanceled(e);
        }
    }

    private void fireEditingStopped() {
        ChangeEvent e = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$CellEditorListener == null ? CommandBlockEditor.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) continue;
            if (e == null) {
                e = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingStopped(e);
        }
    }

    public String getAsText() {
        return "dflkjd";
    }

    public Component getCustomEditor() {
        return this;
    }

    public String getJavaInitializationString() {
        return "???";
    }

    public String[] getTags() {
        return null;
    }

    public Object getValue() {
        return this.commandBlock;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public void setAsText(String text) throws IllegalArgumentException {
    }

    public void setValue(Object value) {
        this.setCommandBlock((CommandBlock)value);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CommandRenderer
    extends JLabel
    implements TreeCellRenderer {
        Color textForeground;
        Color textBackground;
        Color selectionForeground;
        Color selectionBackground;
        Border focusedBorder;
        Border unfocusedBorder;

        CommandRenderer() {
            this.setOpaque(true);
            this.textForeground = UIManager.getColor("Tree.textForeground");
            this.textBackground = UIManager.getColor("Tree.textBackground");
            this.selectionForeground = UIManager.getColor("Tree.selectionForeground");
            this.selectionBackground = UIManager.getColor("Tree.selectionBackground");
            this.focusedBorder = new LineBorder(UIManager.getColor("Tree.selectionBorderColor"));
            this.unfocusedBorder = new LineBorder(this.textBackground);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.setForeground(selected ? this.selectionForeground : this.textForeground);
            this.setBackground(selected ? this.selectionBackground : this.textBackground);
            this.setBorder(hasFocus ? this.focusedBorder : this.unfocusedBorder);
            if (!(value instanceof CommandBlock.Command)) {
                this.setText("[Command Block]");
            } else {
                this.setText(value.toString());
            }
            this.setEnabled(tree.isEnabled());
            return this;
        }
    }

    private static class CommandBlockTreeModel
    implements TreeModel {
        private EventListenerList eventListenerList;
        private CommandBlock root;

        CommandBlockTreeModel(CommandBlock root) {
            this.root = root;
        }

        public void addTreeModelListener(TreeModelListener l) {
            if (this.eventListenerList == null) {
                this.eventListenerList = new EventListenerList();
            }
            this.eventListenerList.add(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = CommandBlockEditor.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l);
        }

        public Object getChild(Object parent, int index) {
            if (parent instanceof CommandBlock) {
                return ((CommandBlock)parent).commandList.get(index);
            }
            return null;
        }

        public int getChildCount(Object parent) {
            if (parent instanceof CommandBlock) {
                return ((CommandBlock)parent).commandList.size();
            }
            return 0;
        }

        public int getIndexOfChild(Object parent, Object child) {
            if (parent instanceof CommandBlock) {
                return ((CommandBlock)parent).commandList.indexOf(child);
            }
            return -1;
        }

        public Object getRoot() {
            return this.root;
        }

        public boolean isLeaf(Object node) {
            return !(node instanceof CommandBlock);
        }

        public void removeTreeModelListener(TreeModelListener l) {
            if (this.eventListenerList != null) {
                this.eventListenerList.remove(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = CommandBlockEditor.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l);
            }
        }

        protected void fireTreeChanged() {
            TreeModelEvent evt = null;
            Object[] listeners = this.eventListenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? CommandBlockEditor.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
                if (evt == null) {
                    evt = new TreeModelEvent((Object)this, new Object[]{this.root});
                }
                ((TreeModelListener)listeners[i + 1]).treeStructureChanged(evt);
            }
        }

        protected void fireTreeNodesChanged(Object[] path, int index, Object child) {
            TreeModelEvent evt = null;
            Object[] listeners = this.eventListenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? CommandBlockEditor.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
                if (evt == null) {
                    evt = new TreeModelEvent((Object)this, path, new int[]{index}, new Object[]{child});
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesChanged(evt);
            }
        }

        protected void fireTreeNodeInserted(Object[] path, int index, Object child) {
            TreeModelEvent evt = null;
            Object[] listeners = this.eventListenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? CommandBlockEditor.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
                if (evt == null) {
                    evt = new TreeModelEvent((Object)this, path, new int[]{index}, new Object[]{child});
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesInserted(evt);
            }
        }

        protected void fireTreeNodesRemoved(TreePath parent, int[] indices, Object[] children) {
            TreeModelEvent evt = null;
            Object[] listeners = this.eventListenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? CommandBlockEditor.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
                if (evt == null) {
                    evt = new TreeModelEvent((Object)this, parent, indices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(evt);
            }
        }

        protected void fireTreeStructureChanged(Object[] path) {
            TreeModelEvent evt = null;
            Object[] listeners = this.eventListenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? CommandBlockEditor.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
                if (evt == null) {
                    evt = new TreeModelEvent((Object)this, path);
                }
                ((TreeModelListener)listeners[i + 1]).treeStructureChanged(evt);
            }
        }

        Object[] getPathToNode(Object node) {
            if (!(node instanceof CommandBlock.Command)) {
                return new Object[]{node};
            }
            CommandBlock.Command command = (CommandBlock.Command)node;
            CommandBlock parent = command.getParent();
            int count = 2;
            while (parent instanceof CommandBlock.Command) {
                parent = ((CommandBlock.Command)((Object)parent)).getParent();
                ++count;
            }
            Object[] path = new Object[count];
            parent = command.getParent();
            path[count - 1] = node;
            path[count - 2] = parent;
            int index = count - 2;
            while (parent instanceof CommandBlock.Command) {
                parent = ((CommandBlock.Command)((Object)parent)).getParent();
                path[--index] = parent;
            }
            System.out.println(Arrays.asList(path));
            return path;
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }
    }

    private class MultiPurposeListener
    extends WindowAdapter
    implements ActionListener {
        final JPopupMenu newCommandMenu = new JPopupMenu("new command");

        private MultiPurposeListener() {
            this.newCommandMenu.add("SET").addActionListener(this);
            this.newCommandMenu.add("INVOKE").addActionListener(this);
            this.newCommandMenu.add("IF").addActionListener(this);
            this.newCommandMenu.add("ELSEIF").addActionListener(this);
            this.newCommandMenu.add("ELSE").addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            String command = e.getActionCommand();
            if (source == CommandBlockEditor.this) {
                CommandBlockEditor.this.showDialog();
            } else if (source == CommandBlockEditor.this.commitChanges) {
                CommandBlockEditor.this.stopCellEditing();
            } else if (source == CommandBlockEditor.this.cancelEdit) {
                CommandBlockEditor.this.cancelCellEditing();
            } else if (source == CommandBlockEditor.this.enable) {
                CommandBlockEditor.this.switcher.show(CommandBlockEditor.this.editorPanel, "EMPTY");
                CommandBlockEditor.this.setTopEnabled(CommandBlockEditor.this.enable.isSelected());
            } else if (source == CommandBlockEditor.this.newCommand) {
                this.newCommandMenu.show(CommandBlockEditor.this.newCommand, CommandBlockEditor.this.newCommand.getWidth(), 0);
            } else if (source == CommandBlockEditor.this.editCommand) {
                TreePath selection = CommandBlockEditor.this.commandTree.getSelectionPath();
                if (selection != null && selection.getPathCount() != 1) {
                    Object o = selection.getLastPathComponent();
                    if (o instanceof CommandBlock.SetCommand) {
                        CommandBlock.SetCommand c = (CommandBlock.SetCommand)o;
                        CommandBlockEditor.this.x2Field1Label.setText("Property");
                        CommandBlockEditor.this.x2Field1.setText(c.id);
                        CommandBlockEditor.this.x2Field2Label.setText("Value");
                        CommandBlockEditor.this.x2Field2.setText(c.value);
                        CommandBlockEditor.this.switcher.show(CommandBlockEditor.this.editorPanel, "DOUBLE");
                        this.setEditing(true);
                    } else if (o instanceof CommandBlock.InvokeCommand) {
                        CommandBlock.InvokeCommand c = (CommandBlock.InvokeCommand)o;
                        CommandBlockEditor.this.x2Field1Label.setText("Method");
                        CommandBlockEditor.this.x2Field1.setText(c.target);
                        CommandBlockEditor.this.x2Field2Label.setText("Arguments (comma separated)");
                        if (c.args != null) {
                            String args = Arrays.asList(c.args).toString();
                            CommandBlockEditor.this.x2Field2.setText(args.substring(1, args.length() - 1));
                        } else {
                            CommandBlockEditor.this.x2Field2.setText("");
                        }
                        CommandBlockEditor.this.switcher.show(CommandBlockEditor.this.editorPanel, "DOUBLE");
                        this.setEditing(true);
                    } else {
                        if (o instanceof CommandBlock.ElseCommand) {
                            return;
                        }
                        if (o instanceof CommandBlock.IfCommand) {
                            CommandBlock.IfCommand c = (CommandBlock.IfCommand)o;
                            CommandBlockEditor.this.x1FieldLabel.setText("Test");
                            CommandBlockEditor.this.x1Field.setText(c.test);
                            CommandBlockEditor.this.switcher.show(CommandBlockEditor.this.editorPanel, "SINGLE");
                            this.setEditing(true);
                        }
                    }
                }
            } else if (source == CommandBlockEditor.this.removeCommand) {
                TreePath[] selection = CommandBlockEditor.this.commandTree.getSelectionPaths();
                if (selection != null) {
                    CommandBlockEditor.this.removeCommands(selection);
                }
            } else if (source == CommandBlockEditor.this.moveUpCommand) {
                TreePath selection = CommandBlockEditor.this.commandTree.getSelectionPath();
                if (selection == null || selection.getPathCount() == 1) {
                    return;
                }
                CommandBlock.Command c = (CommandBlock.Command)selection.getLastPathComponent();
                CommandBlock parent = c.getParent();
                int index = parent.indexOf(c);
                if (index == 0) {
                    return;
                }
                CommandBlockEditor.this.removeCommands(new TreePath[]{selection});
                parent.insertCommand(c, index - 1);
                CommandBlockEditor.this.commandBlockTreeModel.fireTreeNodeInserted(selection.getParentPath().getPath(), index - 1, c);
            } else if (source == CommandBlockEditor.this.moveDownCommand) {
                TreePath selection = CommandBlockEditor.this.commandTree.getSelectionPath();
                if (selection == null || selection.getPathCount() == 1) {
                    return;
                }
                CommandBlock.Command c = (CommandBlock.Command)selection.getLastPathComponent();
                CommandBlock parent = c.getParent();
                int index = parent.indexOf(c);
                if (index == parent.commandList.size() - 1) {
                    return;
                }
                CommandBlockEditor.this.removeCommands(new TreePath[]{selection});
                parent.insertCommand(c, index + 1);
                CommandBlockEditor.this.commandBlockTreeModel.fireTreeNodeInserted(selection.getParentPath().getPath(), index + 1, c);
            } else if (source == CommandBlockEditor.this.x1Commit) {
                TreePath selection = CommandBlockEditor.this.commandTree.getSelectionPath();
                Object node = selection.getLastPathComponent();
                CommandBlock.IfCommand c = (CommandBlock.IfCommand)node;
                c.test = CommandBlockEditor.this.x1Field.getText();
                this.setEditing(false);
            } else if (source == CommandBlockEditor.this.x2Commit) {
                TreePath selection = CommandBlockEditor.this.commandTree.getSelectionPath();
                Object node = selection.getLastPathComponent();
                if (node instanceof CommandBlock.SetCommand) {
                    CommandBlock.SetCommand c = (CommandBlock.SetCommand)node;
                    c.id = CommandBlockEditor.this.x2Field1.getText();
                    c.value = CommandBlockEditor.this.x2Field2.getText();
                    this.setEditing(false);
                } else {
                    CommandBlock.InvokeCommand c = (CommandBlock.InvokeCommand)node;
                    c.target = CommandBlockEditor.this.x2Field1.getText();
                    c.args = CommandBlockEditor.this.x2Field2.getText().split("\\s*,\\s*");
                    this.setEditing(false);
                }
            } else if (source == CommandBlockEditor.this.x1Cancel || source == CommandBlockEditor.this.x2Cancel) {
                this.setEditing(false);
            } else if (command.equals("SET")) {
                CommandBlockEditor.this.addCommand(new CommandBlock.SetCommand("property", "value"));
            } else if (command.equals("INVOKE")) {
                CommandBlockEditor.this.addCommand(new CommandBlock.InvokeCommand("object.method", null));
            } else if (command.equals("IF")) {
                CommandBlockEditor.this.addCommand(new CommandBlock.IfCommand("test"));
            } else if (command.equals("ELSEIF")) {
                CommandBlockEditor.this.addCommand(new CommandBlock.ElseIfCommand("test"));
            } else if (command.equals("ELSE")) {
                CommandBlockEditor.this.addCommand(new CommandBlock.ElseCommand());
            }
        }

        public void windowClosing(WindowEvent e) {
            CommandBlockEditor.this.cancelCellEditing();
        }

        private void setEditing(boolean b) {
            boolean bl = b = !b;
            if (b) {
                CommandBlockEditor.this.switcher.show(CommandBlockEditor.this.editorPanel, "EMPTY");
            }
            CommandBlockEditor.this.setTopEnabled(b);
            CommandBlockEditor.this.enable.setEnabled(b);
            TreePath selection = CommandBlockEditor.this.commandTree.getSelectionPath();
            CommandBlock.Command c = (CommandBlock.Command)selection.getLastPathComponent();
            int index = c.getParent().indexOf(c);
            CommandBlockEditor.this.commandBlockTreeModel.fireTreeNodesChanged(selection.getParentPath().getPath(), index, c);
        }
    }
}

