/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components.propertyeditor;

import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyCellEditor;
import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyCellRenderer;
import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyTreeNode;
import edu.uiowa.physics.pw.das.components.treetable.TreeTableCellRenderer;
import edu.uiowa.physics.pw.das.components.treetable.TreeTableModel;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;

public class PropertyEditor
extends JPanel {
    JTable table;
    JButton closeButton;
    JDialog dialog;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$awt$Window;

    public PropertyEditor(Editable e) {
        super(new BorderLayout());
        PropertyTreeNode root = new PropertyTreeNode(e);
        DefaultTreeModel treeModel = new DefaultTreeModel(root, true);
        TreeTableCellRenderer tree = new TreeTableCellRenderer(treeModel);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(false);
        TreeTableModel model = new TreeTableModel(root, tree);
        this.table = new JTable(model);
        this.add((Component)new JScrollPane(this.table, 20, 30), "Center");
        this.initButtonPanel();
        PropertyCellRenderer valueRenderer = new PropertyCellRenderer();
        PropertyCellEditor editor = new PropertyCellEditor(tree);
        Component c = valueRenderer.getTableCellRendererComponent(null, "XXX", false, false, 0, 0);
        this.table.setRowHeight(c.getPreferredSize().height);
        tree.setRowHeight(c.getPreferredSize().height);
        tree.setCellRenderer(valueRenderer);
        this.table.getColumnModel().getColumn(0).setCellRenderer(tree);
        this.table.getColumnModel().getColumn(1).setCellRenderer(valueRenderer);
        this.table.setDefaultEditor(class$java$lang$Object == null ? (class$java$lang$Object = PropertyEditor.class$("java.lang.Object")) : class$java$lang$Object, editor);
        this.table.addMouseListener(new PropertyTableMouseListener());
    }

    private void initButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        final JButton apply = new JButton("Apply Changes");
        this.closeButton = new JButton("Dismiss");
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == apply) {
                    PropertyEditor.this.globalApplyChanges();
                } else if (e.getSource() == PropertyEditor.this.closeButton) {
                    PropertyEditor.this.dismissDialog();
                }
            }
        };
        apply.addActionListener(al);
        this.closeButton.addActionListener(al);
        buttonPanel.add(apply);
        buttonPanel.add(this.closeButton);
        this.add((Component)buttonPanel, "South");
    }

    private void globalApplyChanges() {
        TreeTableModel model = (TreeTableModel)this.table.getModel();
        PropertyTreeNode root = (PropertyTreeNode)model.getRoot();
        try {
            root.flush();
        }
        catch (InvocationTargetException ite) {
            DasExceptionHandler.handle(ite.getCause());
        }
    }

    private void dismissDialog() {
        PropertyTreeNode root = (PropertyTreeNode)((TreeTableModel)this.table.getModel()).getRoot();
        if (root.isDirty()) {
            String[] message = new String[]{"You have unsaved changes", "Would you like to apply them?"};
            int result = JOptionPane.showConfirmDialog(this, message, "", 1, 3);
            if (result == 2) {
                return;
            }
            if (result == 0) {
                this.globalApplyChanges();
            }
        }
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public void showDialog(Component c) {
        if (this.dialog == null) {
            Container top;
            Container container = c == null ? null : (top = SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = PropertyEditor.class$("java.awt.Window")) : class$java$awt$Window, c));
            this.dialog = top instanceof JFrame ? new JDialog((JFrame)top) : (top instanceof JDialog ? new JDialog((JDialog)top) : new JDialog());
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    PropertyEditor.this.dismissDialog();
                }
            });
            this.dialog.setContentPane(this);
            this.dialog.pack();
        }
        if (c != null) {
            this.dialog.setLocationRelativeTo(c);
        }
        this.dialog.setVisible(true);
    }

    public void doLayout() {
        if (SwingUtilities.isDescendingFrom(this, this.dialog)) {
            this.closeButton.setVisible(true);
        } else {
            this.closeButton.setVisible(false);
        }
        super.doLayout();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class PropertyTableMouseListener
    extends MouseAdapter {
        PropertyTableMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            int row = PropertyEditor.this.table.rowAtPoint(p);
            int column = PropertyEditor.this.table.columnAtPoint(p);
            TreeTableModel model = (TreeTableModel)PropertyEditor.this.table.getModel();
            PropertyTreeNode node = (PropertyTreeNode)model.getNodeForRow(row);
            if (!node.isLeaf()) {
                model.toggleExpanded(row);
            }
        }
    }
}

