/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.DatumRangeUtil;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.event.TimeRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;

public class DasTimeRangeSelector
extends JPanel
implements TimeRangeSelectionListener {
    private DatumRange range = null;
    JTextField idStart = null;
    JTextField idStop = null;
    JButton viewButton = null;
    JPanel startStopPane = null;
    boolean updateRangeString = false;
    private EventListenerList listenerList = null;
    protected final Action previousAction = new AbstractAction("<<"){

        public void actionPerformed(ActionEvent e) {
            DasTimeRangeSelector.this.fireTimeRangeSelectedPrevious();
        }
    };
    protected final Action nextAction = new AbstractAction(">>"){

        public void actionPerformed(ActionEvent e) {
            DasTimeRangeSelector.this.fireTimeRangeSelectedNext();
        }
    };
    protected final Action rangeAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            DasTimeRangeSelector.this.fireTimeRangeSelected();
        }
    };
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener;

    public DasTimeRangeSelector() {
        this.updateRangeString = Preferences.userNodeForPackage(this.getClass()).getBoolean("updateRangeString", false);
        this.buildComponents();
    }

    private Action getModeAction() {
        return new AbstractAction("mode"){

            public void actionPerformed(ActionEvent e) {
                DasTimeRangeSelector.this.updateRangeString = !DasTimeRangeSelector.this.updateRangeString;
                Preferences.userNodeForPackage(this.getClass()).putBoolean("updateRangeString", DasTimeRangeSelector.this.updateRangeString);
                DasTimeRangeSelector.this.revalidateUpdateMode();
                DasTimeRangeSelector.this.update();
            }
        };
    }

    private void revalidateUpdateMode() {
        if (this.updateRangeString) {
            this.idStart.setColumns(28);
            this.idStop.setVisible(false);
            this.viewButton.setVisible(true);
        } else {
            this.idStart.setColumns(18);
            this.idStop.setVisible(true);
        }
        this.startStopPane.revalidate();
    }

    private void buildComponents() {
        this.setLayout(new FlowLayout());
        JButton b = new JButton();
        b.setAction(this.previousAction);
        b.setActionCommand("previous");
        b.setToolTipText("Scan back in time");
        this.add(b);
        this.startStopPane = new JPanel(new FlowLayout());
        this.idStart = new JTextField(18);
        this.idStart.setAction(this.rangeAction);
        this.idStart.setActionCommand("startTime");
        this.startStopPane.add(this.idStart);
        this.idStop = new JTextField(18);
        this.idStop.addActionListener(this.rangeAction);
        this.idStop.setActionCommand("endTime");
        this.startStopPane.add(this.idStop);
        this.viewButton = new JButton(this.getModeAction());
        this.viewButton.setToolTipText("input mode: start/end vs time range string");
        this.viewButton.setPreferredSize(new Dimension(20, 20));
        this.startStopPane.add(this.viewButton);
        this.add(this.startStopPane);
        b = new JButton();
        b.setAction(this.nextAction);
        b.setActionCommand("next");
        b.setToolTipText("Scan forward in time");
        this.add(b);
        this.revalidateUpdateMode();
    }

    public DasTimeRangeSelector(Datum startTime, Datum endTime) {
        this(new DatumRange(startTime, endTime));
    }

    public DasTimeRangeSelector(DatumRange range) {
        this();
        this.range = range;
        this.update();
    }

    private void parseRange() {
        boolean updateRangeString0 = this.updateRangeString;
        if (this.idStop.getText().equals("")) {
            try {
                DatumRange dr;
                String rangeString = this.idStart.getText();
                this.range = dr = DatumRangeUtil.parseTimeRange(rangeString);
                this.updateRangeString = true;
            }
            catch (ParseException e) {
                DasExceptionHandler.handle(e);
            }
        } else {
            this.updateRangeString = false;
            try {
                Datum s1 = TimeUtil.create(this.idStart.getText());
                Datum s2 = TimeUtil.create(this.idStop.getText());
                this.range = new DatumRange(s1, s2);
            }
            catch (ParseException e) {
                DasExceptionHandler.handle(e);
            }
        }
        if (this.updateRangeString != updateRangeString0) {
            Preferences.userNodeForPackage(this.getClass()).putBoolean("updateRangeString", this.updateRangeString);
        }
    }

    public Datum getStartTime() {
        this.parseRange();
        return this.range.min();
    }

    public Datum getEndTime() {
        this.parseRange();
        return this.range.max();
    }

    public DatumRange getRange() {
        return this.range;
    }

    public void setRange(DatumRange range) {
        this.range = range;
        this.update();
    }

    private void update() {
        if (this.range != null) {
            if (this.updateRangeString) {
                String rangeString = DatumRangeUtil.formatTimeRange(this.range);
                this.idStart.setText(rangeString);
                this.idStop.setText("");
            } else {
                this.idStart.setText(this.range.min().toString());
                this.idStop.setText(this.range.max().toString());
            }
        }
    }

    public void setStartTime(Datum s1) {
        if (this.range == null) {
            return;
        }
        Datum endTime = this.range.max();
        if (endTime.le(s1)) {
            endTime = s1.add(1.0, Units.seconds);
        }
        this.range = new DatumRange(s1, endTime);
        this.update();
    }

    public void setEndTime(Datum s2) {
        if (this.range == null) {
            return;
        }
        Datum startTime = this.range.min();
        if (startTime.ge(s2)) {
            startTime = s2.subtract(1.0, Units.seconds);
        }
        this.range = new DatumRange(startTime, s2);
        this.update();
    }

    public boolean isWithin(Datum s1, Datum s2) {
        Datum startTime = this.getStartTime();
        Datum endTime = this.getEndTime();
        return s1.compareTo(startTime) <= 0 && endTime.compareTo(s2) <= 0;
    }

    public void timeRangeSelected(TimeRangeSelectionEvent e) {
        DatumRange range = e.getRange();
        if (!range.equals(this.range)) {
            this.setRange(e.getRange());
            this.fireTimeRangeSelected(e);
        }
    }

    public synchronized void addTimeRangeSelectionListener(TimeRangeSelectionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener = DasTimeRangeSelector.class$("edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener")) : class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener, listener);
    }

    public synchronized void removeTimeRangeSelectionListener(TimeRangeSelectionListener listener) {
        this.listenerList.remove(class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener = DasTimeRangeSelector.class$("edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener")) : class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener, listener);
    }

    protected void fireTimeRangeSelectedPrevious() {
        this.range = this.range.previous();
        this.update();
        this.fireTimeRangeSelected(new TimeRangeSelectionEvent(this, this.range));
    }

    protected void fireTimeRangeSelectedNext() {
        this.range = this.range.next();
        this.update();
        this.fireTimeRangeSelected(new TimeRangeSelectionEvent(this, this.range));
    }

    protected void fireTimeRangeSelected() {
        this.parseRange();
        this.update();
        this.fireTimeRangeSelected(new TimeRangeSelectionEvent(this, this.range));
    }

    protected void fireTimeRangeSelected(TimeRangeSelectionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener == null ? DasTimeRangeSelector.class$("edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener") : class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener)) continue;
            ((TimeRangeSelectionListener)listeners[i + 1]).timeRangeSelected(event);
        }
    }

    public Dimension getMaximumSize() {
        return super.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return super.getPreferredSize();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

