/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionListener;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasPNGEncoder;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.event.EventListenerList;

public class BatchMaster {
    List taskList;
    int itask;
    DasCanvas canvas;
    TaskOutputDescriptor tod;
    boolean exit = true;
    public static Timer timer = new Timer();
    private EventListenerList listenerList = null;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener;

    private String insertRange(String filenameTemplate, DatumRange range) {
        String rangeString = range.toString().replaceAll(":", "-").replaceAll(" ", "_");
        String s = filenameTemplate.replaceAll("BEGIN", range.min().toString().replaceAll(":", "-")).replaceAll("END", range.max().toString().replaceAll(":", "-")).replaceAll("RANGE", rangeString);
        return s;
    }

    public TaskOutputDescriptor createPngsTaskOutputDescriptor(final String pngFilenameTemplate) {
        return new TaskOutputDescriptor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completeTask(DatumRange range) {
                Image image = BatchMaster.this.canvas.getImage(BatchMaster.this.canvas.getWidth(), BatchMaster.this.canvas.getHeight());
                String s = BatchMaster.this.insertRange(pngFilenameTemplate, range);
                try {
                    FileOutputStream out = new FileOutputStream(s);
                    try {
                        DasPNGEncoder encoder = new DasPNGEncoder();
                        encoder.addText("Creation Time", new Date().toString());
                        encoder.write((BufferedImage)image, out);
                    }
                    finally {
                        ((OutputStream)out).close();
                    }
                }
                catch (IOException e) {
                    DasExceptionHandler.handle(e);
                }
            }
        };
    }

    private void readStartEndSpecFile(File specFile) throws ParseException, IOException {
        BufferedReader r = new BufferedReader(new FileReader(specFile));
        String s = r.readLine();
        while (s != null) {
            if (!(s = s.trim()).equals("") && !s.startsWith("#")) {
                String[] s1 = s.split(" ");
                Datum begin = TimeUtil.create(s1[0]);
                Datum end = TimeUtil.create(s1[1]);
                this.addTask(begin, end);
            }
            s = r.readLine();
        }
    }

    public static BatchMaster createPngs(DasCanvas canvas, File specFile, String pngFilenameTemplate) throws ParseException, IOException {
        ArrayList taskList = new ArrayList();
        BatchMaster result = new BatchMaster(canvas);
        result.setTaskOutputDescriptor(result.createPngsTaskOutputDescriptor(pngFilenameTemplate));
        result.readStartEndSpecFile(specFile);
        return result;
    }

    public BatchMaster(DasCanvas canvas) {
        this.canvas = canvas;
        this.taskList = new ArrayList();
        this.itask = 0;
    }

    public void start() {
        this.submitNextTask();
    }

    void addTask(Datum begin, Datum end) {
        this.taskList.add(new DataRangeSelectionEvent(this, begin, end));
    }

    void setTaskOutputDescriptor(TaskOutputDescriptor tod) {
        this.tod = tod;
    }

    void setExitAfterCompletion(boolean val) {
        this.exit = val;
    }

    void submitNextTask() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                if (BatchMaster.this.itask >= BatchMaster.this.taskList.size()) {
                    if (BatchMaster.this.exit) {
                        System.exit(0);
                    }
                } else {
                    DasApplication.getDefaultApplication().getLogger(DasApplication.SYSTEM_LOG).info("itask=" + BatchMaster.this.taskList.get(BatchMaster.this.itask));
                    DataRangeSelectionEvent ev = (DataRangeSelectionEvent)BatchMaster.this.taskList.get(BatchMaster.this.itask++);
                    BatchMaster.this.fireDataRangeSelectionListenerDataRangeSelected(ev);
                    BatchMaster.this.canvas.waitUntilIdle();
                    BatchMaster.this.tod.completeTask(ev.getDatumRange());
                    BatchMaster.this.submitNextTask();
                }
            }
        });
        thread.start();
    }

    public synchronized void addDataRangeSelectionListener(DataRangeSelectionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener = BatchMaster.class$("edu.uiowa.physics.pw.das.event.DataRangeSelectionListener")) : class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener, listener);
    }

    public synchronized void removeDataRangeSelectionListener(DataRangeSelectionListener listener) {
        this.listenerList.remove(class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener = BatchMaster.class$("edu.uiowa.physics.pw.das.event.DataRangeSelectionListener")) : class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener, listener);
    }

    private void fireDataRangeSelectionListenerDataRangeSelected(DataRangeSelectionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener == null ? BatchMaster.class$("edu.uiowa.physics.pw.das.event.DataRangeSelectionListener") : class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener)) continue;
            ((DataRangeSelectionListener)listeners[i + 1]).DataRangeSelected(event);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface TaskOutputDescriptor {
        public void completeTask(DatumRange var1);
    }

    public static class Timer {
        long t0 = System.currentTimeMillis();
        DecimalFormat df = new DecimalFormat("00000.000");

        public void reportTime(String msg) {
            Thread thread = Thread.currentThread();
            long elapsed = System.currentTimeMillis() - this.t0;
            System.out.println(this.df.format((double)elapsed / 1000.0) + " " + msg + "(" + thread + ")");
        }
    }
}

