/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.client;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasIOException;
import edu.uiowa.physics.pw.das.client.Authenticator;
import edu.uiowa.physics.pw.das.client.DasServer;
import edu.uiowa.physics.pw.das.client.DasServerException;
import edu.uiowa.physics.pw.das.client.Key;
import edu.uiowa.physics.pw.das.client.MeteredInputStream;
import edu.uiowa.physics.pw.das.client.NoSuchDataSetException;
import edu.uiowa.physics.pw.das.client.StandardDataStreamSource;
import edu.uiowa.physics.pw.das.client.StreamDataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.AccessDeniedException;
import edu.uiowa.physics.pw.das.dataset.NoDataInIntervalException;
import edu.uiowa.physics.pw.das.dataset.NoKeyProvidedException;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.stream.StreamYScanDescriptor;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.URLBuddy;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;

public class WebStandardDataStreamSource
implements StandardDataStreamSource {
    private DasServer server;
    private MeteredInputStream min;
    private boolean legacyStream = true;
    private String extraParameters;

    public WebStandardDataStreamSource(DasServer server, URL url) {
        String[] query;
        this.server = server;
        String[] stringArray = query = url.getQuery() == null ? new String[]{} : url.getQuery().split("&");
        if (query.length >= 2) {
            this.extraParameters = query[1];
        }
    }

    public boolean isLegacyStream() {
        return this.legacyStream;
    }

    public InputStream getInputStream(StreamDataSetDescriptor dsd, Datum start, Datum end) throws DasException {
        String serverType = "dataset";
        StringBuffer formData = new StringBuffer();
        formData.append("server=").append(serverType);
        InputStream in = this.openURLConnection(dsd, start, end, formData);
        MeteredInputStream min = new MeteredInputStream(in);
        min.setSpeedLimit(3300.0);
        return min;
    }

    public InputStream getReducedInputStream(StreamDataSetDescriptor dsd, Datum start, Datum end, Datum timeResolution) throws DasException {
        StringBuffer formData = new StringBuffer();
        String form = (String)dsd.getProperty("form");
        if ("true".equals(dsd.getProperty("legacy")) && "x_tagged_y_scan".equals(form)) {
            formData.append("server=compactdataset");
            StreamYScanDescriptor y = (StreamYScanDescriptor)dsd.getDefaultPacketDescriptor().getYDescriptors().get(0);
            formData.append("&nitems=").append(y.getNItems() + 1);
            if (timeResolution != null) {
                formData.append("&resolution=").append(timeResolution.doubleValue(Units.seconds));
            }
        } else if ("x_multi_y".equals(form) && dsd.getProperty("items") != null) {
            formData.append("server=dataset");
            if (timeResolution != null) {
                formData.append("&interval=").append(timeResolution.doubleValue(Units.seconds));
            }
        } else {
            formData.append("server=compactdataset");
            if (timeResolution != null) {
                formData.append("&resolution=").append(timeResolution.doubleValue(Units.seconds));
            }
        }
        if (this.extraParameters != null) {
            formData.append("&params=").append(this.extraParameters);
        }
        boolean compress = false;
        if (this.min != null) {
            DasDie.println(DasDie.DEBUG, "last transfer speed (byte/sec)= " + this.min.calcTransmitSpeed());
            DasDie.println(DasDie.DEBUG, "   time to transfer (sec)= " + this.min.calcTransmitTime());
            DasDie.println(DasDie.DEBUG, "   total kbytes transferred= " + this.min.totalBytesTransmitted() / 1024L);
        }
        if (this.min != null && this.min.calcTransmitSpeed() > 30000.0) {
            compress = false;
        }
        if (compress) {
            formData.append("&compress=true");
        }
        InputStream in = this.openURLConnection(dsd, start, end, formData);
        this.min = new MeteredInputStream(in);
        return this.min;
    }

    private String createFormDataString(String dataSetID, Datum start, Datum end, StringBuffer additionalFormData) throws UnsupportedEncodingException {
        DatumFormatter formatter = start.getUnits().getDatumFormatterFactory().defaultFormatter();
        String startStr = formatter.format(start);
        String endStr = formatter.format(end);
        StringBuffer formData = new StringBuffer("dataset=");
        formData.append(URLBuddy.encodeUTF8(dataSetID));
        formData.append("&start_time=").append(URLBuddy.encodeUTF8(startStr));
        formData.append("&end_time=").append(URLBuddy.encodeUTF8(endStr));
        formData.append("&").append(additionalFormData);
        return formData.toString();
    }

    protected synchronized InputStream openURLConnection(StreamDataSetDescriptor dsd, Datum start, Datum end, StringBuffer additionalFormData) throws DasException {
        String[] tokens = dsd.getDataSetID().split("\\?|\\&");
        String dataSetID = tokens[1];
        try {
            Key key;
            String formData = this.createFormDataString(dataSetID, start, end, additionalFormData);
            if (dsd.isRestrictedAccess() && (key = this.server.getKey("")) != null) {
                formData = formData + "&key=" + URLEncoder.encode(key.toString(), "UTF-8");
            }
            URL serverURL = this.server.getURL(formData);
            DasApplication.getDefaultApplication().getLogger().info(serverURL.toString());
            URLConnection urlConnection = serverURL.openConnection();
            urlConnection.connect();
            String contentType = urlConnection.getContentType();
            if (!contentType.equalsIgnoreCase("application/octet-stream")) {
                BufferedReader bin = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                String line = bin.readLine();
                String message = "";
                while (line != null) {
                    message = message.concat(line);
                    line = bin.readLine();
                }
                throw new DasIOException(message);
            }
            InputStream in = serverURL.openStream();
            if (this.isLegacyStream()) {
                return this.processLegacyStream(in);
            }
            throw new UnsupportedOperationException();
        }
        catch (IOException e) {
            throw new DasIOException(e.getMessage());
        }
    }

    private InputStream processLegacyStream(InputStream in) throws IOException, DasException {
        BufferedInputStream bin = new BufferedInputStream(in);
        bin.mark(Integer.MAX_VALUE);
        String serverResponse = this.readServerResponse(bin);
        if (serverResponse.equals("")) {
            return bin;
        }
        if (serverResponse.equals("<noDataInInterval/>")) {
            throw new NoDataInIntervalException("no data in interval");
        }
        String errorTag = "error";
        if (serverResponse.startsWith("<" + errorTag + ">")) {
            int index2 = serverResponse.indexOf("</" + errorTag + ">");
            String error = serverResponse.substring(errorTag.length() + 2, serverResponse.length() - (errorTag.length() + 3));
            DasDie.println("error=" + error);
            if (error.equals("<needKey/>")) {
                throw new NoKeyProvidedException("");
            }
            if (error.equals("<accessDenied/>")) {
                this.server.setKey(null);
                this.server.getKey("");
                throw new AccessDeniedException("");
            }
            if (error.equals("<invalidKey/>")) {
                throw new NoKeyProvidedException("invalid Key");
            }
            if (error.equals("<noSuchDataSet/>")) {
                throw new NoSuchDataSetException("");
            }
            throw new DasServerException("Error response from server: " + error);
        }
        return bin;
    }

    private String readServerResponse(InputStream in) {
        String das2Response;
        byte[] data = new byte[4096];
        int lastBytesRead = -1;
        int offset = 0;
        try {
            int bytesRead = in.read(data, offset, 4096 - offset);
            String das2ResponseTag = "das2Response";
            if (bytesRead < das2ResponseTag.length() + 2) {
                offset += bytesRead;
                bytesRead = in.read(data, offset, 4096 - offset);
            }
            if (new String(data, 0, 14, "UTF-8").equals("<" + das2ResponseTag + ">")) {
                while (new String(data, 0, offset, "UTF-8").indexOf("</" + das2ResponseTag + ">") == -1 && offset < 4096) {
                    bytesRead = in.read(data, offset += bytesRead, 4096 - offset);
                }
                int index = new String(data, 0, offset, "UTF-8").indexOf("</" + das2ResponseTag + ">");
                das2Response = new String(data, 14, index - 14);
                DasDie.println("das2Response=" + das2Response);
                in.reset();
                in.skip(das2Response.length() + 2 * das2ResponseTag.length() + 5);
            } else {
                in.reset();
                das2Response = "";
            }
        }
        catch (IOException e) {
            das2Response = "";
        }
        return das2Response;
    }

    public void reset() {
    }

    public void authenticate(String restrictedResourceLabel) {
        Authenticator authenticator = new Authenticator(this.server, restrictedResourceLabel);
        Key key = authenticator.authenticate();
        if (key != null) {
            this.server.setKey(key);
        }
    }
}

