/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.client;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasIOException;
import edu.uiowa.physics.pw.das.client.DataSetStreamHandler;
import edu.uiowa.physics.pw.das.client.StandardDataStreamSource;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSetBuilder;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSetBuilder;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.stream.PacketDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamMultiYDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamYScanDescriptor;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.DasProgressMonitorInputStream;
import edu.uiowa.physics.pw.das.util.StreamTool;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class StreamDataSetDescriptor
extends DataSetDescriptor {
    protected StandardDataStreamSource standardDataStreamSource;
    private boolean serverSideReduction = true;
    private PacketDescriptor defaultPacketDescriptor;
    private static final byte[] HEADER = new byte[]{100, 97, 115, 50, 127, 127};

    public Units getXUnits() {
        return this.defaultPacketDescriptor.getXDescriptor().getUnits();
    }

    protected StreamDataSetDescriptor(Map properties) {
        this.setProperties(properties);
    }

    protected StreamDataSetDescriptor(Map properties, boolean legacy) {
        this.setProperties(properties, legacy);
    }

    public StreamDataSetDescriptor(StreamDescriptor sd, StandardDataStreamSource sdss) {
        this(sd.getProperties(), "true".equals(sd.getProperty("legacy")));
        this.standardDataStreamSource = sdss;
    }

    public void setStandardDataStreamSource(StandardDataStreamSource sdss) {
        this.standardDataStreamSource = sdss;
    }

    public StandardDataStreamSource getStandardDataStreamSource() {
        return this.standardDataStreamSource;
    }

    protected void setProperties(Map properties, boolean legacy) {
        super.setProperties(properties);
        if (properties.containsKey("form") && properties.get("form").equals("x_multi_y") && properties.containsKey("items")) {
            this.setDefaultCaching(false);
        }
        if (legacy) {
            this.defaultPacketDescriptor = PacketDescriptor.createLegacyPacketDescriptor(properties);
        }
    }

    protected void setProperties(Map properties) {
        this.setProperties(properties, false);
    }

    protected float[] readFloats(InputStream in) throws DasException {
        byte[] data = this.readBytes(in);
        float[] f = new float[data.length / 4];
        ByteBuffer buff = ByteBuffer.wrap(data);
        FloatBuffer fbuff = buff.asFloatBuffer();
        fbuff.get(f);
        return f;
    }

    protected double[] readDoubles(InputStream in) throws DasException {
        byte[] data = this.readBytes(in);
        double[] d = new double[data.length / 4];
        ByteBuffer buff = ByteBuffer.wrap(data);
        FloatBuffer fbuff = buff.asFloatBuffer();
        for (int i = 0; i < d.length; ++i) {
            d[i] = fbuff.get();
        }
        return d;
    }

    private ByteBuffer getByteBuffer(InputStream in) throws DasException {
        byte[] data = this.readBytes(in);
        ByteBuffer buffer = ByteBuffer.wrap(data);
        return buffer;
    }

    protected byte[] readBytes(InputStream in) throws DasException {
        LinkedList<byte[]> list = new LinkedList<byte[]>();
        byte[] data = new byte[4096];
        int bytesRead = 0;
        int totalBytesRead = 0;
        int lastBytesRead = -1;
        int offset = 0;
        long time = System.currentTimeMillis();
        try {
            bytesRead = in.read(data, offset, 4096 - offset);
            while (bytesRead != -1) {
                int bytesSoFar = totalBytesRead;
                lastBytesRead = offset += bytesRead;
                if (offset == 4096) {
                    list.addLast(data);
                    data = new byte[4096];
                    offset = 0;
                }
                totalBytesRead += bytesRead;
                bytesRead = in.read(data, offset, 4096 - offset);
            }
        }
        catch (IOException e) {
            throw new DasIOException(e);
        }
        if (lastBytesRead >= 0 && lastBytesRead < 4096) {
            list.addLast(data);
        }
        if (list.size() == 0) {
            throw new DasIOException("Error reading data: no data available");
        }
        int dataLength = (list.size() - 1) * 4096 + lastBytesRead;
        data = new byte[dataLength];
        Iterator iterator = list.iterator();
        for (int i = 0; i < list.size() - 1; ++i) {
            System.arraycopy(list.get(i), 0, data, i * 4096, 4096);
        }
        System.arraycopy(list.get(list.size() - 1), 0, data, (list.size() - 1) * 4096, lastBytesRead);
        return data;
    }

    public String toString() {
        return this.getDataSetID();
    }

    protected DataSet getDataSetImpl(Datum start, Datum end, Datum resolution, DasProgressMonitor monitor) throws DasException {
        InputStream in;
        if (resolution != null && !resolution.isFinite()) {
            throw new IllegalArgumentException("resolution is not finite");
        }
        if (this.isServerSideReduction()) {
            DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).info("getting stream from standard data stream source");
            in = this.standardDataStreamSource.getReducedInputStream(this, start, end, resolution);
        } else {
            in = this.standardDataStreamSource.getInputStream(this, start, end);
        }
        DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).info("reading stream");
        DataSet result = this.getDataSetFromStream(in, start, end, monitor);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DataSet getDataSetFromStream(InputStream in, Datum start, Datum end, DasProgressMonitor monitor) throws DasException {
        PushbackInputStream pin = new PushbackInputStream(in, 4096);
        try {
            byte[] four = new byte[4];
            int bytesRead = pin.read(four);
            DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).finer("read first four bytes bytesRead=" + bytesRead);
            if (bytesRead != 4) {
                DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).info("no data returned from server");
                throw new DasIOException("No data returned from server");
            }
            if (new String(four).equals("[00]")) {
                DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).finer("got stream header [00]");
                pin.unread(four);
                if (monitor == null) {
                    monitor = DasProgressMonitor.NULL;
                }
                monitor.started();
                DasProgressMonitorInputStream mpin = new DasProgressMonitorInputStream(pin, monitor);
                DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).finer("creating Channel");
                ReadableByteChannel channel = Channels.newChannel(mpin);
                DataSetStreamHandler handler = new DataSetStreamHandler(this.properties, monitor, start, end);
                DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).finer("using StreamTool to read the stream");
                StreamTool.readStream(channel, handler);
                DataSet dataSet = handler.getDataSet();
                return dataSet;
            }
            pin.unread(four);
            if (monitor != null) {
                monitor.started();
            }
            DasProgressMonitorInputStream mpin = new DasProgressMonitorInputStream(pin, monitor);
            if (this.getProperty("form").equals("x_tagged_y_scan")) {
                DataSet dataSet = this.getLegacyTableDataSet(mpin, start);
                return dataSet;
            }
            if (this.getProperty("form").equals("x_multi_y")) {
                DataSet dataSet = this.getLegacyVectorDataSet(mpin, start);
                return dataSet;
            }
            throw new IllegalStateException("Unrecognized data set type: " + this.getProperty("form"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
        catch (IOException ioe) {
            throw new DasIOException(ioe);
        }
        finally {
            try {
                pin.close();
            }
            catch (IOException ioe) {}
        }
    }

    private static String getPacketID(byte[] four) throws DasException {
        if (four[0] == 91 && four[3] == 93 || four[0] == 58 && four[3] == 58) {
            return new String(new char[]{(char)four[1], (char)four[2]});
        }
        throw new DasException("Invalid stream, expecting 4 byte header, encountered '" + new String(four) + "'");
    }

    private DataSet getLegacyVectorDataSet(InputStream in0, Datum start) throws DasException {
        try {
            PushbackInputStream in = new PushbackInputStream(in0, 50);
            PacketDescriptor sd = this.getPacketDescriptor(in);
            VectorDataSetBuilder builder = new VectorDataSetBuilder(start.getUnits(), Units.dimensionless);
            Iterator i = sd.getYDescriptors().iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (o instanceof StreamMultiYDescriptor) {
                    StreamMultiYDescriptor y = (StreamMultiYDescriptor)o;
                    String name = y.getName();
                    if (name != null && !name.equals("")) {
                        builder.addPlane(name, y.getUnits());
                        continue;
                    }
                    if (!"".equals(name)) continue;
                    builder.setYUnits(y.getUnits());
                    continue;
                }
                throw new DasIOException("Invalid Stream Header: Non-Y-descriptor encountered");
            }
            StreamMultiYDescriptor[] yDescriptors = sd.getYDescriptors().toArray(new StreamMultiYDescriptor[0]);
            int planeCount = yDescriptors.length - 1;
            String[] planeIDs = new String[planeCount];
            int recordSize = sd.getXDescriptor().getSizeBytes() + yDescriptors[0].getSizeBytes();
            for (int planeIndex = 0; planeIndex < planeCount; ++planeIndex) {
                planeIDs[planeIndex] = yDescriptors[planeIndex + 1].getName();
                recordSize += yDescriptors[planeIndex + 1].getSizeBytes();
            }
            ByteBuffer data = this.getByteBuffer(in);
            double timeBaseValue = start.doubleValue(start.getUnits());
            Units offsetUnits = start.getUnits().getOffsetUnits();
            UnitsConverter uc = sd.getXDescriptor().getUnits().getConverter(offsetUnits);
            while (data.remaining() > recordSize) {
                DatumVector vector = sd.getXDescriptor().read(data);
                double xTag = timeBaseValue + vector.doubleValue(0, offsetUnits);
                vector = yDescriptors[0].read(data);
                double yValue = vector.doubleValue(0, yDescriptors[0].getUnits());
                builder.insertY(xTag, yValue);
                for (int planeIndex = 0; planeIndex < planeCount; ++planeIndex) {
                    vector = yDescriptors[planeIndex + 1].read(data);
                    yValue = vector.doubleValue(0, yDescriptors[planeIndex + 1].getUnits());
                    builder.insertY(xTag, yValue, yDescriptors[planeIndex + 1].getName());
                }
            }
            if (this.properties.containsKey("x_sample_width")) {
                this.properties.put("xTagWidth", Datum.create((Double)this.properties.get("x_sample_width"), Units.seconds));
            }
            builder.addProperties(this.properties);
            VectorDataSet result = builder.toVectorDataSet();
            return result;
        }
        catch (DasException de) {
            de.printStackTrace();
            throw de;
        }
    }

    private DataSet getLegacyTableDataSet(InputStream in0, Datum start) throws DasException {
        PushbackInputStream in = new PushbackInputStream(in0, 50);
        PacketDescriptor sd = this.getPacketDescriptor(in);
        TableDataSetBuilder builder = new TableDataSetBuilder(start.getUnits(), Units.dimensionless, Units.dimensionless);
        Units yUnits = Units.dimensionless;
        Units zUnits = Units.dimensionless;
        Iterator i = sd.getYDescriptors().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof StreamYScanDescriptor) {
                StreamYScanDescriptor scan = (StreamYScanDescriptor)o;
                String name = scan.getName();
                if (name == null || name.equals("")) continue;
                builder.addPlane(name, scan.getZUnits());
                continue;
            }
            throw new DasIOException("Invalid Stream Header: Non-yScan descriptor encountered");
        }
        StreamYScanDescriptor[] yScans = sd.getYDescriptors().toArray(new StreamYScanDescriptor[0]);
        int planeCount = yScans.length;
        String[] planeIDs = new String[planeCount];
        int recordSize = sd.getXDescriptor().getSizeBytes();
        for (int planeIndex = 0; planeIndex < planeCount; ++planeIndex) {
            planeIDs[planeIndex] = yScans[planeIndex].getName();
            recordSize += yScans[planeIndex].getSizeBytes();
        }
        ByteBuffer data = this.getByteBuffer(in);
        double timeBaseValue = start.doubleValue(start.getUnits());
        Units offsetUnits = start.getUnits().getOffsetUnits();
        UnitsConverter uc = sd.getXDescriptor().getUnits().getConverter(offsetUnits);
        double[] yCoordinates = yScans[0].getYTags();
        DatumVector y = DatumVector.newDatumVector(yCoordinates, yUnits);
        while (data.remaining() > recordSize) {
            DatumVector vector = sd.getXDescriptor().read(data);
            Datum xTag = start.add(vector.get(0));
            DatumVector[] z = new DatumVector[planeCount];
            for (int planeIndex = 0; planeIndex < planeCount; ++planeIndex) {
                z[planeIndex] = yScans[planeIndex].read(data);
            }
            builder.insertYScan(xTag, y, z, planeIDs);
        }
        if (this.properties.containsKey("x_sample_width")) {
            this.properties.put("xTagWidth", Datum.create((Double)this.properties.get("x_sample_width"), Units.seconds));
        }
        builder.addProperties(this.properties);
        TableDataSet result = builder.toTableDataSet();
        return result;
    }

    private PacketDescriptor getPacketDescriptor(PushbackInputStream in) throws DasIOException {
        try {
            byte[] four = new byte[HEADER.length];
            int bytesRead = 0;
            int totalBytesRead = 0;
            do {
                if ((bytesRead = in.read(four, totalBytesRead, HEADER.length - totalBytesRead)) == -1) continue;
                totalBytesRead += bytesRead;
            } while (totalBytesRead < HEADER.length && bytesRead != -1);
            if (Arrays.equals(four, HEADER)) {
                byte[] header = StreamTool.advanceTo(in, "\u007f\u007f".getBytes());
                ByteArrayInputStream source = new ByteArrayInputStream(header);
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = builder.parse(source);
                Element docNode = document.getDocumentElement();
                PacketDescriptor packetDescriptor = new PacketDescriptor(docNode);
                return packetDescriptor;
            }
            in.unread(four, 0, totalBytesRead);
            return this.defaultPacketDescriptor;
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        catch (StreamTool.DelimeterNotFoundException dnfe) {
            DasIOException dioe = new DasIOException(dnfe.getMessage());
            dioe.initCause(dioe);
            throw dioe;
        }
        catch (SAXException ex) {
            DasIOException e = new DasIOException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
        catch (IOException ex) {
            throw new DasIOException(ex);
        }
    }

    public boolean isRestrictedAccess() {
        boolean result = this.getProperty("groupAccess") != null ? !"".equals(this.getProperty("groupAccess")) : false;
        return result;
    }

    public DasAxis getDefaultXAxis(DasRow row, DasColumn column) {
        return null;
    }

    public Renderer getRenderer(DasPlot plot) {
        return null;
    }

    public void setServerSideReduction(boolean x) {
        this.serverSideReduction = x;
    }

    public boolean isServerSideReduction() {
        return this.serverSideReduction;
    }

    public PacketDescriptor getDefaultPacketDescriptor() {
        return this.defaultPacketDescriptor;
    }
}

