/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.client;

import java.io.IOException;
import java.io.InputStream;

public class MeteredInputStream
extends InputStream {
    InputStream in;
    int totalBytesRead;
    long birthTimeMilli;
    long deathTimeMilli;
    double speedLimit;

    public MeteredInputStream(InputStream in) {
        this.in = in;
        this.totalBytesRead = 0;
        this.birthTimeMilli = System.currentTimeMillis();
        this.deathTimeMilli = -1L;
        this.speedLimit = 0.0;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.in.read(b, off, len);
        this.totalBytesRead += bytesRead;
        if (this.speedLimit > 0.0) {
            try {
                while (this.calcTransmitSpeed() > this.speedLimit) {
                    Thread.sleep(50L);
                }
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        return bytesRead;
    }

    public int read() throws IOException {
        int byteRead = this.in.read();
        ++this.totalBytesRead;
        return byteRead;
    }

    public void close() throws IOException {
        this.deathTimeMilli = System.currentTimeMillis();
        this.in.close();
    }

    public double calcTransmitSpeed() {
        long timeElapsed = this.deathTimeMilli > -1L ? this.deathTimeMilli - this.birthTimeMilli : System.currentTimeMillis() - this.birthTimeMilli;
        if (timeElapsed == 0L) {
            return Double.POSITIVE_INFINITY;
        }
        return (long)(1000 * this.totalBytesRead) / timeElapsed;
    }

    public double calcTransmitTime() {
        long timeElapsed = this.deathTimeMilli > -1L ? this.deathTimeMilli - this.birthTimeMilli : System.currentTimeMillis() - this.birthTimeMilli;
        return (double)timeElapsed / 1000.0;
    }

    public long totalBytesTransmitted() {
        return this.totalBytesRead;
    }

    public double getSpeedLimit() {
        return this.speedLimit;
    }

    public void setSpeedLimit(double speedLimit) {
        this.speedLimit = speedLimit;
    }
}

